#!/usr/local/bin/perl
# group_grace_save.cgi
# Update the grace times for groups on some filesystem

require './quota-lib.pl';
&ReadParse();
$whatfailed = "Failed to save grace times";
$access{'ggrace'} && &can_edit_filesys($in{'filesys'}) ||
	&error("You cannot edit grace times on this filesystem");

if ($in{'bdef'}) { push(@args, 0, 0); }
elsif ($in{'btime'} !~ /^[0-9\.]+$/)
	{ &error("'$in{'btime'}' is not a number"); }
else { push(@args, ($in{'btime'}, $in{'bunits'})); }

if ($in{'fdef'}) { push(@args, 0, 0); }
elsif ($in{'ftime'} !~ /^[0-9\.]+$/)
	{ &error("'$in{'ftime'}' is not a number"); }
else { push(@args, ($in{'ftime'}, $in{'funits'})); }

&edit_group_grace($in{'filesys'}, @args);
&redirect("list_groups.cgi?$in{'filesys'}");

