#!/usr/local/bin/perl
# group_filesys.cgi
# List all filesystems for which some group has quotas

require './quota-lib.pl';
&ReadParse();
$u = $in{'group'};
&can_edit_group($u) ||
	&error("You cannot edit quotas for '$u'");
&header("Group Quotas", "", "group_filesys");
print "<hr>\n";

foreach $f (&list_filesystems()) {
	if ($f->[4] > 1 && $f->[5] && &can_edit_filesys($f->[0])) {
		push(@fslist, $f->[0]);
		$fslist{$f->[0]}++;
		}
	}

$n = &group_filesystems($u);
if ($n) {
	print "<h3>All Quotas for <tt>$u</tt></h3>\n";
	print "<table border width=100%>\n";
	print "<tr $tb> <td></td>\n";
	print "<td colspan=3 align=center><b>Blocks</b></td>\n";
	print "<td colspan=3 align=center><b>Files</b></td> </tr>\n";
	print "<tr $tb> <td><b>Filesystem</b></td>\n";
	print "<td><b>Used</b></td> <td><b>Soft Limit</b></td>\n";
	print "<td><b>Hard Limit</b></td> <td><b>Used</b></td>\n";
	print "<td><b>Soft Limit</b></td> <td><b>Hard Limit</b></td> </tr>\n";
	for($i=0; $i<$n; $i++) {
		$f = $filesys{$i,'filesys'};
		print "<tr $cb>\n";
		if ($fslist{$f}) {
			print "<td><a href=\"edit_group_quota.cgi?filesys=$f&group=$u&source=1\">$f</a></td>\n";
			}
		else { print "<td>$f</td>\n"; }
		print "<td>$filesys{$i,'ublocks'}</td>\n";
		&print_limit($filesys{$i,'sblocks'});
		&print_limit($filesys{$i,'hblocks'});
		print "<td>$filesys{$i,'ufiles'}</td>\n";
		&print_limit($filesys{$i,'sfiles'});
		&print_limit($filesys{$i,'hfiles'});
		print "</tr>\n";
		}
	print "</table><br>\n";
	}
else {
	print "<b>Group <tt>$u</tt> does not have quotas on any ",
	      "filesystem</b><br>\n";
	}

print "<table width=100%><tr>\n";
print "<form action=edit_group_quota.cgi>\n";
print "<input type=hidden name=group value=\"$u\">\n";
print "<input type=hidden name=source value=1>\n";
print "<td align=left><input type=submit value=\"Edit Quota On:\">\n";
print "<select name=filesys>\n";
foreach $f (@fslist) { print "<option>$f\n"; }
print "</select></td></form>\n";

if ($access{'filesys'} eq "*") {
	print "<form action=copy_group_form.cgi>\n";
	print "<input type=hidden name=group value=\"$u\">\n";
	print "<td align=right><input type=submit value=\"Copy Quotas\">\n";
	print "</td></form>\n";
	}
print "</tr></table>\n";

print "<hr>\n";
&footer("", "filesystems list");

sub print_limit
{
if ($_[0] == 0) { print "<td>Unlimited</td>\n"; }
else { print "<td>$_[0]</td>\n"; }
}

