#!/usr/local/bin/perl
# edit_user_quota.cgi
# Display a form for editing the quotas for a user on some filesystem

require './quota-lib.pl';
&ReadParse();
$u = $in{'user'}; $fs = $in{'filesys'};
&can_edit_user($u) ||
	&error("You are not allowed to edit quotas for '$u'");
&can_edit_filesys($fs) ||
	&error("You are not allowed to edit quotas on this filesystem");
&header("Edit Quota", "", "edit_user_quota");
print "<hr>\n";

@quot = &user_quota($u, $fs);
$first = (@quot == 0);
print "<table border width=100%>\n";
print "<form action=save_user_quota.cgi>\n";
print "<input type=hidden name=user value=\"$u\">\n";
print "<input type=hidden name=filesys value=\"$fs\">\n";
print "<input type=hidden name=source value=$in{'source'}>\n";
print "<tr $tb> <td colspan=2><b>Quota for <tt>$u</tt> ",
      "on <tt>$fs</tt></b></td> </tr>\n";
print "<tr $cb> <td width=50%><table width=100%>\n";

if (!$first) {
	print "<tr> <td><b>Blocks Used</b></td> <td>$quot[0]</td> </tr>\n",
	}
print "<tr> <td><b>Soft Block Limit</b></td> <td>\n";
&quota_input("sblocks", $quot[1]);
print "<tr> <td><b>Hard Block Limit</b></td> <td>\n";
&quota_input("hblocks", $quot[2]);

print "</table></td><td width=50%><table width=100%>\n";
if (!$first) {
	print "<tr> <td><b>Files Used</b></td> <td>$quot[3]</td> </tr>\n",
	}
print "<tr> <td><b>Soft File Limit</b></td> <td>\n";
&quota_input("sfiles", $quot[4]);
print "<tr> <td><b>Hard File Limit</b></td> <td>\n";
&quota_input("hfiles", $quot[5]);

print "</table></td></tr></table>\n";

print "<table width=100%><tr>\n";
print "<td><input type=submit value=Update></td>\n";
print "</form><form action=user_filesys.cgi>\n";
print "<input type=hidden name=user value=\"$u\">\n";
print "<td align=right><input type=submit value=\"List All Quotas\"></td>\n";
print "</form></tr></table>\n";

print "<hr>\n";
if ($in{'source'}) { &footer("user_filesys.cgi?user=$u", "filesystem list"); }
else { &footer("list_users.cgi?$fs", "user list"); }

