#!/usr/local/bin/perl
# copy_group_form.cgi
# Display a form for copying some group's quotas to others

require './quota-lib.pl';
&ReadParse();
$access{'filesys'} eq "*" ||
	&error("You cannot copy quotas");
&can_edit_group($in{'group'}) ||
	&error("You are not allowed to copy the quotas of this group");
&header("Copy Quotas", "", "copy_group");
print "<hr>\n";

print "<form action=copy_group.cgi>\n";
print "<input type=hidden name=group value=\"$in{'group'}\">\n";
print "<b>Copy quotas for <tt>$in{'group'}</tt> on ",
      "ALL filesystems to ...</b><p>\n";
print "<ul>\n";
print "<input type=radio name=dest value=0 checked> ",
      "<b>All groups on your system</b><br>\n";
print "<input type=radio name=dest value=1> <b>Selected groups</b>\n";
print "<input name=groups size=30> ",&group_chooser_button("groups",1),"<br>\n";
print "<input type=radio name=dest value=2> ",
      "<b>Groups containing users</b>\n";
print "<input name=users size=30> ",&user_chooser_button("users",1),"<br>\n";
print "<input type=submit value=Copy></form>\n";
print "</ul>\n";

print "<hr>\n";
&footer("group_filesys.cgi?group=$in{'group'}", "group quota");

