#!/usr/local/bin/perl
# index_search.cgi
# Allows searching for processes by user or command

require './proc-lib.pl';
&foreign_require("mount", "mount-lib.pl");
use Config;
&header($text{'index_title'}, "", "search", "proc", 1);
print "<hr>\n";
&ReadParse();
&index_links("search");

# display search form
print "<form action=index_search.cgi>\n";
print "<table width=100%><tr><td valign=top>\n";

printf "<input type=radio name=mode value=0 %s>\n",
	$in{mode}==0 ? "checked" : "";
print &hlink("<b>$text{'search_user'}</b>","suser"),"\n";
printf "<input name=user size=8 value=\"%s\"> %s<br>\n",
	$in{mode}==0 ? $in{user} : "",
	&user_chooser_button("user", 0);

printf "<input type=radio name=mode value=1 %s>\n",
	$in{mode}==1 ? "checked" : "";
print &hlink("<b>$text{'search_match'}</b>","smatch"),"\n";
printf "<input name=match size=20 value=\"%s\"><br>\n",
	$in{mode}==1 ? $in{match} : "";

printf "<input type=radio name=mode value=2 %s>\n",
	$in{mode}==2 ? "checked" : "";
print &hlink("<b>$text{'search_cpu'}</b>","scpu"),"\n";
printf "<input name=cpu size=4 value=\"%s\">\n",
	$in{mode}==2 ? $in{cpu} : "";
print "% $text{'cpu'}</br>\n";

print "</td><td valign=top>\n";

if ($has_fuser_command) {
	printf "<input type=radio name=mode value=3 %s>\n",
		$in{mode}==3 ? "checked" : "";
	print &hlink("<b>$text{'search_fs'}</b>","sfs")," <select name=fs>\n";
	foreach $fs (&foreign_call("mount", "list_mounted")) {
		next if ($fs->[2] eq "swap");
		printf "<option %s>%s\n",
		     $in{'mode'}==3 && $in{'fs'} eq $fs->[0] ? "selected" : "",
		     $fs->[0];
		}
	print "</select><br>\n";

	printf "<input type=radio name=mode value=4 %s>\n",
		$in{mode}==4 ? "checked" : "";
	print &hlink("<b>$text{'search_files'}</b>","sfiles"),"\n";
	printf "<input name=files size=30 value=\"%s\">\n",
		$in{mode}==4 ? $in{'files'} : "";
	print &file_chooser_button("files", 0);
	print "<br>\n";
	}

print "</td></tr></table>\n";
print "<input type=submit value=\"$text{'search_submit'}\">\n";
print "</form>\n";

if (%in) {
	# search for processes
	@procs = &list_processes();
	if ($in{mode} == 0) {
		# search by user
		@dis = grep { $_->{'user'} eq $in{'user'} } @procs;
		}
	elsif ($in{mode} == 1) {
		# search by regexp
		@dis = grep { $_->{'args'} =~ /$in{match}/ } @procs;
		}
	elsif ($in{mode} == 2) {
		# search by cpu
		@dis = grep { $_->{'cpu'} > $in{'cpu'} } @procs;
		@dis = sort { $b->{'cpu'} <=> $a->{'cpu'} } @dis;
		}
	elsif ($in{mode} == 3) {
		# search by filesystem
		foreach $p (&find_mount_processes($in{'fs'})) { $using{$p}++; }
		@dis = grep { defined($using{$_->{'pid'}}) } @procs;
		}
	elsif ($in{mode} == 4) {
		# search by files
		foreach $p (&find_file_processes(split(/\s+/, $in{'files'})))
			{ $using{$p}++; }
		@dis = grep { defined($using{$_->{'pid'}}) } @procs;
		}

	# display matches
	if (@dis) {
		print "<table border width=100%>\n";
		print "<tr $tb> <td><b>$text{'pid'}</b></td>\n";
		print "         <td><b>$text{'owner'}</b></td>\n";
		print "         <td><b>$text{'cpu'}</b></td>\n";
		print "         <td><b>$text{'command'}</b></td> </tr>\n";
		foreach $d (@dis) {
			$p = $d->{'pid'};
			push(@pidlist, $p);
			print "<tr $cb> <td><a href=\"edit_proc.cgi?$p\">",
			      "$p</a></td>\n";
			print "<td>$d->{user}</td>\n";
			print "<td>$d->{cpu}</td>\n";
			print "<td>",&cut_string($d->{args},60),
			      "</td> </tr>\n";
			}
		print "</table><p>\n";
		}
	else {
		print "<b>$text{'search_none'}</b><p>\n";
		}

	if (@pidlist) {
		# display form for mass killing
		print "<form action=kill_proc_list.cgi>\n";
		print "<input type=submit value=\"$text{'search_kill'}\">\n";
		print "<input type=hidden name=args value=\"$in\">\n";
		printf "<input type=hidden name=pidlist value=\"%s\">\n",
			join(" ", @pidlist);
		print "<select name=signal>\n";
		foreach $s (split(/\s+/, $Config{sig_name})) {
			printf "<option value=\"$s\" %s> $s\n",
				$s eq "TERM" ? "selected" : "";
			}
		print "</select></form>\n";
		}
	}

print "<hr>\n";
&footer("/", $text{'index'});

