#!/usr/local/bin/perl
# index.cgi
# Displays a list of all PAP secrets

require './pap-lib.pl';
&header("PPP Accounts", "", undef, 1, 1);
print "<hr>\n";

if (!(-r $config{'pap_file'})) {
	print "<b>The PPP passwords file '$config{'pap_file'}' does not\n";
	print "exist on your system. Maybe PPP is not installed</b>.<p>\n";
	print "<hr>\n";
	&footer("/", "index");
	exit;
	}

@sec = &list_secrets();
print "<table border width=100%>\n";
print "<tr $tb> <td><b>PPP Dial-in and Dial-out Accounts</b></td> </tr>\n";
print "<tr $cb> <td><table width=100%>\n";
print "<tr> <td width=25%><b>Username</b></td> ",
      "<td width=25%><b>Server</b></td> <td width=25%><b>Username</b></td> ",
      "<td width=25%><b>Server</b></td> </tr>\n";
for($i=0; $i<@sec; $i++) {
	if ($i%2 == 0) { print "<tr>\n"; }
	$s = $sec[$i];
	printf "<td width=25%><a href=\"edit_secret.cgi?$i\">%s</a></td>\n",
		$s->{'client'} ? $s->{'client'} : "ANY";
	printf "<td width=25%>%s</td>\n",
		$s->{'server'} eq "*" ? "ANY" : $s->{'server'};
	if ($i%2 == 1) { print "</tr>\n"; }
	}
print "</table></td></tr></table>\n";
print "<a href=\"edit_secret.cgi\">Create new PPP account</a>.<p>\n";

print "<hr>\n";
print "Webmin can be configured so that changes to the Unix user\n";
print "list will automatically be applied to the list of PPP accounts.\n";
print "This will only work when the <tt>Users, Groups and Passwords</tt>\n";
print "Webmin module is used to add, delete or change users. <p>\n";

print "<form action=save_sync.cgi>\n";
printf "<input type=checkbox name=add value=1 %s>\n",
	$config{'sync_add'} ? "checked" : "";
print "Add a PPP account when a Unix user is added, for the server\n";
print "<input name=server size=20 value=\"$config{'sync_server'}\"><p>\n";

printf "<input type=checkbox name=change value=1 %s>\n",
	$config{'sync_change'} ? "checked" : "";
print "Change the PPP account when a Unix user is changed<p>\n";

printf "<input type=checkbox name=delete value=1 %s>\n",
	$config{'sync_delete'} ? "checked" : "";
print "Delete the PPP account when a Unix user is deleted<p>\n";
print "<input type=submit value=Apply></form>\n";

print "<hr>\n";
&footer("/", "index");

