#!/usr/local/bin/perl
# save_field.cgi
# Create, modify or delete a field

require './mysql-lib.pl';
&ReadParse();
&can_edit_db($in{'db'}) || &error($text{'dbase_ecannot'});
&error_setup($text{'field_err'});

if ($in{'delete'}) {
	# delete this field
	&execute_sql($in{'db'}, "alter table $in{'table'} drop $in{'old'}");
	}
elsif ($in{'new'}) {
	# add a new field
	$in{'field'} =~ /^\S+$/ || &error(&text('field_efield', $in{'field'}));
	$size = &validate_size();
	$sql = sprintf "alter table %s add %s %s%s %s %s %s",
		$in{'table'}, $in{'field'}, $in{'type'}, $size,
		$in{'null'} ? '' : 'not null',
		$in{'default'} ? "default '$in{'default'}'" : "",
		$in{'ext'};
	&execute_sql($in{'db'}, $sql);
	}
else {
	# modify an existing field
	$size = &validate_size();
	$sql = sprintf "alter table %s modify %s %s%s %s %s %s",
			$in{'table'}, $in{'old'}, $in{'type'}, $size,
			$in{'null'} ? 'null' : 'not null',
			$in{'default'} ? "default '$in{'default'}'" : "",
			$in{'ext'};
	&execute_sql($in{'db'}, $sql);
	if ($in{'old'} ne $in{'field'}) {
		# Rename field as well
		$sql = sprintf "alter table %s change %s %s %s%s",
				$in{'table'}, $in{'old'}, $in{'field'},
				$in{'type'}, $size;
		&execute_sql($in{'db'}, $sql);
		}
	}
&redirect("edit_table.cgi?db=$in{'db'}&table=$in{'table'}");

sub validate_size
{
if ($in{'type'} eq 'enum' || $in{'type'} eq 'set') {
	$in{'size'} || &error($text{'field_eenum'});
	$in{'size'} =~ s/\r//g;
	return '('.join(",", map { "'$_'" } split(/\n/, $in{'size'})).')';
	}
elsif ($in{'type'} eq 'float' || $in{'type'} eq 'double' ||
       $in{'type'} eq 'decimal') {
	$in{'size1'} =~ /^\d+$/ || &error(&text('field_esize', $in{'size1'}));
	$in{'size2'} =~ /^\d+$/ || &error(&text('field_esize', $in{'size2'}));
	return "($in{'size1'},$in{'size2'}) $in{'opts'}";
	}
elsif ($in{'type'} eq 'date' || $in{'type'} eq 'datetime' ||
       $in{'type'} eq 'time' || $in{'type'} =~ /(blob|text)$/) {
	return "";
	}
else {
	$in{'size'} =~ /^\d+$/ || &error(&text('field_esize', $in{'size'}));
	return "($in{'size'}) $in{'opts'}";
	}
}

