#!/usr/local/bin/perl
# index.cgi
# Display a list of known filesystems, and indicate which are currently mounted

require './mount-lib.pl';
&header($text{'index_title'}, "", undef, 1, 1);
print "<hr>\n";

print "<table width=100% border>\n";
print "<tr $tb> <td><b>$text{'index_dir'}</b></td>\n",
      "<td><b>$text{'index_type'}</b></td>\n",
      "<td><b>$text{'index_dev'}</b></td>\n",
      "<td><b>$text{'index_use'}</b></td>\n",
      "<td><b>$text{'index_perm'}</b></td> </tr>\n";

# List filesystems from fstab
foreach (&list_fstypes()) { $can_edit{$_}++; }
$i = 0;
foreach (&list_mounts()) {
	@minfo = @{$_};
	print "<tr $cb>\n";
	$p = &simplify_path($minfo[0], $minfo[2]);
	if ($can_edit{$minfo[2]}) {
		print "<td><a href=\"edit_mount.cgi?index=$i\">$p</a></td>\n",
		}
	else {
		print "<td>$p</td>\n";
		}
	print "<td>",$minfo[2] eq "*" ? $text{'index_auto'}
				      : &fstype_name($minfo[2]),"</td>\n";
	print "<td>",&device_name($minfo[1]),"</td>\n";
	$p = $minfo[2] eq "swap" ? "*" : $minfo[0];
	@mmodes = &mount_modes($minfo[2]);
	printf "<td>%s</td>\n",
	  &get_mounted($p, $minfo[1])>=0 || $mmodes[1]==0 ? $text{'yes'}
							  : $text{'no'};
	print "<td>$text{'yes'}</td>\n";
	$already{$minfo[1],$minfo[0]}++;
	$i++;
	print "</tr>\n";
	}

# List filesystems from mnttab
$i = 0;
foreach (&list_mounted()) {
	@minfo = @{$_};
	if ($already{$minfo[1],$minfo[0]}) { $i++; next; }
	print "<tr $cb>\n";
	$p = &simplify_path($minfo[0], $minfo[2]);
	if ($can_edit{$minfo[2]}) {
		print "<td><a href=\"edit_mount.cgi?temp=1&index=$i\">",
		      "$p</a></td>\n";
		}
	else {
		print "<td>$p</td>\n";
		}
	print "<td>",&fstype_name($minfo[2]),"</td>\n";
	print "<td>",&device_name($minfo[1]),"</td>\n";
	print "<td>$text{'yes'}</td>\n";
	print "<td>$text{'no'}</td>\n";
	$i++;
	}

print "</table>\n";
print "<form action=\"edit_mount.cgi\">\n";
print "<input type=submit value=\"$text{'index_add'}\"> $text{'index_type'}:\n";
print "<select name=type>\n";
foreach (&list_fstypes()) {
	$nm = &fstype_name($_);
	if (!$donefs{$nm}++) { print "<option value=\"$_\">$nm\n"; }
	}
print "</select></form>\n";

print "<hr>\n";
&footer("/", $text{'index'});

sub simplify_path
{
if ($_[1] eq "swap") {
	return "<i>$text{'index_swap'}</i>";
	}
elsif (length($_[0]) > 20) {
	return "... ".substr($_[0], length($_[0])-20);
	}
else {
	return $_[0];
	}
}

