#!/usr/local/bin/perl
# save_digest.cgi
# Save digest options

require './majordomo-lib.pl';
&ReadParse();
%access = &get_module_acl();
&can_edit_list(\%access, $in{'name'}) ||
	&error("You are not allowed to edit this mailing list");
$list = &get_list($in{'name'}, &get_config());
$conf = &get_list_config($list->{'config'});

&save_opt($conf, $list->{'config'}, "digest_name");
&save_opt($conf, $list->{'config'}, "digest_maxdays", \&check_days);
&save_opt($conf, $list->{'config'}, "digest_maxlines", \&check_lines);
&save_opt($conf, $list->{'config'}, "digest_volume", \&check_volume);
&save_opt($conf, $list->{'config'}, "digest_issue", \&check_issue);

&flush_file_lines();
&redirect("edit_list.cgi?name=$in{'name'}", "mailing list");

sub check_days
{
return $_[0] =~ /^\d+$/ ? undef : "Missing or invalid number of days";
}

sub check_lines
{
return $_[0] =~ /^\d+$/ ? undef : "Missing or invalid number of lines";
}

sub check_volume
{
return $_[0] =~ /^\d+$/ ? undef : "Missing or invalid volume number";
}

sub check_issue
{
return $_[0] =~ /^\d+$/ ? undef : "Missing or invalid issue number";
}

