#!/usr/local/bin/perl
# index.cgi
# Display all mailing lists and majordomo options

require './majordomo-lib.pl';
&header("Majordomo List Manager", "", undef, 1, 1);
print "<hr>\n";
%access = &get_module_acl();

# Check for the majordomo config file
if (!-r $config{'majordomo_cf'}) {
	print "<p>The majordomo config file <tt>$config{'majordomo_cf'}</tt>\n";
	print "does not exist. Maybe your <a href='/config.cgi?$module_name'>";
	print "module configuration</a> is incorrect, or majordomo is not\n";
	print "installed. <p>\n";
	print "<hr>\n";
	&footer("/", "index");
	exit;
	}

# Check for the programs dir
if (!-d $config{'program_dir'}) {
	print "<p>The majordomo directory <tt>$config{'program_dir'}</tt>\n";
	print "does not exist. Maybe your <a href='/config.cgi?$module_name'>";
	print "module configuration</a> is incorrect, or majordomo is not\n";
	print "installed. <p>\n";
	print "<hr>\n";
	&footer("/", "index");
	exit;
	}

# Check majordomo version
if (!-r "$config{'program_dir'}/majordomo_version.pl") {
	print "<p>Your majordomo version is not supported by Webmin. Only\n";
	print "versions 1.94 are supported. <p>\n";
	print "<hr>\n";
	&footer("/", "index");
	exit;
	}
require "$config{'program_dir'}/majordomo_version.pl";
if ($majordomo_version < 1.94 || $majordomo_version >= 2) {
	print "<p>Your majordomo version is $majordomo_version, but Webmin\n";
	print "only supports versions 1.94 and above. <p>\n";
	print "<hr>\n";
	&footer("/", "index");
	exit;
	}

# Check $homedir in majordomo.cf
$conf = &get_config();
$homedir = &find_value("homedir", $conf);
if (!-d $homedir) {
	print "<p>The <tt>\$homedir</tt> variable in your majordomo config\n";
	print "file is set to <tt>$homedir</tt>, which does not exist. <p>\n";
	print "<hr>\n";
	&footer("/", "index");
	exit;
	}

if ($config{'aliases_file'}) {
	# aliases file specified in config
	$aliases_files = [ $config{'aliases_file'} ];
	}
else {
	# Check if sendmail is setup
	%smconfig = &foreign_config("sendmail");
	if (!-r $smconfig{'sendmail_cf'}) {
		print "<p>The sendmail config file\n";
		print "<tt>$smconfig{'sendmail_cf'}</tt> does not exist.\n";
		print "Check your <a href=/sendmail/>Sendmail module</a>\n";
		print "configuration. <p>\n";
		print "<hr>\n";
		&footer("/", "index");
		exit;
		}

	# Check if sendmail is the right version for the sendmail module
	$sm_conf = &foreign_call("sendmail", "get_sendmailcf");
	if (!&foreign_call("sendmail", "check_sendmail_version", $sm_conf)) {
		print "<p>Your sendmail config file does not appear to be\n";
		print "for the latest sendmail version. Webmin only supports\n";
		print "versions 8.8 and above. <p>\n";
		print "<hr>\n";
		&footer("/", "index");
		exit;
		}
	$aliases_files = &foreign_call("sendmail", "aliases_file", $sm_conf);
	}

# Check for the majordomo aliases
$email = &find_value("whoami", $conf); $email =~ s/\@.*$//g;
$owner = &find_value("whoami_owner", $conf); $owner =~ s/\@.*$//g;
@aliases = &foreign_call("sendmail", "list_aliases", $aliases_files);
foreach $a (@aliases) {
	if ($a->{'enabled'} && lc($a->{'name'}) eq lc($email)) {
		$majordomo_alias = 1;
		}
	if ($a->{'enabled'} && lc($a->{'name'}) eq lc($owner)) {
		$majordomo_owner = 1;
		}
	}

# Offer to setup aliases
if (!$majordomo_alias) {
	print "<p>Majordomo has been installed on your system, but not setup\n";
	print "properly in the sendmail aliases file.\n";
	print "<center><form action=alias_setup.cgi>\n";
	if (!$majordomo_owner) {
		print "<b>Owner email address:</b>\n";
		print "<input name=owner size=25>\n";
		print "<input type=hidden name=owner_a value='$owner'>\n";
		}
	print "<input type=hidden name=email_a value='$email'>\n";
	print "<input type=submit value=\"Setup Aliases\">\n";
	print "</form></center>\n";
	print "<hr>\n";
	}

# Display active lists
@lists = &list_lists($conf);
map { $lcan{$_}++ } split(/\s+/, $access{'lists'});
foreach $l (grep { $lcan{$_} || $lcan{"*"} } @lists) {
	push(@links, "edit_list.cgi?name=$l");
	push(@titles, $l);
	push(@icons, "images/list.gif");
	}
if (@links) {
	&icons_table(\@links, \@titles, \@icons, 5);
	}
else {
	print "<b>You have no mailing lists defined</b>.<p>\n";
	}
if ($access{'create'}) {
	print "<a href='create_form.cgi'>Add a new mailing list</a>\n";
	if (@links) {
		print "&nbsp;&nbsp;\n";
		print "<a href='digest_form.cgi'>Add a new digest list</a>\n";
		}
	print "<p>\n";
	}

if ($access{'global'}) {
	print "<hr>\n";
	print "<table> <tr>\n";
	print "<form action=edit_global.cgi>\n";
	print "<td><input type=submit value='Edit Majordomo Options'></td>\n";
	print "<td>Edit global Majordomo options that apply to all mailing\n";
	print "lists</td> </tr> </form>\n";
	print "</table>\n";
	}

print "<hr>\n";
&footer("/", "index");

