#!/usr/local/bin/perl
# edit_inet.cgi
# Display a form for editing or creating an internet service

require './inetd-lib.pl';
&ReadParse();

if ($in{'new'}) {
	&header("Create Internet Service", "");
	}
else {
	&header("Edit Internet Service", "");
	@serv = @{(&list_services())[$in{'spos'}]};
	if ($in{'ipos'} =~ /\d/) {
		@inet = @{(&list_inets())[$in{'ipos'}]};
		}
	}
print "<hr>\n";

print "<form action=\"save_serv.cgi\">\n";
if (@serv) {
	print "<input type=hidden name=spos value=$in{'spos'}>\n";
	print "<input type=hidden name=ipos value=$in{'ipos'}>\n";
	}
print "<table border width=100%>\n";
print "<tr $tb> <td><b>Internet Service Details</b></td> </tr>\n";
print "<tr $cb> <td><table width=100%>\n";

print "<tr> <td nowrap><b>Service Name</b></td>\n";
print "<td><input size=20 name=name value=\"$serv[1]\"></td>\n";

print "<td nowrap><b>Port Number</b></td>\n";
print "<td nowrap><input size=10 name=port value=\"$serv[2]\"></td> </tr>\n";

print "<tr> <td valign=top><b>Protocol</b></td>\n";
print "<td valign=top><select name=protocol>\n";
foreach $p (&list_protocols()) {
	printf "<option value=$p %s>%s %s\n",
		$serv[3] eq $p || (!@serv && $p eq "tcp") ? "selected" : "",
		uc($p), $prot_name{$p} ? "($prot_name{$p})" : "";
	}
print "</select></td>\n";

print "<td valign=top><b>Aliases</b></td>\n";
printf "<td valign=top><Textarea name=aliases ".
       "rows=3 cols=20>%s</textarea></td> </tr>\n",
	join("\n", split(/\s+/, $serv[4]));

print "</table></td> </tr></table><p>\n";

print "<table border width=100%>\n";
print "<tr $tb> <td><b>Server Program</b></td> </tr>\n";
print "<tr $cb> <td><table width=100%>\n";

print "<tr> <td colspan=4>\n";
printf "<input type=radio name=act value=0 %s> No program assigned\n",
	@inet ? "" : "checked";
printf "<input type=radio name=act value=1 %s> Program disabled..\n",
	@inet && !$inet[1] ? "checked" : "";
printf "<input type=radio name=act value=2 %s> Program enabled..\n",
	$inet[1] ? "checked" : "";
print "</td> </tr>\n";

print "<tr> <td><b>Program</b></td>\n";
printf "<td colspan=3><input type=radio name=serv value=1 %s>\n",
	@inet[8] eq "internal" ? "checked" : "";
print "Internal to <tt>inetd</tt></td> </tr>\n";

$tcpd = (-x $config{'tcpd_path'} && $inet[8] eq $config{'tcpd_path'});
print "<tr> <td></td>\n";
printf "<td colspan=3><input type=radio name=serv value=2 %s> Command\n",
	$inet[8] ne "internal" && !$tcpd ? "checked" : "";
printf "<input name=program size=30 value=\"%s\">\n",
	$inet[8] ne "internal" && !$tcpd ? $inet[8] : "";
print &file_chooser_button("program", 0);
printf "Args <input name=args size=30 value=\"%s\"></td> </tr>\n",
	$inet[5] ne "internal" && !$tcpd ? $inet[9] : "";

if (-x $config{'tcpd_path'}) {
	print "<tr> <td></td>\n";
	printf "<td colspan=3><input type=radio name=serv value=3 %s>\n",
		$tcpd ? "checked" : "";
 	print "TCP-Wrapper\n";
	$inet[9] =~ /^(\S+)\s*(.*)$/;
	printf "<input name=tcpd size=15 value=\"%s\">\n", $tcpd ? $1 : "";
	printf "Args <input name=args2 size=30 value=\"%s\"></td> </tr>\n",
		$tcpd ? $2 : "";
	}

@op1 = split(/[:\.\/]/, $inet[6]);
@op2 = split(/[:\.\/]/, $inet[7]);
if ($inet[7] =~ /\// && $inet[7] !~ /:/) {
	# class but no group!
	splice(@op2, 1, 0, undef);
	}
print "<tr> <td nowrap><b>Wait Mode</b></td> <td nowrap>\n";
printf "<input type=radio name=wait value=wait %s> Wait until complete\n",
	$op1[0] eq "wait" ? "checked" : "";
printf "<input type=radio name=wait value=nowait %s> Don't wait</td>\n",
	$op1[0] eq "nowait" || !@inet ? "checked" : "";

print "<td nowrap><b>Execute As User</b></td>\n";
print "<td nowrap><input name=user size=8 value=\"$op2[0]\"> ",
      &user_chooser_button("user", 0),"</td> </tr>\n";

if ($config{'extended_inetd'} == 1) {
	# Display max per minute and group options
	# This is for systems like Linux
	print "<tr> <td nowrap><b>Max per Minute</b></td> <td nowrap>\n";
	printf "<input type=radio name=permin_def value=1 %s> Default\n",
		@op1 < 2 ? "checked" : "";
	printf "&nbsp; <input type=radio name=permin_def value=0 %s>\n",
		@op1 < 2 ? "" : "checked";
	printf "<input name=permin size=5 value=\"%s\"></td>\n",
		@op1 < 2 ? "" : $op1[1];

	print "<td nowrap><b>Execute As Group</b></td>\n";
	print "<td nowrap><select name=group>\n";
	printf "<option value=\"\" %s> Default",
		$op2[1] ? "" : "selected";
	setgrent();
	while(@ginfo = getgrent()) {
		printf "<option value=\"$ginfo[0]\" %s>$ginfo[0]\n",
			$ginfo[0] eq $op2[1] ? "selected" : "";
		}
	print "</select></td> </tr>\n";
	endgrent();
	}
elsif ($config{'extended_inetd'} == 2) {
	# Display max child, max per minute, group and login class options
	# This is for systems like FreeBSD
	print "<tr> <td nowrap><b>Max per Minute</b></td> <td nowrap>\n";
	printf "<input type=radio name=permin_def value=1 %s> Default\n",
		@op1 < 3 ? "checked" : "";
	printf "&nbsp; <input type=radio name=permin_def value=0 %s>\n",
		@op1 < 3 ? "" : "checked";
	printf "<input name=permin size=5 value=\"%s\"></td>\n",
		@op1 < 3 ? "" : $op1[2];

	print "<td nowrap><b>Execute As Group</b></td>\n";
	print "<td nowrap><select name=group>\n";
	printf "<option value=\"\" %s> Default",
		$op2[1] ? "" : "selected";
	setgrent();
	while(@ginfo = getgrent()) {
		printf "<option value=\"$ginfo[0]\" %s>$ginfo[0]\n",
			$ginfo[0] eq $op2[1] ? "selected" : "";
		}
	print "</select></td> </tr>\n";
	endgrent();

	print "<tr> <td nowrap><b>Max Child Processes</b></td> <td nowrap>\n";
	printf "<input type=radio name=child_def value=1 %s> Default\n",
		@op1 < 2 ? "checked" : "";
	printf "&nbsp; <input type=radio name=child_def value=0 %s>\n",
		@op1 < 2 ? "" : "checked";
	printf "<input name=child size=5 value=\"%s\"></td>\n",
		@op1 < 2 ? "" : $op1[1];

	print "<td nowrap><b>Execute As Login Class</b></td>\n";
	print "<td><input name=class size=10 value=\"$op2[2]\"></td> </tr>\n";
	}

print "</table></td></tr></table>\n";
if (!$in{'new'}) {
	print "<table width=100%>\n";
	print "<tr> <td><input type=submit value=Save></td>\n";
	print "</form><form action=\"delete_serv.cgi\">\n";
	print "<input type=hidden name=spos value=\"$in{'spos'}\">\n";
	print "<input type=hidden name=ipos value=\"$in{'ipos'}\">\n";
	print "<td align=right><input type=submit value=Delete></td> </tr>\n";
	print "</form></table><p>\n";
	}
else {
	print "<input type=submit value=Create></form><p>\n";
	}

printf "<hr>\n";
&footer("", "services list");
