#!/usr/local/bin/perl
# index.cgi
# Display a list of known disks and partitions

require './format-lib.pl';
$whatfailed = "Failed to list disks";
&header("Partitions on Local Disks", "", undef, 1, 1);
print "<hr>\n";
$extwidth = 300;

print "<table border width=100%>\n";
print "<tr $tb> <td><b>Disk</b></td> <td><b>Partitions</b></td> </tr>\n";
@dlist = &list_disks();
for($i=0; $i<@dlist; $i++) {
	@dl = split(/\s+/, $dlist[$i]);
	next if (!&can_edit_disk($dl[0]));
	print "<tr $cb> <td valign=top><table>\n";
	print "<tr> <td><b>Disk Type:</b></td> ";
	if ($dl[1]) {
		#print"<td><a href=\"edit_disk.cgi?$i\">$dl[1]</a></td></tr>\n";
		print "<td>$dl[1]</td></tr>\n";
		print "<tr> <td><b>Cylinders:</b></td> <td>$dl[2]</td> </tr>\n";
		}
	else {
		print"<td>Unknown</td></tr>\n";
		}
	$dl[0] =~ /c(\d+)t(\d+)d(\d+)/;
	print "<tr> <td><b>SCSI Controller:</b></td> <td>$1</td> </tr>\n";
	print "<tr> <td><b>SCSI Target:</b></td> <td>$2</td> </tr>\n";
	print "<tr> <td><b>SCSI Unit:</b></td> <td>$3</td> </tr>\n";
	print "</table></td> <td valign=top>\n";
	if (!$dl[1]) {
		# Drive type unknown..
		print "<b>Disk type unknown</b>\n";
		}
	elsif (@parts = &list_partitions($i)) {
		# Known and formatted..
		print "<table> <tr> <td><b>No.</b></td> <td><b>Type</b></td>\n";
		print "<td><b>Extent</b></td> <td><b>Start</b></td>\n";
		print "<td><b>End</b></td> </tr>\n";
		for($j=0; $j<@parts; $j++) {
			@p = split(/\s+/, $parts[$j]);
			print "<tr> <td><a href=\"edit_part.cgi?$i+$j\">$j</a>",
			      "</td> <td>$p[0]</td> <td>\n";
			if ($p[3] != 0) {
				printf
				  "<img src=images/gap.gif height=10 width=%d>",
				  $extwidth*$p[2]/$dl[2];
				printf
				  "<img src=images/use.gif height=10 width=%d>",
				  $extwidth*($p[3]-$p[2])/$dl[2];
				printf
				  "<img src=images/gap.gif height=10 width=%d>",
				  $extwidth*($dl[2]-$p[3])/$dl[2];
				print "</td> <td>$p[2]</td> <td>$p[3]</td> </tr>\n";
				}
			else { print "<td colspan=3></td>\n"; }
			}
		print "</table>\n";
		}
	else {
		# Disk is not formatted.. 
		print "<b>This disk is not formatted</b>\n";
		}
	print "</td> </tr>\n";
	}
print "</table><p>\n";

print "<hr>\n";
&footer("/", "index");

