# format-lib.pl
# Common functions for partitioning and formatting disks under solaris

do '../web-lib.pl';
&init_config();
&foreign_require("mount", "mount-lib.pl");
&foreign_require("proc", "proc-lib.pl");

%access = &get_module_acl();
$| = 1;

# list_disks()
# Returns a list of known disks, one per line in the format
#  device type cyl alt hd sec volume
# Unless the disk type is unknown, in which case only the device name
# is returned.
sub list_disks
{
local(@rv);
&open_format();
&wprint("disk\n");
&wait_for($fh, 'AVAILABLE DISK SELECTIONS:\r\n');
while(1) {
	$rv = &wait_for($fh, 'Specify', '\s+\d+\. (\S+) <(.*) cyl (\d+) alt (\d+) hd (\d+) sec (\d+)>\s*(\S*)', '\s+\d+\. (\S+) <drive type unknown>', 'space for more');
	if ($rv == 0) { last; }
	elsif ($rv == 1) {
		$matches[2] =~ s/ /_/g;
		push(@rv, "$matches[1] $matches[2] $matches[3] $matches[4] $matches[5] $matches[6] $matches[7]");
	}
	else { &wprint(" "); }
	}
&wprint("0\n");
&wait_for($fh, 'format>');
return @rv;
}

# disk_info(disk)
# Returns an array containing a disks vendor, product and revision
sub disk_info
{
local(@rv);
&open_format();
&choose_disk($_[0]);
&fast_wait_for($fh, 'format>');
&wprint("inquiry\n");
&wait_for($fh, 'Vendor:\s+(.*)\r\nProduct:\s+(.*)\r\nRevision:\s+(.*)\r\n');
@rv = ($matches[1],$matches[2],$matches[3]);
&wait_for($fh, 'format>');
return @rv;
}

# list_partitions(disk)
# Returns a list of partitions, one per line in the format
#  tag flag start end
# If the disk is not formatted, returns nothing
sub list_partitions
{
local(@rv);
&open_format();
&choose_disk($_[0]);
if (!&wait_for($fh, 'unformatted', 'formatted')) { return (); }
&wait_for($fh, 'format>');
&wprint("partition\n");
&wait_for($fh, 'partition>');
&wprint("print\n");
&wait_for($fh, 'Blocks\r\n');
while(&wait_for($fh, 'partition>', '\s+\d+\s+(\S+)\s+(\S+)\s+(\d+)(\s+-\s+(\d+))?.*\r\n')) {
	push(@rv, "$matches[1] $matches[2] $matches[3] ".
		  ($matches[5] ? $matches[5] : $matches[3]));
	}
&wprint("quit\n");
&wait_for($fh, 'format>');
return @rv[0..7];
}

# modify_partition(disk, partition, tag, flag, start, end)
# Changes an existing partition
sub modify_partition
{
local(@rv);
&open_format();
&choose_disk($_[0]);
&wait_for($fh, 'format>');
&wprint("partition\n");
&wait_for($fh, 'partition>');
&wprint("$_[1]\n");
&wait_for($fh, 'Enter.*:'); &wprint("$_[2]\n");
&wait_for($fh, 'Enter.*:'); &wprint("$_[3]\n");
&wait_for($fh, 'Enter.*:'); &wprint("$_[4]\n");
&wait_for($fh, 'Enter.*:');
if ($_[4] || $_[5]) { &wprint(($_[5]-$_[4]+1)."c\n"); }
else {
	# deleting this partition..
	&wprint("0\n");
	}
&wait_for($fh, 'partition>');
&wprint("label\n");
if (&wait_for($fh, 'continue', 'Cannot')) {
	&error("Disk has mounted partitions");
	}
&wprint("y\n");
if (&wait_for($fh, 'partition>', 'no backup labels')) {
	&error("The last partition cannot be removed");
	}
&wprint("quit\n");
&wait_for($fh, 'format>');
}

# list_tags()
# Returns a list of all known tags
sub list_tags
{
return ("unassigned", "boot", "root", "swap",
	"usr", "backup", "var", "home", "alternates");

}

# device_status(device)
# Returns the mount point, type and status of some device. Uses the mount module
# to query the list of known and mounted filesystems
sub device_status
{
local ($mounted) = grep { $_->[1] eq $_[0] }
		        &foreign_call("mount", "list_mounted");
local ($mount) = grep { $_->[1] eq $_[0] }
		      &foreign_call("mount", "list_mounts");
if ($mounted) { return ($mounted->[0], $mounted->[2], 1); }
elsif ($mount) { return ($mount->[0], $mount->[2], 0); }
else {
	&metamap_init();
	if ($metastat{$_[0]}) { return ("meta", "meta", 1); }
	if ($metadb{$_[0]}) { return ("meta", "metadb", 1); }
	return ();
	}
}


# fstype_name(type)
# Returns a human-readable filesystem name
sub fstype_name
{
return $_[0] eq "ufs" ? "Solaris Unix Filesystem" : "???";
}

# filesystem_type(device)
# Calls fstyp to get the filesystem on some device
sub filesystem_type
{
local($out);
chop($out = `fstyp $_[0] 2>&1`);
if ($out =~ /^\S+$/) { return $out; }
return undef;
}

# fsck_error(code)
# Translate an error code from fsck
sub fsck_error
{
%errmap = (
	0, "no errors detected",
	1, "incorrect parameters",
	32, "filesystem needs checking",
	34, "cannot open device",
	36, "uncorrectable  errors  detected",
	37, "process killed during checking",
	39, "uncorrectable  errors  detected!",
	40, "no errors detected" );
return $errmap{$_[0]} ? $errmap{$_[0]} : "unknown error";
}


#############################################################################
# Internal functions
#############################################################################
# open_format()
# Internal function to run the 'format' command
sub open_format
{
return if ($format_already_open);
($fh, $fpid) = &foreign_call("proc", "pty_process_exec", "format");
while(1) {
	$rv = &wait_for($fh, 'Specify.*:', 'no disks found', 'space for more');
	if ($rv == 0) { last; }
	elsif ($rv == 1) { &error("<tt>format</tt> didn't find any disks"); }
	else { &wprint(" "); }
	}
&wprint("0\n");
&wait_for($fh, 'format>');
$format_already_open++;
}

sub wprint
{
syswrite($fh, $_[0], length($_[0]));
}

sub opt_input
{
print $_[3] ? "<tr>" : "";
print "<td align=right><b>$_[0]</b></td>\n";
print "<td nowrap><input type=radio name=$_[1]_def value=1 checked>Default\n";
print "&nbsp; <input type=radio name=$_[1]_def value=0>\n";
print "<input name=$_[1] size=6> $_[2]</td>";
print $_[3] ? "\n" : "</tr>\n";
}

sub opt_check
{
if ($in{"$_[0]_def"}) { return ""; }
elsif ($in{$_[0]} !~ /^$_[2]$/) {
	&error("'$in{$_[0]}' is not a valid $_[1]");
	}
else { return " $_[3] $in{$_[0]}"; }
}

# metamap_init()
# internal function to build %metastat and %metadb arrays
sub metamap_init
{
if ($done_metamap_init) { return; }
$done_metamap_init = 1;
if (-x $config{metastat_path} && -x $config{metadb_path}) {
	open(METASTAT, "$config{metastat_path} 2>&1 |");
	while(<METASTAT>) {
		if (/(c\d+t\d+d\d+s\d+)/) { $metastat{"/dev/dsk/$1"}++; }
		}
	close(METASTAT);
	open(METADB, "$config{metadb_path} -i 2>&1 |");
	while(<METADB>) {
		if (/(c\d+t\d+d\d+s\d+)/) { $metadb{"/dev/dsk/$1"}++; }
		}
	close(METADB);
	}
}

sub choose_disk
{
&wprint("disk\n");
while(&wait_for($fh, 'Specify.*:', 'space for more')) {
	&wprint(" ");
	}
&wprint("$_[0]\n");
}

# can_edit_disk(device)
sub can_edit_disk
{
$_[0] =~ /(c\d+t\d+d\d+)/;
foreach (split(/\s+/, $access{'disks'})) {
	return 1 if ($_ eq "*" || $_ eq $1);
	}
return 0;
}

