
require './format-lib.pl';

# acl_security_form(&options)
# Output HTML for editing security options for the format module
sub acl_security_form
{
local @dlist = &list_disks();
local ($d, %dcan);
map { $dcan{$_}++ } split(/\s+/, $_[0]->{'disks'});
print "<tr> <td valign=top><b>Disks this user can partition ",
      "and format</b></td> <td><select name=disks size=4 multiple>\n";
foreach $d (@dlist) {
	local @d = split(/\s+/, $d);
	printf "<option value='%s' %s>%s\n",
		$d[0],
		$dcan{$d[0]} || $dcan{"*"} ? "selected" : "",
		"$d[0] ($d[1])";
	}
print "</select></td> </tr>\n";
}

# acl_security_save(&options)
# Parse the form for security options for the format module
sub acl_security_save
{
local @dlist = &list_disks();
local @sel = split(/\0/, $in{'disks'});
if (scalar(@dlist) == scalar(@sel)) {
	$_[0]->{'disks'} = "*";
	}
else {
	$_[0]->{'disks'} = join(" ", @sel);
	}
}

