import java.awt.*;
import java.io.*;
import java.applet.*;
import java.net.*;
import java.util.*;
import netscape.javascript.JSObject;

// A java filemanager that allows the user to manipulate files on the
// Webmin server. Layout is similar to the windows explorer - directory
// tree on the left, files on the right, action buttons on the top.
public class FileManager extends Applet
	implements CbButtonCallback, HierarchyCallback, MultiColumnCallback
{
	// top buttons
	CbButton open_b, view_b, edit_b, refresh_b, props_b,
		 copy_b, cut_b, paste_b, delete_b, new_b, upload_b, mkdir_b,
		 makelink_b, rename_b;

	// Directory tree
	Hierarchy dirs;
	FileNode root;
	Hashtable nodemap = new Hashtable();

	// File list
	MultiColumn files;
	TextField pathname;
	RemoteFile showing_files;

	// Copying and pasting
	String cut_buffer;
	boolean cut_mode;

	static final String monmap[] = { "Jan", "Feb", "Mar", "Apr",
					 "May", "Jun", "Jul", "Aug",
					 "Sep", "Oct", "Nov", "Dec" };
	String accroot[];
	Hashtable lang = new Hashtable();

	public void init()
	{
	setLayout(new BorderLayout());
	StringTokenizer tok = new StringTokenizer(getParameter("root"), " ");
	accroot = new String[tok.countTokens()];
	for(int i=0; tok.hasMoreTokens(); i++)
		accroot[i] = tok.nextToken();

	// download language strings
	String l[] = get_text("lang.cgi");
	for(int i=0; i<l.length; i++) {
		int eq = l[i].indexOf('=');
		lang.put(l[i].substring(0, eq), l[i].substring(eq+1));
		}

	// create button panel
	BorderPanel top = new BorderPanel(2);
	top.setLayout(new FlowLayout(FlowLayout.LEFT, 2, 2));

	Panel top1 = new Panel();
	top1.setLayout(new GridLayout(1, 0));
	top1.add(open_b = make_button("open.gif", text("top_open")));
	top1.add(view_b = make_button("view.gif", text("top_view")));
	top1.add(edit_b = make_button("edit.gif", text("top_edit")));
	top1.add(refresh_b = make_button("refresh.gif", text("top_refresh")));
	top1.add(props_b = make_button("props.gif", text("top_info")));
	top.add(top1);
	top.add(new Label(""));
	
	Panel top2 = new Panel();
	top2.setLayout(new GridLayout(1, 0));
	top2.add(delete_b = make_button("cancel.gif", text("top_delete")));
	top2.add(new_b = make_button("new.gif", text("top_new")));
	top2.add(upload_b = make_button("upload.gif", text("top_upload")));
	top2.add(mkdir_b = make_button("mkdir.gif", text("top_new")));
	if (!getParameter("follow").equals("1"))
		top2.add(makelink_b = make_button("makelink.gif",
					text("top_new")));
	top2.add(rename_b = make_button("rename.gif", text("top_rename")));
	top.add(top2);
	top.add(new Label(""));

	Panel top3 = new Panel();
	top3.setLayout(new GridLayout(1, 0));
	top3.add(copy_b = make_button("copy.gif", text("top_copy")));
	top3.add(cut_b = make_button("cut.gif", text("top_cut")));
	top3.add(paste_b = make_button("paste.gif", text("top_paste")));
	top.add(top3);
	add("North", top);

	Panel mid = new Panel();
	add("Center", mid);
	mid.setLayout(new GridLayout(1, 2));

	// create directory tree
	BorderPanel left = new BorderPanel(2);
	left.setLayout(new BorderLayout());
	root = new FileNode(new RemoteFile(this, get_text("root.cgi")[0],null));
	left.add("Center", dirs = new Hierarchy(root, this));
	root.open = true; root.fill();
	mid.add(left);

	// create file window
	BorderPanel right = new BorderPanel(2);
	right.setLayout(new BorderLayout());
	right.add("North", pathname = new TextField());
	//pathname.setFont(new Font("courier", Font.PLAIN, 8));
	String cols[] = { "", text("right_name"), text("right_size"),
			  text("right_user"), text("right_group"),
			  text("right_date") };
	float widths[] = { .07f, .33f, .15f, .15f, .15f, .15f };
	right.add("Center", files = new MultiColumn(cols, this));
	files.setWidths(widths);
	files.setDrawLines(false);
	show_files(root.file);
	mid.add(right);

	// Go to the restricted directory
	if (!accroot[0].equals("/"))
		find_directory(accroot[0], true);
	}

	CbButton make_button(String f, String t)
	{
	return new CbButton(get_image(f), t, CbButton.ABOVE, this);
	}

	// Gets an image from the images directory
	Image get_image(String img)
	{
	return getImage(getDocumentBase(), "images/"+img);
	}

	String[] get_text(String url)
	{
	try {
		long now = System.currentTimeMillis();
		if (url.indexOf('?') > 0) url += "&rand="+now;
		else url += "?rand="+now;
		URL u = new URL(getDocumentBase(), url);
		Vector lv = new Vector();
		LineInputStream is = new LineInputStream(u.openStream());
		while(true)
			try { lv.addElement(is.gets()); }
			catch(EOFException eof) { break; }
		is.close();
		String rv[] = new String[lv.size()];
		lv.copyInto(rv);
		return rv;
		}
	catch(Exception e) {
		e.printStackTrace();
		return null;
		}
	}

	// Fill the multicolumn list with files from some directory
	void show_files(RemoteFile f)
	{
	RemoteFile fl[] = f.list();
	files.clear();
	Object rows[][] = new Object[fl.length+1][];
	long now = System.currentTimeMillis();

	// Create parent directory rows
	rows[0] = new Object[6];
	rows[0][0] = get_image("dir.gif");
	rows[0][1] = "..";
	rows[0][2] = rows[0][3] = rows[0][4] = rows[0][5] = "";

	// Create file rows
	for(int i=0; i<fl.length; i++) {
		Object row[] = rows[i+1] = new Object[6];
		row[0] = get_image(RemoteFile.tmap[fl[i].type]);
		row[1] = fl[i].name;
		if (fl[i].size < 1000)
			row[2] = spad(fl[i].size, 5)+" b";
		else if (fl[i].size < 1000000)
			row[2] = spad(fl[i].size/1000, 5)+" Kb";
		else
			row[2] = spad(fl[i].size/1000000, 5)+" Mb";
		row[3] = fl[i].user;
		row[4] = fl[i].group;
		Date d = new Date(fl[i].modified);
		if (now - fl[i].modified < 24*60*60*1000) {
			// show as hour:min
			row[5] = pad(d.getHours(),2)+":"+
				 pad(d.getMinutes(),2);
			}
		else if (now - fl[i].modified < 24*60*60*365*1000) {
			// show as day/mon
			row[5] = pad(d.getDate(),2)+"/"+
				 monmap[d.getMonth()];
			}
		else {
			// show as mon/year
			row[5] = monmap[d.getMonth()]+"/"+
				 pad(d.getYear()%100, 2);
			}
		}
	files.addItems(rows);
	showing_files = f;
	pathname.setText(f.path);
	}

	String pad(int n, int s)
	{
	String rv = String.valueOf(n);
	while(rv.length() < s)
		rv = "0"+rv;
	return rv;
	}

	String spad(int n, int s)
	{
	String rv = String.valueOf(n);
	while(rv.length() < s)
		rv = " "+rv;
	return rv;
	}

	String trim_path(String p)
	{
	while(p.endsWith("/"))
		p = p.substring(0, p.length()-1);
	return p;
	}

	// openNode
	// Called when a node with children is opened
	public void openNode(Hierarchy h, HierarchyNode n)
	{
	FileNode fn = (FileNode)n;
	fn.fill();
	}

	// closeNode
	// Called when a node is closed
	public void closeNode(Hierarchy h, HierarchyNode n)
	{
	}

	// clickNode
	// Called when the user clicks on a node
	public void clickNode(Hierarchy h, HierarchyNode n)
	{
	FileNode fn = (FileNode)n;
	if (showing_files != fn.file)
		show_files(fn.file);
	}

	// doubleNode
	// Called when a user double-clicks on a node
	public void doubleNode(Hierarchy h, HierarchyNode n)
	{
	}

	// Called when a button is clicked
	public void click(CbButton b)
	{
	int s = files.selected();
	RemoteFile f = s < 1 ? null : (showing_files.list())[s-1];
	FileNode d = (FileNode)dirs.selected();
	if (b == edit_b) {
		// Open a window for editing the selected file
		if (f == null) return;
		if (f.type == 0 || f.type > 4)
			new ErrorWindow(text("edit_enormal"));
		else
			new EditorWindow(f, this);
		}
	else if (b == view_b) {
		// View the selected file in the browser
		if (f == null) return;
		if (f.type == 0 || f.type > 4)
			new ErrorWindow(text("view_enormal"));
		else
			show_file(f);
		}
	else if (b == open_b) {
		// Open the selected directory
		d.open = !d.open;
		d.fill();
		dirs.redraw();
		}
	else if (b == refresh_b) {
		// Refesh the selected directory (and thus any subdirs)
		d.known = false;
		d.file.list = null;
		d.fill();
		show_files(d.file);
		}
	else if (b == props_b) {
		// Display the properties window
		if (f == null) return;
		new PropertiesWindow(f, this);
		}
	else if (b == copy_b) {
		// Copy the selected file
		if (f == null) return;
		cut_buffer = f.path;
		cut_mode = false;
		}
	else if (b == cut_b) {
		// Cut the selected file
		if (f == null) return;
		cut_buffer = f.path;
		cut_mode = true;
		}
	else if (b == paste_b) {
		// Paste the copied file
		if (cut_buffer == null) {
			new ErrorWindow(text("paste_ecopy"));
			return;
			}
		int sl = cut_buffer.lastIndexOf('/');
		String cut_name = cut_buffer.substring(sl+1),
		       cut_dir = cut_buffer.substring(0, sl);
		RemoteFile cut_par = find_directory(cut_dir, false), cut_file;
		if (cut_par == null ||
		    (cut_file = cut_par.find(cut_name)) == null) {
			new ErrorWindow(text("paste_egone", cut_name));
			return;
			}


		// Check for an existing file
		RemoteFile already = showing_files.find(cut_name);
		String sp = showing_files.path;
		String dest_path = sp.equals("/") ? sp+cut_name
						  : sp+"/"+cut_name;
		if (already != null &&
		    (already.type == 0 || already.type == 5)) {
			new ErrorWindow(text("paste_eover", dest_path));
			return;
			}
		if (already == cut_file) {
			new ErrorWindow(text("paste_eself"));
			return;
			}

		// Move or copy the actual file
		String[] rv = get_text((cut_mode ? "move.cgi" : "copy.cgi")+
				       "?from="+urlize(cut_buffer)+
				       "&to="+urlize(dest_path));
		if (rv[0].length() > 0) {
			new ErrorWindow(text(
				cut_mode ? "paste_emfailed"
					 : "paste_ecfailed", rv[0]));
			return;
			}
		RemoteFile file = new RemoteFile(this, rv[1], showing_files);
		if (already == null) {
			// Add to the parent directory
			showing_files.add(file);
			}
		else {
			// Update the existing file
			already.type = file.type;
			already.user = file.user;
			already.group = file.group;
			already.size = file.size;
			already.perms = file.perms;
			already.modified = file.modified;
			file = already;
			}
		if (cut_mode) {
			// Delete the old file
			cut_par.delete(cut_file);
			}
		if (cut_file.type == 0) {
			// Moving or copying a directory.. update the tree
			FileNode dest_par_node =
				(FileNode)nodemap.get(showing_files);
			dest_par_node.add(new FileNode(file));
			if (cut_mode) {
				FileNode cut_par_node =
					(FileNode)nodemap.get(cut_par);
				FileNode cut_file_node =
					(FileNode)nodemap.get(cut_file);
				if (cut_par_node != null &&
				    cut_file_node != null)
					cut_par_node.ch.removeElement(
								cut_file_node);
				}
			dirs.redraw();
			}
		show_files(showing_files);
		if (cut_mode) {
			// Paste from the destination path from now on
			cut_mode = false;
			cut_buffer = dest_path;
			}
		}
	else if (b == delete_b) {
		// Delete the selected file
		if (f == null) return;
		new DeleteWindow(this, f);
		}
	else if (b == new_b) {
		// Open a window for creating a file
		new EditorWindow(showing_files.path, this);
		}
	else if (b == upload_b) {
		// Call javascript to open an upload window
		try {
			JSObject win = JSObject.getWindow(this);
			String params[] = { showing_files.path };
			win.call("upload", params);
			}
		catch(Exception e) {
			new ErrorWindow(text("upload_efailed", e.getMessage()));
			}
		}
	else if (b == mkdir_b) {
		// Prompt for new directory
		new MkdirWindow(showing_files.path, this);
		}
	else if (b == makelink_b) {
		// Prompt for a new symlink
		new LinkWindow(showing_files.path, this);
		}
	else if (b == rename_b) {
		// Prompt for new filename
		if (f == null) return;
		new RenameWindow(this, f);
		}
	}

	// Returns the object for some directory, or null if not found.
	RemoteFile find_directory(String p, boolean fill)
	{
	int l = p.length();
	boolean can = false;
	for(int r=0; r<accroot.length; r++) {
		int rl = accroot[r].length();
		if (accroot[r].equals("/"))
			can = true;
		else if (l >= rl && p.substring(0, rl).equals(accroot[r]))
			can = true;
		else if (l < rl && accroot[r].substring(0, l).equals(p))
			can = true;
		}
	if (!can) {
		new ErrorWindow(text("find_eaccess", p));
		return null;
		}
	FileNode posnode = root;
	RemoteFile pos = posnode.file;
	StringTokenizer tok = new StringTokenizer(p, "/");
	while(tok.hasMoreTokens()) {
		String fn = tok.nextToken();
		if (fn.equals("")) continue;
		RemoteFile fl[] = pos.list();
		if (fill) {
			posnode.open = true;
			posnode.fill();
			}
		boolean found = false;
		for(int i=0; i<fl.length; i++)
			if (fl[i].name.equals(fn)) {
				pos = fl[i];
				found = true;
				}
		if (!found) {
			new ErrorWindow(text("find_eexist", fn, p));
			return null;
			}
		if (pos.type != 0) {
			new ErrorWindow(text("find_edir", fn, p));
			return null;
			}
		if (fill)
			posnode = (FileNode)nodemap.get(pos);
		}
	if (fill) {
		show_files(pos);
		posnode.fill();
		posnode.open = true;
		dirs.select(posnode);
		dirs.redraw();
		}
	return pos;
	}

	public boolean action(Event e, Object o)
	{
	if (e.target == pathname) {
		// A new path was entered.. cd to it
		String p = pathname.getText().trim();
		if (p.equals("")) return true;
		find_directory(p, true);
		return true;
		}
	return false;
	}

        // singleClick
        // Called on a single click on a list item
        public void singleClick(MultiColumn list, int num)
	{
	}

        // doubleClick
        // Called upon double-clicking on a list item
        public void doubleClick(MultiColumn list, int num)
	{
	if (num == 0) {
		// Go to parent directory
		if (showing_files.directory != null) {
			((FileNode)nodemap.get(showing_files)).open = false;
			show_files(showing_files.directory);
			dirs.select((FileNode)nodemap.get(showing_files));
			dirs.redraw();
			}
		return;
		}
	RemoteFile d = (showing_files.list())[num-1];
	if (d.type == 0) {
		// Open this directory
		FileNode pn = (FileNode)nodemap.get(showing_files);
		pn.fill();
		pn.open = true;
		FileNode fn = (FileNode)nodemap.get(d);
		fn.fill();
		fn.open = true;
		show_files(d);
		dirs.select(fn);
		dirs.redraw();
		}
	else if (d.type <= 4) {
		// Direct the browser to this file
		show_file(d);
		}
	}

	void show_file(RemoteFile f)
	{
	try {
		URL u = new URL(getDocumentBase(), "show.cgi"+urlize(f.path)+
				"?rand="+System.currentTimeMillis());
		getAppletContext().showDocument(u, "show");
		}
	catch(Exception e) { }
	}

	String urlize(String s)
	{
	StringBuffer rv = new StringBuffer();
	for(int i=0; i<s.length(); i++) {
		char c = s.charAt(i);
		if (c == '%' || c == '+' || c == '&' || c == '?' || c == ' ')
			rv.append("%"+Integer.toString(c, 16));
		else
			rv.append(c);
		}
	return rv.toString();
	}

	public void upload_notify(String path_str, String info)
	{
	int sl = path_str.lastIndexOf('/');
	String par_str = path_str.substring(0, sl),
	       file_str = path_str.substring(sl+1);
	RemoteFile par = find_directory(par_str, false);
	RemoteFile upfile = par.find(file_str);
	if (upfile == null) {
		upfile = new RemoteFile(this, info, par);
		par.add(upfile);
		}
	show_files(showing_files);
	}

	public String text(String k, String p[])
	{
	String rv = (String)lang.get(k);
	for(int i=0; i<p.length; i++) {
		int idx = rv.indexOf("$"+(i+1));
		if (idx != -1)
			rv = rv.substring(0, idx)+p[i]+rv.substring(idx+2);
		}
	return rv;
	}

	public String text(String k)
	{
	String p[] = { };
	return text(k, p);
	}

	public String text(String k, String p1)
	{
	String p[] = { p1 };
	return text(k, p);
	}

	public String text(String k, String p1, String p2)
	{
	String p[] = { p1, p2 };
	return text(k, p);
	}
}

// A node in the directory tree
class FileNode extends HierarchyNode
{
	FileManager parent;
	RemoteFile file;
	boolean known;

	FileNode(RemoteFile file)
	{
	this.file = file;
	parent = file.parent;
	im = parent.get_image("dir.gif");
	ch = new Vector();
	text = file.name;
	parent.nodemap.put(file, this);
	}

	// Create the nodes for subdirectories
	void fill()
	{
	if (!known) {
		RemoteFile l[] = file.list();
		ch.removeAllElements();
		for(int i=0; i<l.length; i++)
			if (l[i].type == 0)
				ch.addElement(new FileNode(l[i]));
		parent.dirs.redraw();
		known = true;
		}
	}

	void add(FileNode n)
	{
	for(int i=0; i<=ch.size(); i++) {
		FileNode ni = i==ch.size() ? null : (FileNode)ch.elementAt(i);
		if (ni == null || ni.text.compareTo(n.text) > 0) {
			ch.insertElementAt(n, i);
			break;
			}
		}
	}

}

class RemoteFile
{
	static final int DIR = 0;
	static final int TEXT = 1;
	static final int IMAGE = 2;
	static final int BINARY = 3;
	static final int UNKNOWN = 4;
	static final int SYMLINK = 5;
	static final int DEVICE = 6;
	static final int PIPE = 7;
	static final String[] tmap = { "dir.gif", "text.gif", "image.gif",
				       "binary.gif", "unknown.gif",
				       "symlink.gif", "device.gif",
				       "pipe.gif" };

	FileManager parent;
	String path, name;
	int type;
	String user, group;
	int size;
	int perms;
	long modified;
	String linkto;
	RemoteFile list[];
	RemoteFile directory;

	// Parse a line of text to a file object
	RemoteFile(FileManager parent, String line, RemoteFile d)
	{
	this.parent = parent;
	StringTokenizer tok = new StringTokenizer(line, "\t");
	path = tok.nextToken();
	type = Integer.parseInt(tok.nextToken());
	user = tok.nextToken();
	group = tok.nextToken();
	size = Integer.parseInt(tok.nextToken());
	perms = Integer.parseInt(tok.nextToken());
	modified = Long.parseLong(tok.nextToken())*1000;
	if (type == 5) linkto = tok.nextToken();
	directory = d;
	if (path.equals("/")) name = "/";
	else name = path.substring(path.lastIndexOf('/')+1);
	}

	// Create a new, empty file object
	RemoteFile() { }

	// Returns a list of files in this directory
	RemoteFile[] list()
	{
	if (list == null) {
		String l[] = parent.get_text("list.cgi?dir="+
					     parent.urlize(path));
		if (l[0].length() > 0)
			list = new RemoteFile[0];
		else {
			list = new RemoteFile[l.length-3];
			for(int i=3; i<l.length; i++)
				list[i-3] = new RemoteFile(parent, l[i], this);
			}
		}
	return list;
	}

	RemoteFile find(String n)
	{
	RemoteFile l[] = list();
	for(int i=0; i<l.length; i++)
		if (l[i].name.equals(n))
			return l[i];
	return null;
	}

	void add(RemoteFile f)
	{
	RemoteFile nlist[] = new RemoteFile[list.length+1];
	int offset = 0;
	for(int i=0; i<list.length; i++) {
		if (list[i].name.compareTo(f.name) > 0 && offset == 0) {
			nlist[i] = f;
			offset++;
			}
		nlist[i+offset] = list[i];
		}
	if (offset == 0) nlist[list.length] = f;
	list = nlist;
	}

	void delete(RemoteFile f)
	{
	RemoteFile nlist[] = new RemoteFile[list.length-1];
	for(int i=0,j=0; i<list.length; i++)
		if (list[i] != f)
			nlist[j++] = list[i];
	list = nlist;
	}
}

class EditorWindow extends FixedFrame implements CbButtonCallback
{
	TextField name;
	TextArea edit;
	CbButton save_b, cancel_b;
	RemoteFile file;
	FileManager filemgr;

	// Editing an existing file
	EditorWindow(RemoteFile f, FileManager p)
	{
	super(500, 300);
	file = f; filemgr = p;
	makeUI(false);
	setTitle(filemgr.text("edit_title", file.path));

	// Load the file
	try {
		URL u = new URL(filemgr.getDocumentBase(),
				"show.cgi"+filemgr.urlize(file.path)+
				"?rand="+System.currentTimeMillis());
		URLConnection uc = u.openConnection();
		byte buf[] = new byte[uc.getContentLength()];
		InputStream is = uc.getInputStream();
		int got = 0;
		while(got < buf.length)
			got += is.read(buf, got, buf.length-got);
		edit.setText(new String(buf, 0));
		is.close();
		file.size = buf.length;
		}
	catch(Exception e) { e.printStackTrace(); }
	}

	// Creating a new file
	EditorWindow(String f, FileManager p)
	{
	super(500, 300);
	filemgr = p;
	makeUI(true);
	setTitle(filemgr.text("edit_title2"));
	name.setText(f.equals("/") ? f : f+"/");
	name.select(name.getText().length(), name.getText().length());
	}

	void makeUI(boolean add_name)
	{
	setLayout(new BorderLayout());
	if (add_name) {
		Panel np = new Panel();
		np.setLayout(new BorderLayout());
		np.add("West", new Label(filemgr.text("edit_filename")));
		np.add("Center", name = new TextField());
		add("North", np);
		}
	add("Center", edit = new TextArea(20, 80));
	edit.setFont(new Font("courier", Font.PLAIN, 14));
	Panel bot = new Panel();
	bot.setLayout(new FlowLayout(FlowLayout.RIGHT));
	bot.add(save_b = new CbButton(filemgr.get_image("save.gif"),
				      filemgr.text("save"),
				      CbButton.LEFT, this));
	bot.add(cancel_b = new CbButton(filemgr.get_image("cancel.gif"),
					filemgr.text("cancel"),
					CbButton.LEFT, this));
	add("South", bot);
	pack();
	show();
	}

	public void click(CbButton b)
	{
	if (b == save_b) {
		RemoteFile par = null, already = null;
		String save_path;
		if (file == null) {
			// Locate the filemgr directory
			save_path = filemgr.trim_path(name.getText());
			int sl = save_path.lastIndexOf('/');
			par = filemgr.find_directory(
					save_path.substring(0, sl), false);
			if (par == null) return;
			already = par.find(save_path.substring(sl+1));
			if (already != null &&
			    (already.type == 0 || already.type == 5)) {
				new ErrorWindow(
					filemgr.text("edit_eover", save_path));
				return;
				}
			}
		else save_path = file.path;

		// Save the file back again
		String s = edit.getText(), line;
		try {
			URL u = new URL(filemgr.getDocumentBase(),
					"save.cgi"+filemgr.urlize(save_path)+
					"?rand="+System.currentTimeMillis());
			URLConnection uc = u.openConnection();
			uc.setDoOutput(true);
			OutputStream os = uc.getOutputStream();
			byte buf[] = new byte[s.length()];
			s.getBytes(0, buf.length, buf, 0);
			os.write(buf);
			LineInputStream is = new LineInputStream(
							uc.getInputStream());
			String err = is.gets();
			if (err.length() > 0) {
				new ErrorWindow(
					filemgr.text("edit_esave", err));
				is.close();
				return;
				}
			line = is.gets();
			is.close();
			}
		catch(Exception e) { e.printStackTrace(); return; }

		if (file == null) {
			// Create and insert or replace the file object
			file = new RemoteFile(filemgr, line, par);
			if (already != null) {
				// A file with this name exists
				already.type = file.type;
				already.user = file.user;
				already.group = file.group;
				already.size = file.size;
				already.perms = file.perms;
				already.modified = file.modified;
				}
			else {
				// Add to the list
				par.add(file);
				}
			}
		else {
			file.size = s.length();
			file.modified = System.currentTimeMillis();
			}
		filemgr.show_files(filemgr.showing_files);
		dispose();
		}
	else {
		// Just close
		dispose();
		}
	}
}

class PropertiesWindow extends FixedFrame implements CbButtonCallback
{
	RemoteFile file;
	FileManager filemgr;
	CbButton save_b, cancel_b;

	TextField linkto;
	TextField user, group;
	Checkbox setuid, setgid;
	PermissionsPanel user_p, group_p, other_p;
	Checkbox sticky;
	Choice rec_mode;

	PropertiesWindow(RemoteFile f, FileManager p)
	{
	file = f;
	filemgr = p;

	// Create UI
	setTitle(f.path);
	setLayout(new BorderLayout());
	Panel bot = new Panel();
	bot.setLayout(new FlowLayout(FlowLayout.RIGHT));
	bot.add(save_b = new CbButton(filemgr.get_image("save.gif"),
				      filemgr.text("save"),
				      CbButton.LEFT, this));
	bot.add(cancel_b = new CbButton(filemgr.get_image("cancel.gif"),
					filemgr.text("cancel"),
					CbButton.LEFT, this));
	add("South", bot);
	Panel mid = new Panel();
	mid.setLayout(new BorderLayout());
	add("Center", mid);

	// Create file details section
	Panel det = new LinedPanel(filemgr.text("info_file")),
	      dl = new Panel(), dr = new Panel();
	setup_leftright(det, dl, dr);
	add_item(filemgr.text("info_path"),
		new Label(file.path), dl, dr);
	add_item(filemgr.text("info_type"),
		new Label(filemgr.text("file_type"+file.type)), dl, dr);
	add_item(filemgr.text("info_size"),
		new Label(String.valueOf(file.size)),dl,dr);
	add_item(filemgr.text("info_mod"),
		new Label(String.valueOf(new Date(file.modified))), dl, dr);
	if (file.type == 5)
		add_item(filemgr.text("info_link"),
			 linkto = new TextField(file.linkto, 30), dl, dr);
	mid = add_panel(mid, det);

	// Create permissions section
	Panel per = new LinedPanel(filemgr.text("info_perms")),
	      pl = new Panel(), pr = new Panel();
	setup_leftright(per, pl, pr);
	add_item(filemgr.text("info_user"),
		 user_p = new PermissionsPanel(file, 64, filemgr), pl, pr);
	add_item(filemgr.text("info_group"),
		 group_p = new PermissionsPanel(file, 8, filemgr), pl, pr);
	add_item(filemgr.text("info_other"),
		 other_p = new PermissionsPanel(file, 1, filemgr), pl,pr);
	if (file.type == 0) {
		add_item(filemgr.text("info_sticky"), sticky = new Checkbox(
					filemgr.text("info_sticky2")), pl,pr);
		sticky.setState((file.perms&01000) != 0);
		}
	mid = add_panel(mid, per);

	// Create ownership section
	Panel own = new LinedPanel(filemgr.text("info_own")),
	      ol = new Panel(), or = new Panel();
	setup_leftright(own, ol, or);
	add_item(filemgr.text("info_user"),
		 user = new TextField(file.user, 10), ol, or);
	if (file.type != 0) {
		add_item(filemgr.text("info_setuid"),
			 setuid = new Checkbox(filemgr.text("info_setuid2")),
			 ol, or);
		setuid.setState((file.perms & 0x800) != 0);
		}
	add_item(filemgr.text("info_group"),
		 group = new TextField(file.group, 10), ol, or);
	if (file.type == 0)
		add_item(filemgr.text("info_setgid"),
		  setgid = new Checkbox(filemgr.text("info_setgid2")), ol, or);
	else
		add_item(filemgr.text("info_setgid"),
		  setgid = new Checkbox(filemgr.text("info_setgid3")), ol, or);
	setgid.setState((file.perms & 0x400) != 0);
	mid = add_panel(mid, own);

	if (file.type == 0) {
		// Create recursion section
		Panel rec = new LinedPanel(filemgr.text("info_apply"));
		rec.setLayout(new BorderLayout());
		rec_mode = new Choice();
		for(int i=1; i<=3; i++)
			rec_mode.addItem(filemgr.text("info_apply"+i));
		rec.add("Center", rec_mode);
		mid = add_panel(mid, rec);
		}

	pack();
	show();
	}

	Panel add_panel(Panel p, Component c)
	{
	p.add("North", c);
	Panel np = new Panel();
	np.setLayout(new BorderLayout());
	p.add("Center", np);
	return np;
	}

	public void click(CbButton b)
	{
	if (b == save_b) {
		// Update the file
		int perms = 0;
		if (setuid == null)
			perms |= (file.perms & 0x800);
		else
			perms |= (setuid.getState() ? 0x800 : 0);
		perms |= (setgid.getState() ? 0x400 : 0);
		perms |= user_p.getPerms();
		perms |= group_p.getPerms();
		perms |= other_p.getPerms();
		if (sticky == null)
			perms |= (file.perms & 01000);
		else
			perms |= (sticky.getState() ? 01000 : 0);
		int rec = 0;
		if (file.type == 0)
			rec = rec_mode.getSelectedIndex();
		String rv[] = filemgr.get_text(
			"chmod.cgi?path="+filemgr.urlize(file.path)+
			"&perms="+perms+"&user="+user.getText()+
			"&group="+group.getText()+"&rec="+rec+
			(linkto==null ? "" : "&linkto="+linkto.getText()));
		if (rv[0].length() > 0) {
			// Something went wrong
			new ErrorWindow(filemgr.text("info_efailed",
					file.path, rv[0]));
			}
		else {
			// Update all changed file objects
			if (linkto != null)
				file.linkto = linkto.getText();
			else if (rec == 0)
				update_file(file, perms, false);
			else if (rec == 1) {
				// Update files in this directory
				update_file(file, perms, false);
				recurse_files(file, perms, false);
				}
			else if (rec == 2) {
				// Update files and subdirs
                                update_file(file, perms, false);
				recurse_files(file, perms, true);
				}

			// Update directory list
			int os = filemgr.files.selected();
			filemgr.show_files(filemgr.showing_files);
			filemgr.files.select(os);
			dispose();
			}
		}
	else {
		// Just close
		dispose();
		}
	}

	void update_file(RemoteFile f, int perms, boolean perms_only)
	{
	f.user = user.getText();
	f.group = group.getText();
	if (perms_only)
		f.perms = (perms & 0777) | (f.perms & 037777777000);
	else
		f.perms = perms;
	}

	void recurse_files(RemoteFile f, int perms, boolean do_subs)
	{
	if (f.list == null) return;
	for(int i=0; i<f.list.length; i++) {
		RemoteFile ff = f.list[i];
		if (ff.type == 5) continue;
		else if (ff.type == 0) {
			if (do_subs) {
				update_file(ff, perms, false);
				recurse_files(ff, perms, true);
				}
			}
		else update_file(ff, perms, true);
		}
	}

	void setup_leftright(Panel m, Panel l, Panel r)
	{
	m.setLayout(new BorderLayout());
	Panel p = new Panel();
	p.setLayout(new BorderLayout());
	p.add("West", l);
	p.add("Center", r);
	l.setLayout(new GridLayout(0, 1));
	r.setLayout(new GridLayout(0, 1));
	m.add("North", p);
	}

	void add_item(String t, Component c, Panel l, Panel r)
	{
	l.add(new Label(t));
	Panel p = new Panel();
	p.setLayout(new BorderLayout());
	p.add("West", c);
	r.add(p);
	}
}

class PermissionsPanel extends Panel
{
	Checkbox read, write, exec;
	int base;

	PermissionsPanel(RemoteFile file, int base, FileManager filemgr)
	{
	int perms = file.perms;
	this.base = base;
	setLayout(new GridLayout(1, 3));
	add(read = new Checkbox(filemgr.text("info_read")));
	read.setState((perms&(base<<2)) != 0);
	add(write = new Checkbox(filemgr.text("info_write")));
	write.setState((perms&(base<<1)) != 0);
	add(exec = new Checkbox(
		filemgr.text(file.type==0 ? "info_list" : "info_exec")));
	exec.setState((perms&base) != 0);
	}

	int getPerms()
	{
	int rv = 0;
	rv |= (read.getState() ? (base<<2) : 0);
	rv |= (write.getState() ? (base<<1) : 0);
	rv |= (exec.getState() ? base : 0);
	return rv;
	}
}

class DeleteWindow extends FixedFrame implements CbButtonCallback
{
	CbButton delete_b, cancel_b;
	FileManager filemgr;
	RemoteFile file;

	DeleteWindow(FileManager p, RemoteFile f)
	{
	filemgr = p;
	file = f;
	setTitle(filemgr.text(f.type == 0 ? "delete_dtitle" : "delete_ftitle"));

	setLayout(new BorderLayout());
	add("Center", new MultiLabel(filemgr.text(
		f.type == 0 ? "delete_ddesc" : "delete_fdesc", f.path), 35));
	Panel bot = new Panel();
	bot.setLayout(new FlowLayout(FlowLayout.CENTER));
	bot.add(delete_b = new CbButton(filemgr.get_image("save.gif"),
				        filemgr.text("delete"),
					CbButton.LEFT, this));
	bot.add(cancel_b = new CbButton(filemgr.get_image("cancel.gif"),
					filemgr.text("cancel"),
					CbButton.LEFT, this));
	add("South", bot);

	pack();
	show();
	}

	public void click(CbButton b)
	{
	if (b == delete_b) {
		// Delete the file or directory
		String rv[] = filemgr.get_text("delete.cgi?file="+
					       filemgr.urlize(file.path));
		if (rv[0].length() > 0)
			new ErrorWindow(filemgr.text("delete_efailed",
					file.path, rv[0]));
		else {
			// done the deed.. update data structures
			RemoteFile pf = file.directory;
			pf.delete(file);
			if (filemgr.showing_files == pf) {
				// Need to refresh the list as well..
				filemgr.show_files(pf);
				}

			FileNode node = (FileNode)filemgr.nodemap.get(file);
			FileNode pnode = (FileNode)filemgr.nodemap.get(pf);
			if (node != null) {
				// Take the directory out of the tree..
				pnode.ch.removeElement(node);
				filemgr.dirs.redraw();
				}
			}
		dispose();
		}
	else if (b == cancel_b)
		dispose();
	}
}

class MkdirWindow extends FixedFrame implements CbButtonCallback
{
	FileManager filemgr;
	TextField dir;
	CbButton create_b, cancel_b;

	MkdirWindow(String d, FileManager p)
	{
	filemgr = p;
	setTitle(filemgr.text("mkdir_title"));
	setLayout(new BorderLayout());
	add("West", new Label(filemgr.text("mkdir_dir")));
	add("Center", dir = new TextField(d.equals("/") ? "/" : d+"/", 40));
	dir.select(dir.getText().length(), dir.getText().length());
	Panel bot = new Panel();
	bot.setLayout(new FlowLayout(FlowLayout.CENTER));
	bot.add(create_b = new CbButton(filemgr.get_image("save.gif"),
				        filemgr.text("create"),
					CbButton.LEFT, this));
	bot.add(cancel_b = new CbButton(filemgr.get_image("cancel.gif"),
					filemgr.text("cancel"),
					CbButton.LEFT, this));
	add("South", bot);
	pack();
	show();
	}

	public void click(CbButton b)
	{
	if (b == create_b) {
		// Find the filemgr directory
		String path = dir.getText();
		path = filemgr.trim_path(path);
		int sl = path.lastIndexOf('/');
		RemoteFile par = filemgr.find_directory(
					path.substring(0, sl), false);
		if (par.find(path.substring(sl+1)) != null) {
			new ErrorWindow(filemgr.text("mkdir_eexists", path));
			return;
			}
		String rv[] = filemgr.get_text("mkdir.cgi?dir="+
					       filemgr.urlize(path));
		if (rv[0].length() > 0) {
			new ErrorWindow(filemgr.text("mkdir_efailed", rv[0]));
			return;
			}
		RemoteFile file = new RemoteFile(filemgr, rv[1], par);
		par.add(file);
		FileNode parnode = (FileNode)filemgr.nodemap.get(par);
		if (parnode != null) {
			// Update the tree
			parnode.add(new FileNode(file));
			filemgr.dirs.redraw();
			}
		filemgr.show_files(filemgr.showing_files);
		dispose();
		}
	else dispose();
	}
}

class LinkWindow extends FixedFrame implements CbButtonCallback
{
	FileManager filemgr;
	TextField from, to;
	CbButton create_b, cancel_b;

	LinkWindow(String d, FileManager p)
	{
	filemgr = p;
	setLayout(new BorderLayout());
	setTitle(filemgr.text("link_title"));
	Panel l = new Panel(), r = new Panel();
	l.setLayout(new GridLayout(0, 1));
	l.add(new Label(filemgr.text("link_from")));
	l.add(new Label(filemgr.text("link_to")));
	r.setLayout(new GridLayout(0, 1));
	r.add(from = new TextField(d.equals("/") ? "/" : d+"/", 40));
	from.select(from.getText().length(), from.getText().length());
	r.add(to = new TextField());
	add("West", l); add("Center", r);
	Panel bot = new Panel();
	bot.setLayout(new FlowLayout(FlowLayout.CENTER));
	bot.add(create_b = new CbButton(filemgr.get_image("save.gif"),
				        filemgr.text("create"),
					CbButton.LEFT, this));
	bot.add(cancel_b = new CbButton(filemgr.get_image("cancel.gif"),
					filemgr.text("cancel"),
					CbButton.LEFT, this));
	add("South", bot);
	pack();
	show();
	}

	public void click(CbButton b)
	{
	if (b == create_b) {
		// Check inputs
		String from_str = from.getText().trim();
		int sl = from_str.lastIndexOf('/');
		String par_str = from_str.substring(0, sl),
		       file_str = from_str.substring(sl+1);
		RemoteFile par = filemgr.find_directory(par_str, false);
		if (par == null) return;
		if (par.find(file_str) != null) {
			new ErrorWindow(filemgr.text("link_eexists", from_str));
			return;
			}

		// Create the actual link
		String rv[] = filemgr.get_text("makelink.cgi?from="+
					       filemgr.urlize(from_str)+"&to="+
					       filemgr.urlize(to.getText()));
		if (rv[0].length() > 0) {
			new ErrorWindow(filemgr.text("link_efailed", rv[0]));
			return;
			}
		RemoteFile file = new RemoteFile(filemgr, rv[1], par);
		par.add(file);
		filemgr.show_files(filemgr.showing_files);
		dispose();
		}
	else if (b == cancel_b)
		dispose();
	}
}

class RenameWindow extends FixedFrame implements CbButtonCallback
{
	FileManager filemgr;
	RemoteFile file;
	TextField oldname, newname;
	CbButton rename_b, cancel_b;

	RenameWindow(FileManager p, RemoteFile f)
	{
	filemgr = p; file = f;
	setLayout(new BorderLayout());
	setTitle(filemgr.text("rename_title", file.path));
	Panel l = new Panel(), r = new Panel();
	l.setLayout(new GridLayout(0, 1));
	l.add(new Label(filemgr.text("rename_old")));
	l.add(new Label(filemgr.text("rename_new")));
	r.setLayout(new GridLayout(0, 1));
	r.add(oldname = new TextField(file.name, 20));
	oldname.setEditable(false);
	r.add(newname = new TextField(file.name, 20));
	newname.select(file.name.length(), file.name.length());
	add("West", l); add("Center", r);

	Panel bot = new Panel();
	bot.setLayout(new FlowLayout(FlowLayout.CENTER));
	bot.add(rename_b = new CbButton(filemgr.get_image("save.gif"),
				        filemgr.text("rename_ok"),
					CbButton.LEFT, this));
	bot.add(cancel_b = new CbButton(filemgr.get_image("cancel.gif"),
					filemgr.text("cancel"),
					CbButton.LEFT, this));
	add("South", bot);
	pack();
	show();
	}

	public void click(CbButton b)
	{
	if (b == rename_b) {
		// Check for an existing file
		String newstr = newname.getText().trim();
		if (newstr.length() == 0) return;
		RemoteFile already = file.directory.find(newstr);
		if (already != null) {
			new ErrorWindow(filemgr.text("rename_eexists", newstr));
			return;
			}

		// Rename the real file
		int sl = file.path.lastIndexOf('/');
		String newpath = file.path.substring(0, sl)+"/"+newstr;
		String rv[] = filemgr.get_text(
				"rename.cgi?old="+filemgr.urlize(file.path)+
				"&new="+filemgr.urlize(newpath));
		if (rv[0].length() > 0) {
			new ErrorWindow(filemgr.text("rename_efailed", rv[0]));
			return;
			}

		// Update data structures
		file.name = newstr;
		file.path = newpath;
		file.directory.delete(file);
		file.directory.add(file);
		FileNode parnode = (FileNode)filemgr.nodemap.get(file.directory);
		FileNode filenode = (FileNode)filemgr.nodemap.get(file);
		if (parnode != null && filenode != null) {
			filenode.text = file.name;
			parnode.ch.removeElement(filenode);
			parnode.add(filenode);
			dispose();
			filemgr.dirs.redraw();
			}
		filemgr.show_files(filemgr.showing_files);
		dispose();
		}
	else if (b == cancel_b)
		dispose();
	}
}

class MultiLabel extends BorderPanel
{
	public MultiLabel(String s, int max)
	{
	super(1);
	Vector v = new Vector();
	StringTokenizer tok = new StringTokenizer(s.trim(), " \t");
	String line = null;
	while(tok.hasMoreTokens()) {
		String w = tok.nextToken();
		line = (line == null ? w : line+" "+w);
		if (line.length() > max || !tok.hasMoreTokens()) {
			v.addElement(line);
			line = null;
			}
		}
	setLayout(new GridLayout(v.size(), 0, 0, 0));
	for(int i=0; i<v.size(); i++)
		add(new Label((String)v.elementAt(i), Label.CENTER));
	}
}
