#!/usr/local/bin/perl
# save_host.cgi
# Update, create or delete a host

require './dhcpd-lib.pl';
require './params-lib.pl';
&ReadParse();
$parent = &get_parent_config();
$conf = $parent->{'members'};
if ($in{'delete'}) {
	# Delete this host
	$whatfailed = $text{'shost_faildel'};
	if ($in{'gidx'} ne "") {
		# deleting from within group
		$group = $conf->[$in{'gidx'}];
		$host = $group->{'members'}->[$in{'idx'}];
		&save_directive($group, [ $host ], [ ], 0);
		}
	else {
		# deleting from top level
		$host = $conf->[$in{'idx'}];
		&save_directive($parent, [ $host ], [ ], 0);
		}
	}
elsif ($in{'options'}) {
	# Redirect to client options
	&redirect("edit_options.cgi?pidx=$in{'gidx'}&idx=$in{'idx'}");
	}
else {
	$whatfailed = $text{'shost_failsave'};
	if (!$in{'new'}) {
		# Get the old host structure
		if ($in{'gidx'} ne "") {
			$group = $conf->[$in{'gidx'}];
			$host = $group->{'members'}->[$in{'idx'}];
			}
		else { $host = $conf->[$in{'idx'}]; }
		}
	else {
		# Creating a new structure
		$host->{'name'} = "host";
		$host->{'type'} = 1;
		$host->{'members'} = [ ];
		}

	# Validate and save inputs
	$in{'name'} =~ /^[A-z0-9\.\-]+$/ ||
		&error("'$in{'name'}' $text{'shost_invalidhn'}");
	$host->{'values'} = [ $in{'name'} ];

	if ($in{'hardware'}) {
		$in{'hardware'} =~ /^[0-9A-Fa-f:]+$/ ||
			&error(&text('shost_invalidhwa',$in{'hardware'},$in{'hardware_type'}) );
		@hard = ( { 'name' => 'hardware',
			    'values' => [ $in{'hardware_type'},
					  $in{'hardware'} ] } );
		}
	&save_directive($host, 'hardware', \@hard);

	if ($in{'fixed-address'}) {
		@fixedip = split(/\s+/, $in{'fixed-address'});
		@fixed = ( { 'name' => 'fixed-address',
			     'values' => [ join(" , ", @fixedip) ] } );
		}
	&save_directive($host, 'fixed-address', \@fixed);

	&save_choice("use-host-decl-names", $host);
	&parse_params($host);

	if ($in{'new'}) {
		# Add to the end of the file
		&save_directive($parent, [ ], [ $host ], 0);
		}
	elsif ($group) {
		# Update host within a group
		&save_directive($group, [ $host ], [ $host ], 1);
		}
	else {
		# Update host at top level
		&save_directive($parent, [ $host ], [ $host ], 0);
		}
	}
&flush_file_lines();
&redirect("");

