# mod_negotiation.pl
# Defines editors content negotiation directives

sub mod_negotiation_directives
{
$rv = [ [ 'CacheNegotiatedDocs', 0, 6, 'global' ],
        [ 'LanguagePriority', 0, 6, 'virtual directory htaccess' ] ];
return &make_directives($rv, $_[0], "mod_negotiation");
}

sub mod_negotiation_handlers
{
return ("type-map");
}

sub edit_CacheNegotiatedDocs
{
local($v); $v = $_[0] ? "1" : "0";
return (1, "Cache content-negotiated documents?",
        &choice_input($v, "CacheNegotiatedDocs", "0",
        "Yes,1", "No,0"));
}
sub save_CacheNegotiatedDocs
{
return $in{'CacheNegotiatedDocs'} ? ( [ "" ] ) : ( [ ] );
}

sub edit_LanguagePriority
{
return (1, "Language priority for multi-views",
        &opt_input($_[0]->{'value'}, "LanguagePriority", "Default", 15));
}
sub save_LanguagePriority
{
return &parse_opt("LanguagePriority", '\S', "Missing language priorities");
}

1;

