# mod_log_referer.pl
# Defines editors for logging

sub mod_log_referer_directives
{
$rv = [ [ 'RefererLog', 0, 3, 'virtual' ],
        [ 'RefererIgnore', 0, 3, 'virtual' ] ];
return &make_directives($rv, $_[0], "mod_log_referer");
}

sub edit_RefererLog
{
local($rv);
$rv = sprintf "<input type=radio name=RefererLog_mode value=0 %s> Default\n",
       $_[0] ? "" : "checked";
$rv .= sprintf "<input type=radio name=RefererLog_mode value=1 %s> File..",
	 $_[0] && $_[0]->{'value'} !~ /^\|/ ? "checked" : "";
$rv .= sprintf "<input type=radio name=RefererLog_mode value=2 %s> Program..",
	 $_[0]->{'value'} =~ /^\|/ ? "checked" : "";
$rv .= sprintf "<input name=RefererLog size=20 value=\"%s\">\n",
        $_[0]->{'value'} =~ /^\|(.*)$/ ? $1 : $_[0]->{'value'};
return (1, "Referer log file", $rv); 
}
sub save_RefererLog
{
if ($in{'RefererLog_mode'} == 0) { return ( [ ] ); }
$in{'RefererLog'} =~ /^\S+$/ ||
	&error("$in{'RefererLog'} is not a valid referer log filename");
&allowed_auth_file($in{'RefererLog'}) ||
	&error("referer log is not under the allowed directory");
if ($in{'RefererLog_mode'} == 1) { return ( [ $in{'RefererLog'} ] ); }
else { return ( [ "|$in{'RefererLog'}" ] ); }
}

sub edit_RefererIgnore
{
local($rv);
$rv = "<textarea name=RefererIgnore rows=3 cols=20>".
      join("\n", split(/\s+/, $_[0]->{'value'})).
      "</textarea>\n";
return (1, "Don't log references from", $rv);
}
sub save_RefererIgnore
{
local(@rv);
@rv = split(/\s+/, $in{'RefererIgnore'});
if (@rv) { return ( [ join(' ', @rv) ] ); }
else { return ( [ ] ); }
}

1;

