# mod_cgi.pl
# Defines editors CGI logging directives

sub mod_cgi_directives
{
local($rv);
$rv = [ [ 'ScriptLog', 0, 11, 'global', 1.2 ],
        [ 'ScriptLogLength', 0, 11, 'global', 1.2 ],
        [ 'ScriptLogBuffer', 0, 11, 'global', 1.2 ] ];
return &make_directives($rv, $_[0], "mod_cgi");
}

sub mod_cgi_handlers
{
return ("cgi-script");
}

sub edit_ScriptLog
{
return (1, "CGI Script log",
        &opt_input($_[0]->{'value'}, "ScriptLog", "None", 20).
        &file_chooser_button("ScriptLog", 0));
}
sub save_ScriptLog
{
$in{'ScriptLog_def'} || &allowed_auth_file($in{'ScriptLog'}) ||
	&error("CGI script log is not under the allowed directory");
return &parse_opt("ScriptLog", '^\S+$', "Invalid CGI script log file");
}

sub edit_ScriptLogLength
{
return (1, "Maximum CGI log size",
        &opt_input($_[0]->{'value'}, "ScriptLogLength", "Default", 8)."bytes");
}
sub save_ScriptLogLength
{
return &parse_opt("ScriptLogLength", '^\d+$', "CGI log size must be an integer");
}

sub edit_ScriptLogBuffer
{
return (1, "Maximum logged post data size",
        &opt_input($_[0]->{'value'}, "ScriptLogBuffer", "Default", 6)."bytes");
}
sub save_ScriptLogBuffer
{
return &parse_opt("ScriptLogBuffer", '^\d+$', "Post data size must be an integer");
}

1;

