# mod_cern_meta.pl
# Defines editors CERN metafile directives

sub mod_cern_meta_directives
{
local($rv);
$rv = [ [ 'MetaFiles', 0, 5, 'directory', 1.3 ],
        [ 'MetaDir', 0, 5, 'server', -1.3 ],
        [ 'MetaDir', 0, 5, 'directory', 1.3 ],
        [ 'MetaSuffix', 0, 5, 'server', -1.3 ],
        [ 'MetaSuffix', 0, 5, 'directory', 1.3 ] ];
return &make_directives($rv, $_[0], "mod_cern_meta");
}

sub edit_MetaFiles
{
return (1, "Process header metafiles",
        &choice_input($_[0]->{'value'}, "MetaFiles", "off",
        "Yes,on", "No,off"));
}
sub save_MetaFiles
{
return &parse_choice("MetaFiles", "off");
}

sub edit_MetaDir
{
return (1, "Subdirectory for header metafiles",
        &opt_input($_[0]->{'value'}, "MetaDir", "Default", 8));
}
sub save_MetaDir
{
return &parse_opt("MetaDir", '^\S+$', "Invalid metafile subdirectory name");
}

sub edit_MetaSuffix
{
return (1, "File suffix for header metafiles",
        &opt_input($_[0]->{'value'}, "MetaSuffix", "Default", 15));
}
sub save_MetaSuffix
{
return &parse_opt("MetaSuffix", '^\S+$', "Invalid metafile suffix");
}

1;

