#!/usr/local/bin/perl
# cert_issue.cgi

require './acl-lib.pl';
&ReadParse();

&error_setup($text{'cert_err'});
$in{'key'} || &error($text{'cert_ekey'});
&get_miniserv_config(\%miniserv);

# Create the new key
$temp1 = &tempname();
$temp2 = &tempname();
open(IN, ">$temp1");
foreach $k ("emailAddress", "organizationalUnitName", "organizationName",
	    "stateOrProvinceName", "countryName", "commonName") {
	print IN "$k = $in{$k}\n";
	}
$in{'key'} =~ s/\s//g;
print IN "SPKAC = $in{'key'}\n";
close(IN);
$ssleay = `$config{'ssleay'} ca -spkac $temp1 -out $temp2 -config $module_config_directory/openssl.cnf 2>&1`;
unlink($temp1);
if ($?) {
	&error("<pre>$ssleay</pre>");
	}
else {
	# Display status and redirect to actual cert file
	$| = 1;
	&header($text{'cert_title'}, "");
	print "<hr>\n";
	print "<p>",&text('cert_ok', $in{'commonName'}),"<p>\n";
	print "<script>\n";
	print "location = 'cert_output.cgi?file=$temp2'\n";
	print "</script>\n";
	print "<hr>\n";
	&footer("", $text{'index_return'});

	# Update the miniserv users file
	$lref = &read_file_lines($miniserv{'userfile'});
	foreach $l (@$lref) {
		@u = split(/:/, $l);
		print STDERR "$u[0] $ENV{'REMOTE_USER'} $l\n";
		if ($u[0] eq $ENV{'REMOTE_USER'}) {
			$l = "$u[0]:$u[1]:$u[2]:/C=$in{'countryName'}/ST=$in{'stateOrProvinceName'}/O=$in{'organizationName'}/OU=$in{'organizationalUnitName'}/CN=$in{'commonName'}/Email=$in{'emailAddress'}";
			}
		}
	&flush_file_lines();

	sleep(1);
	&restart_miniserv();
	}

