# admin-lib.pl
# Library for editing webmin users, passwords and access rights

do '../web-lib.pl';
&init_config();
%access = &get_module_acl();

sub list_users
{
local(@mods, %miniserv, $_, @rv, %acl);
&read_acl(undef, \%acl);
@mods = &list_modules();
&get_miniserv_config(\%miniserv);
open(PWFILE, $miniserv{'userfile'});
while(<PWFILE>) {
	if (/^([^:\s]+):([^:\s]+)(:(\d+))?(:(.*))?/) {
		local(%user);
		$user{'name'} = $1;
		$user{'pass'} = $2;
		$user{'sync'} = $4 if ($3);
		$user{'cert'} = $6 if ($5);
		$user{'modules'} = $acl{$1};
		$user{'lang'} = $gconfig{"lang_$1"};
		$user{'notabs'} = $gconfig{"notabs_$1"};
		push(@rv, \%user);
		}
	}
close(PWFILE);
return @rv;
}

# list_modules()
# Returns a list of all modules available on this system
sub list_modules
{
local(@rv, $d);
opendir(DIR, "..");
foreach $d (readdir(DIR)) {
	undef(%minfo);
	if ($d !~ /^\./ && (%minfo = &get_module_info($d)) &&
	    &check_os_support(\%minfo)) {
		push(@rv, $d);
		}
	}
closedir(DIR);
return @rv;
}

# module_info(module)
# Returns an array of  module, name, desc, [os_support]
sub module_info
{
local %module = &get_module_info($_[0]);
return ($_[0], $module{'name'}, $module{"desc"}, $module{'os_support'});
}

# create_user(&details, clone)
sub create_user
{
local(%user, %miniserv, @mods);
%user = %{$_[0]};
&get_miniserv_config(\%miniserv);
open(PWFILE, ">> $miniserv{'userfile'}");
print PWFILE "$user{'name'}:$user{'pass'}:$user{'sync'}:$user{'cert'}\n";
close(PWFILE);
@mods = &list_modules();
open(ACL, ">> ".&acl_filename());
print ACL &acl_line(\%user, \@mods);
close(ACL);

delete($gconfig{"lang_".$user{'name'}});
if ($user{'lang'}) {
	$gconfig{"lang_".$user{'name'}} = $user{'lang'};
	}
delete($gconfig{"notabs_".$user{'name'}});
if ($user{'notabs'}) {
	$gconfig{"notabs_".$user{'name'}} = $user{'notabs'};
	}
&write_file("$config_directory/config", \%gconfig);

if ($_[1]) {
	foreach $m (@mods) {
		local $file = "$config_directory/$m/$_[1].acl";
		local $dest = "$config_directory/$m/$user{'name'}.acl";
		if (-r $file) {
			local %macl;
			&read_file($file, \%macl);
			&write_file($dest, \%macl);
			}
		}
	}
}

# modify_user(name, &details)
sub modify_user
{
local(%user, %miniserv, @pwfile, @acl, @mods, $_, $m);
%user = %{$_[1]};
&get_miniserv_config(\%miniserv);

open(PWFILE, $miniserv{'userfile'});
@pwfile = <PWFILE>;
close(PWFILE);
open(PWFILE, "> $miniserv{'userfile'}");
foreach (@pwfile) {
	if (/^([^:\s]+):([^:\s]+)/ && $1 eq $_[0]) {
		print PWFILE "$user{'name'}:$user{'pass'}:$user{'sync'}:$user{'cert'}\n";
		}
	else { print PWFILE $_; }
	}
close(PWFILE);

@mods = &list_modules();
open(ACL, &acl_filename());
@acl = <ACL>;
close(ACL);
open(ACL, "> ".&acl_filename());
foreach (@acl) {
	if (/^(\S+):/ && $1 eq $_[0]) {
		print ACL &acl_line($_[1], \@mods);
		}
	else { print ACL $_; }
	}
close(ACL);

delete($gconfig{"lang_".$_[0]});
if ($user{'lang'}) {
	$gconfig{"lang_".$user{'name'}} = $user{'lang'};
	}
delete($gconfig{"notabs_".$_[0]});
if ($user{'notabs'}) {
	$gconfig{"notabs_".$user{'name'}} = $user{'notabs'};
	}
&write_file("$config_directory/config", \%gconfig);

foreach $m (@mods) {
	local $file = "$config_directory/$m/$_[0].acl";
	if (-r $file) {
		rename($file, "$config_directory/$m/$user{'name'}.acl");
		}
	}
}

# delete_user(name)
# Delete some user from the ACL and password files
sub delete_user
{
local($_, @pwfile, @acl, %miniserv);
&get_miniserv_config(\%miniserv);
open(PWFILE, $miniserv{'userfile'});
@pwfile = <PWFILE>;
close(PWFILE);
open(PWFILE, "> $miniserv{'userfile'}");
foreach (@pwfile) {
	if (!/^([^:\s]+):([^:\s]+)/ || $1 ne $_[0]) { print PWFILE $_; }
	}
close(PWFILE);

open(ACL, &acl_filename());
@acl = <ACL>;
close(ACL);
open(ACL, "> ".&acl_filename());
foreach (@acl) {
	if (!/^(\S+):/ || $1 ne $_[0]) { print ACL $_; }
	}
close(ACL);

unlink(map { "$config_directory/$_/$_[0].acl" } &list_modules());
}

# acl_line(&user, &allmodules)
# Internal function to generate an ACL file line
sub acl_line
{
local(%user);
%user = %{$_[0]};
return "$user{'name'}: ".join(' ', @{$user{'modules'}})."\n";
}

# can_edit_user(user)
sub can_edit_user
{
return 1 if ($access{'users'} eq '*');
local $u;
foreach $u (split(/\s+/, $access{'users'})) {
	return 1 if ($u eq $_[0]);
	}
return 0;
}

1;

