/* -*- mode: c; c-basic-offset: 2; tab-width: 8; -*- */
/* $Id: table.h,v 1.3 2000/04/06 01:25:00 aito Exp $ */
#if (defined(MESCHACH) && !defined(MATRIX))
#define MATRIX
#endif /* (defined(MESCHACH) && !defined(MATRIX)) */

#ifdef MATRIX
#ifdef MESCHACH
#include <matrix2.h>
#else /* not MESCHACH */
#include "matrix.h"
#endif /* not MESCHACH */
#endif /* MATRIX */

#include "Str.h"

#define MAX_TABLE 20  /* maximum nest level of table */
#define MAX_TABLE_N 20  /* maximum number of table in same level */

#define MAXROW 50
#define MAXCOL 50

#define MAX_WIDTH 80

#define BORDER_NONE 0
#define BORDER_THIN 1
#define BORDER_THICK 2
#define BORDER_NOWIN 3

typedef unsigned char table_attr;

/* flag */
#define TBL_IN_ROW     1
#define TBL_EXPAND_OK  2
#define TBL_IN_COL     4

#define MAXCELL 20
struct table_cell {
    short col[MAXCELL];
    short colspan[MAXCELL];
    char  index[MAXCELL];
    short maxcell;
    short icell;
#ifdef MATRIX
    char  eindex[MAXCELL];
    short necell;
#endif /* MATRIX */
    short width[MAXCELL];
    short minimum_width[MAXCELL];
    short fixed_width[MAXCELL];
};

struct table_in {
    struct table  *ptr;
    short         col;
    short         row;
    short         cell;
    short         indent;
    TextList      *buf;
};

struct table_linfo {
  Lineprop        prev_ctype;
  signed char     prev_spaces;
  char            prevchar;
  short           length;
};
  
struct table {
  int             row;
  int             col;
  int             maxrow;
  int             maxcol;
  int             max_rowsize;
  int             height;
  int             border_mode;
  int             total_width;
  int             tabcontentssize;
  int             indent;
  int             cellspacing;
  int             cellpadding;
  int             status;
  int             flag;
#ifdef TABLE_EXPAND
  int             ppc;
#endif /* TABLE_EXPAND */
  Str             suspended_input;
  Str             caption;
  TextList        ***tabdata;
  table_attr      **tabattr;
  table_attr      trattr;
#ifdef ID_EXT
  Str		  **tabidvalue;
  Str		  *tridvalue;
#endif
  short           tabwidth[MAXCOL];
  short           minimum_width[MAXCOL];
  short           fixed_width[MAXCOL];
  struct table_cell cell;
  short           *tabheight;
  struct table_in *tables;
  short           ntable;
  short           tables_size;
/* use for counting skipped spaces */
  struct table_linfo linfo;
#ifdef MATRIX
  MAT             *matrix;
  VEC             *vector;
#endif /* MATRIX */
};

#define TBLM_PRE 1
#define TBLM_NOBR 2
#define TBLM_PRE_INT 32
#define TBLM_INTXTA 64
#define TBLM_INSELECT 128
#define TBLM_PREMODE (TBLM_PRE|TBLM_INTXTA|TBLM_INSELECT)

#define  uchar           unsigned char
struct table_mode {
  uchar pre_mode;
  char indent_level;
  char caption;
  short nobr_offset;
  char nobr_level;
  char mode_level;
};
