/* $Id: fm.h,v 1.19 2000/04/06 01:25:00 aito Exp $ */
/*
 * w3m: WWW wo Miru utility
 * 
 * by A.ITO  Feb. 1995
 * 
 * You can use,copy,modify and distribute this program without any permission.
 */

#ifndef FM_H
#define FM_H

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include "config.h"

#ifdef MENU
#define MENU_SELECT
#endif /* MENU */

#include "ctrlcode.h"
#include "html.h"
#include "gc.h"
#include "Str.h"
#include "form.h"
#include "frame.h"
#include "parsetag.h"
#include "func.h"
#include "menu.h"
#include "textlist.h"
#include "funcname1.h"

#ifdef NOBCOPY
void bcopy(void*,void*,int);
void bzero(void*,int);
#else /* not NOBCOPY */
#include <string.h>
#endif /* not NOBCOPY */

#ifdef MAINPROGRAM
#define global
#define init(x) =(x)
#else /* not MAINPROGRAM */
#define global extern
#define init(x)
#endif /* not MAINPROGRAM */

#if LANG == JA
#define JP_CHARSET
#endif /* LANG == JA */

/*
 * Constants.
 */
#define LINELEN	4096		/* Maximum line length */
#define PAGER_MAX_LINE	10000	/* Maximum line kept as pager */
#define FNLEN 80

#define PIXEL_PER_CHAR  8       /* arbitrary */

#define NIL 0
#define T   1

#define INTERNAL_CODE    'E'  /* use EUC-JP internally; do not change */

#define SHELLBUFFERNAME	"*Shellout*"
#define PIPEBUFFERNAME	"*stream*"
#define CPIPEBUFFERNAME	"*stream(closed)*"
#ifdef DICT
#define DICTCMD "w3mdict"
#define DICTBUFFERNAME "*dictionary*"
#endif /* DICT */

/*
 * Line Property
 */
#ifdef JP_CHARSET
/* Character type */
#define P_CHARTYPE	0xe000
#define PC_ASCII	0x0000
#define PC_KANJI1	0x2000
#define PC_KANJI2	0x4000
#define PC_CTRL		0x8000

#else /* ISO-8859-1 charset (not JP_CHARSET) */

#define P_CHARTYPE	0x2000
#define PC_ASCII	0x0000
#define PC_CTRL		0x2000
#endif /* not JP_CHARSET */

#ifndef KANJI_SYMBOLS
#define PC_RULE         0x0f00
#define PC_ISRULE       0x1000
#define PC_RULE_FLAG(x) (((x)&0xf)<<8)
#define PC_RULE_VAL(x)  (((x)&PC_RULE)>>8)
#endif /* not KANJI_SYMBOLS */

/* Effect ( standout/underline ) */
#define P_EFFECT	0xfe
#define PE_NORMAL	0x00
#define PE_UNDER	0x02
#define PE_STAND	0x04
#define PE_BOLD		0x08
#define PE_ANCHOR       0x10
#define PE_EMPH         0x08
#define PE_IMAGE        0x20
#define PE_FORM         0x40
#define PE_ACTIVE	0x80

/* Mark */
#define PM_MARK		0x01

#define CharType(c)	((c)&P_CHARTYPE)
#ifdef KANJI_SYMBOLS
#define CharEffect(c)	((c)&P_EFFECT)
#else /* not KANJI_SYMBOLS */
#define CharEffect(c)	((c)&(P_EFFECT|PC_ISRULE|PC_RULE))
#endif /* not KANJI_SYMBOLS */
#define SetCharType(v,c)	((v)=(((v)&~P_CHARTYPE)|(c)))


#define COLPOS(l,c)	calcPosition(l->lineBuf,c,0,CP_AUTO)

/* Flags for displayBuffer() */
#define B_NORMAL	0
#define B_FORCE_REDRAW	1
#define B_REDRAW	2
#define B_SCROLL        3

/* Buffer Property */
#define BP_NORMAL	0x0
#define BP_PIPE		0x1
#define BP_FRAME	0x2
#define BP_SOURCE	0x4
#define BP_INTERNAL	0x8
#define BP_NO_URL	0x10

/* Link Buffer */
#define LB_NOLINK	-1
#define LB_FRAME	0	/* rFrame() */
#define LB_N_FRAME	1
#define LB_INFO		2	/* pginfo() */
#define LB_N_INFO	3
#define LB_SOURCE	4	/* vwSrc() */
#define LB_N_SOURCE	LB_SOURCE
#define MAX_LB		5

#ifdef MAINPROGRAM
int REV_LB[MAX_LB] = {
  LB_N_FRAME, LB_FRAME, LB_N_INFO, LB_INFO, LB_N_SOURCE, 
};
#else /* not MAINPROGRAM */
extern int REV_LB[];
#endif /* not MAINPROGRAM */

/* Flags for calcPosition() */
#define CP_AUTO		0
#define CP_FORCE	1

/* Completion status. */
#define CPL_OK		0
#define CPL_AMBIG	1
#define CPL_FAIL	2
#define CPL_MENU	3

#define CPL_NEVER	0x0
#define CPL_OFF		0x1
#define CPL_ON		0x2
#define CPL_ALWAYS	0x4

/* Flags for inputLine() */
#define IN_STRING	0x10
#define IN_FILENAME	0x20
#define IN_PASSWORD	0x40
#define IN_COMMAND	0x80

/*
 * Macros.
 */

#define inputLine(p,d,f)	inputLineHist(p,d,f,NULL)
#define inputStr(p,d)		inputLine(p,d,IN_STRING)
#define inputStrHist(p,d,h)	inputLineHist(p,d,IN_STRING,h)
#define inputFilename(p,d)	inputLine(p,d,IN_FILENAME)
#define inputFilenameHist(p,d,h)	inputLineHist(p,d,IN_FILENAME,h)

#define free(x)  GC_free(x)  /* let GC do it. */

#ifdef __EMX__
#define STRCASECMP
#define strcasecmp	stricmp
#define strncasecmp	strnicmp
#endif /* __EMX__ */
/*
 * Types.
 */

typedef unsigned short Lineprop;

typedef struct _MapList {
  Str name;
  TextList *urls;
  struct _MapList *next;
} MapList;

typedef struct _Line {
  char           *lineBuf;
  Lineprop       *propBuf;
  struct _Line   *next;
  struct _Line   *prev;
  short           len;
  long            linenumber;
  unsigned short  usrflags;
}               Line;

typedef struct {
  short           line;
  short           pos;
}               BufferPoint;

typedef struct _anchor {
  char           *url;
  char           *target;
  char           *referer;
  BufferPoint     start;
  BufferPoint     end;
  int             hseq;
}               Anchor;

#define NO_REFERER ((char*)-1)

typedef struct {
  Anchor        *anchors;
  int           nanchor;
  int           anchormax;
  int           acache;
}               AnchorList;

typedef struct {
  BufferPoint   *marks;
  int           nmark;
  int           markmax;
  int           prevhseq;
}               HmarkerList;

typedef struct _Buffer {
  char           *filename;
  char           *buffername;
  Line           *firstLine;
  Line           *topLine;
  Line           *currentLine;
  Line           *lastLine;
  struct _Buffer *nextBuffer;
  struct _Buffer *linkBuffer[MAX_LB];
  short           width;
  short           height;
  char           *type;
  int             allLine;
  short           bufferprop;
  short           currentColumn;
  short           cursorX;
  short           cursorY;
  short           pos;
  short           visualpos;
  FILE           *pagerSource;
  AnchorList     *href;
  AnchorList     *name;
  AnchorList     *img;
  AnchorList     *formitem;
  FormList       *formlist;
  MapList        *maplist;
  HmarkerList    *hmarklist;
  ParsedURL       currentURL;
  ParsedURL      *baseURL;
  char           *baseTarget;
  int             real_scheme;
  char           *sourcefile;
  struct frameset *frameset;
  struct frameset_queue *frameQ;
  int            *clone;
  int             trbyte;
#ifdef JP_CHARSET
  char            document_code;
#endif /* JP_CHARSET */
  TextList       *document_header;
  FormItemList   *form_submit;
}               Buffer;

#define NO_BUFFER ((Buffer*)1)

#define RB_STACK_SIZE 10

#define TAG_STACK_SIZE 10

#define FONT_STACK_SIZE 5

#define FONTSTAT_SIZE 4

#define INIT_BUFFER_WIDTH (COLS-1)

typedef struct {
    int  pos;
    int  len;
    int  tlen;
    long flag;
    Str  anchor;
    Str  anchor_target;
    short anchor_hseq;
    Str  img_alt;
    char fontstat[FONTSTAT_SIZE];
    short nobr_level;
    Lineprop prev_ctype;
    char init_flag;
} Breakpoint;

struct readbuffer {
  Str             line;
  Lineprop        cprop;
  short           pos;
  char            prevchar;
  long            flag;
  long            flag_stack[RB_STACK_SIZE];
  int             flag_sp;
  int             status;
  Str             ignore_tag;
  short           table_level;
  short           nobr_level;
  Str             anchor;
  Str             anchor_target;
  short           anchor_hseq;
  Str             img_alt;
  char            fontstat[FONTSTAT_SIZE];
  char            fontstat_stack[FONT_STACK_SIZE][FONTSTAT_SIZE];
  int             fontstat_sp;
  Lineprop        prev_ctype;
  Breakpoint      bp;
  struct cmdtable *tag_stack[TAG_STACK_SIZE];
  int             tag_sp;
};

#define in_bold fontstat[0]
#define in_under fontstat[1]
#define in_stand fontstat[2]

#define RB_PRE     0x01
#define RB_XMPMODE 0x02
#define RB_LSTMODE 0x04
#define RB_PLAIN   0x08
#define RB_LEFT    0x00
#define RB_CENTER  0x10
#define RB_RIGHT   0x20
#ifdef FORMAT_NICE
#define RB_FILL    0x200000
#endif /* FORMAT_NICE */
#define RB_NOBR    0x40
#define RB_P       0x80
#define RB_PRE_INT 0x100

#define RB_SPECIAL (RB_PRE|RB_XMPMODE|RB_LSTMODE|RB_PLAIN|RB_NOBR|RB_PRE_INT)
#define RB_PREMODE (RB_PRE | RB_PRE_INT)
#define RB_ALIGN   (RB_CENTER | RB_RIGHT)

#define RB_INTXTA  0x400
#define RB_IGNORE  0x1000
#define RB_INSEL   0x2000
#define RB_IGNORE_P 0x4000
#ifdef MENU
#define RB_INSELECT 0x800
#endif /* MENU */
#define RB_IN_DT     0x200

#define RB_N_TABLE 0x100000

#define RB_GET_ALIGN(obuf) ((obuf)->flag&RB_ALIGN)
#define RB_SET_ALIGN(obuf,align) {(obuf)->flag &= ~RB_ALIGN; (obuf)->flag |= (align); }
#define RB_SAVE_FLAG(obuf) {\
  if ((obuf)->flag_sp < RB_STACK_SIZE) \
    (obuf)->flag_stack[(obuf)->flag_sp++] = RB_GET_ALIGN(obuf); \
}
#define RB_RESTORE_FLAG(obuf) {\
  if ((obuf)->flag_sp > 0) \
   RB_SET_ALIGN(obuf,(obuf)->flag_stack[--(obuf)->flag_sp]); \
}

/* status flags */
#define R_ST_NORMAL 0		/* normal */
#define R_ST_TAG0   1		/* within tag, just after < */
#define R_ST_TAG    2		/* within tag */
#define R_ST_QUOTE  3		/* within single quote */
#define R_ST_DQUOTE 4           /* within double quote */
#define R_ST_EQL    5           /* = */
#define R_ST_AMP    6		/* within ampersand quote */
#define R_ST_CMNT1  7		/* <!  */
#define R_ST_CMNT2  8		/* <!- */
#define R_ST_CMNT   9		/* within comment */
#define R_ST_NCMNT1 10		/* comment - */
#define R_ST_NCMNT2 11		/* comment -- */
#define R_ST_NCMNT3 12		/* comment -- space */
#define R_ST_IRRTAG 13		/* within irregular tag */

#define ST_IS_REAL_TAG(s)   ((s)==R_ST_TAG||(s)==R_ST_TAG0||(s)==R_ST_EQL)
#define ST_IS_COMMENT(s)    ((s)>=R_ST_CMNT1)
#define ST_IS_TAG(s)        ((s)!=R_ST_NORMAL&&(s)!=R_ST_AMP&&!ST_IS_COMMENT(s))

/* is this '<' really means the beginning of a tag? */
#define REALLY_THE_BEGINNING_OF_A_TAG(p) \
	  (IS_ALPHA(p[1]) || p[1] == '/' || p[1] == '!' || p[1] == '?' || p[1] == '\0' || p[1] == '_')

/* flags for loadGeneralFile */
#define RG_NOCACHE   1

struct html_feed_environ {
  struct readbuffer *obuf;
  TextList *buf;
  FILE *f;
  Str tagbuf;
  int limit;
  struct environment *envs;
  int nenv;
  int envc;
  int envc_real;
  char *title;
};

struct auth_cookie {
  Str host;
  Str realm;
  Str cookie;
  struct auth_cookie *next;
};

#ifdef USE_COOKIE
struct portlist {
  unsigned short   port;
  struct portlist *next;
};

struct cookie {
  ParsedURL        url;
  Str              name;
  Str              value;
  time_t           expires;
  Str              path;
  Str              domain;
  Str              comment;
  Str              commentURL;
  struct portlist *portl;
  char             version;
  char             flag;
  struct cookie   *next;
};
#define COO_USE		1
#define COO_SECURE	2
#define COO_DOMAIN	4
#define COO_PATH	8
#define COO_DISCARD	16
#endif /* USE_COOKIE */

typedef struct _Hist {
  int offset;
  int position;
  int length;
  int size;
  char **line;
} Hist;

/* modes for align() */

#define ALIGN_CENTER 0
#define ALIGN_LEFT   1
#define ALIGN_RIGHT  2

typedef struct http_request {
  char      command;
  char      flag;
  char     *referer;
  FormList *request;
} HRequest;

#define HR_COMMAND_GET		0
#define HR_COMMAND_POST		1
#define HR_COMMAND_CONNECT	2
#define HR_COMMAND_HEAD		3

#define HR_FLAG_LOCAL		1

#define HTST_UNKNOWN		255
#define HTST_MISSING		254
#define HTST_NORMAL		0
#define HTST_CONNECT		1

/*
 * Globals.
 */

extern int      LINES, COLS;
#if defined(CYGWIN) && LANG == JA
#define LASTLINE (LINES-2)
#else /* not defined(CYGWIN) && LANG == JA */
#define LASTLINE (LINES-1)
#endif /* not defined(CYGWIN) && LANG == JA */ 

global int Tabstop init(8);
global int ShowEffect init(T);
global int PagerMax init(PAGER_MAX_LINE);
#ifdef JP_CHARSET
global char InnerCode init(INTERNAL_CODE);
#endif /* JP_CHARSET */

global char SearchHeader init(NIL);
global char    *DefaultType init(NULL);
global char RenderFrame init(NIL);
global char TargetSelf init(NIL);

global char fmInitialized init(NIL);

extern char GlobalKeymap[];
extern char EscKeymap[];
extern char EscBKeymap[];
extern char EscDKeymap[];
extern FuncList w3mFuncList[];

global char    *HTTP_proxy init(NULL);
global char    *GOPHER_proxy init(NULL);
global char    *FTP_proxy init(NULL);
global ParsedURL HTTP_proxy_parsed;
global ParsedURL GOPHER_proxy_parsed;
global ParsedURL FTP_proxy_parsed;
global char    *NO_proxy init(NULL);
global int	NOproxy_netaddr init(T);
#ifdef INET6
global int	DNS_order init(0);
extern int	ai_family_order_table[3][3];	/* XXX */
#endif /* INET6 */
global TextList *NO_proxy_domains;
global int      Do_not_use_proxy init(NIL);
global int      Do_not_use_ti_te init(NIL);

global char    *document_root init(NULL);
global char    *personal_document_root init(NULL);
global char    *cgi_bin init(NULL);

global Buffer  *Currentbuf;
global Buffer  *Firstbuf;
extern char    *ullevel[];

extern char    *version;

global int w3m_debug;
global int w3m_halfdump init(NIL);
global int w3m_halfload init(NIL);

#ifdef COLOR
global int useColor init(T);
global int basic_color init(8);      /* don't change */
global int anchor_color init(4);     /* blue  */
global int image_color init(2);      /* green */
global int form_color init(1);       /* red   */
#ifdef BG_COLOR
global int bg_color init(8);         /* don't change */
#endif /* BG_COLOR */
global int useActiveColor init(NIL);
global int active_color init(6);     /* cyan */
#endif /* COLOR */
global int confirm_on_quit init(T);
global int displayLink init(NIL);
global int showLineNum init(NIL);
global char *Editor init(DEF_EDITOR);
global char *Mailer init(DEF_MAILER);
global char *ExtBrowser init(DEF_EXT_BROWSER);
global char *ExtBrowser2 init(NULL);
global char *ExtBrowser3 init(NULL);
global int BackgroundExtViewer init(T);
global char *ftppasswd init(NULL); 
global int do_download init(NIL);
global char *UserAgent init(NULL);
global int NoSendReferer init(NIL);
global char *AcceptLang init(NULL);
global int WrapDefault init(NIL);
global int WrapSearch init(NIL);
global int squeezeBlankLine init(NIL);
global char *BookmarkFile init(NULL);
global int UseExternalDirBuffer init(T);
#ifdef __EMX__
global char *DirBufferCommand init("file:///$LIB/dirlist.cmd");
#else
global char *DirBufferCommand init("file:///$LIB/dirlist.cgi");
#endif /* __EMX__ */
global char *config_file init(NULL);
global int ignore_null_img_alt init(T);

global struct auth_cookie *Auth_cookie init(NULL);
#ifdef USE_COOKIE
global struct cookie *First_cookie init(NULL);
#endif /* USE_COOKIE */

global struct mailcap *UserMailcap;
global struct mailcap *SysMailcap;
global struct table2 *UserMimeTypes;
global struct table2 *SysMimeTypes;

global TextList *fileToDelete;

#ifdef USE_HISTORY
global int URLHistSize init(100);
global int URLSaveHist init(T);
#endif /* USE_HISTORY */
global int multicolList init(NIL);

#ifdef JP_CHARSET
extern char DisplayCode;
#endif /* JP_CHARSET */
#ifndef KANJI_SYMBOLS
global int no_graphic_char init(NIL);
#endif /* not KANJI_SYMBOLS */
extern char *rc_dir;

#ifdef MOUSE
global int use_mouse init(T);
extern int mouseActive;
global int reverse_mouse init(NIL);
#endif /* MOUSE */

#ifdef USE_COOKIE
global int default_use_cookie init(T);
global int use_cookie init(T);
global int accept_cookie init(NIL);
#endif /* USE_COOKIE */

#ifdef VIEW_UNSEENOBJECTS
global int view_unseenobject init(T);
#endif /* VIEW_UNSEENOBJECTS */

/*
 * Externals
 */

#include "table.h"
#include "proto.h"

#endif /* not FM_H */
