#include "fm.h"

char *regexCompile(char *, int);
int regexMatch(char*,int);
void matchedPosition(char**,char**);

int
forwardSearch(Buffer * buf, char *str)
{
  char           *p, *first, *last;
  Line           *l, *begin;
  int            wrapped = NIL;

  if ((p = regexCompile(str,1)) != NULL) {
    message(p, 0, 0);
    return NIL;
  }
  l = begin = buf->currentLine;
  if (regexMatch(&l->lineBuf[buf->pos + 1], 0) == 1) {
    matchedPosition(&first, &last);
    buf->pos = first - l->lineBuf;
    arrangeCursor(buf);
    return NIL;
  }
  for (l = l->next;; l = l->next) {
    if (l == NULL) {
      if (buf->pagerSource) {
	l = getNextPage(buf, 1);
	if (l == NULL) {
	  if (WrapSearch) {
	    l = buf->firstLine;
	    wrapped = T;
	  } else {
	    break;
	  }
	}
      } else if (WrapSearch) {
	l = buf->firstLine;
	wrapped = T;
      } else {
	break;
      }
    }
    if (regexMatch(l->lineBuf, 1) == 1) {
      matchedPosition(&first, &last);
      if (wrapped && l == begin && buf->pos == first - l->lineBuf)
	/* exactly same match */
	break;
      buf->pos = first - l->lineBuf;
      buf->currentLine = l;
      arrangeCursor(buf);
      return wrapped;
    }
    if (wrapped && l == begin) /* no match */
      break;
  }
  disp_message("Not found", NIL);
  return NIL;
}

int
backwardSearch(Buffer * buf, char *str)
{
  char           *p, *q, *found, *first, *last;
  Line           *l, *begin;
  int            wrapped = NIL;

  if ((p = regexCompile(str,1)) != NULL) {
    message(p, 0, 0);
    return NIL;
  }
  l = begin = buf->currentLine;
  if (buf->pos > 0) {
    p = &l->lineBuf[buf->pos - 1];
    found = NULL;
    q = l->lineBuf;
    while (regexMatch(q, q == l->lineBuf) == 1) {
      matchedPosition(&first, &last);
      if (first < p)
	found = first;
      q++;
      if (q >= p)
	break;
    }
    if (found) {
      buf->pos = found - l->lineBuf;
      arrangeCursor(buf);
      return NIL;
    }
  }
  for (l = l->prev;; l = l->prev) {
    if (l == NULL) {
      if (WrapSearch) {
	l = buf->lastLine;
	wrapped = T;
      } else {
	break;
      }
    }
    found = NULL;
    q = l->lineBuf;
    while (regexMatch(q, q == l->lineBuf) == 1) {
      matchedPosition(&first, &last);
      if (wrapped && l == begin && buf->pos == first - l->lineBuf)
	/* exactly same match */
	break;
      found = first;
      q++;
    }
    if (found) {
      buf->pos = found - l->lineBuf;
      buf->currentLine = l;
      arrangeCursor(buf);
      return wrapped;
    }
    if (wrapped && l == begin) /* no match */
      break;
  }
  disp_message("Not found", NIL);
  return NIL;
}
