#ifndef PQ_H
#define PQ_H

typedef int (*PQ_rout)(void*,void*);

typedef struct {
  void **data;
  int n_data;
  int area_size;
  PQ_rout priority;
} PriorityQueue;

/*
 * Create a new priority queue.
 * each datum in the queue is expressed as a pointer to void.
 *   size : initial size of the queue.
 *   priority: interface function to obtain priority of a datum.
 *             its type is PQ_rout.
 *   freeproc: pointer to function to free datum. If freeproc is
 *             non-null, size of queue is fixed.
 */
PriorityQueue *PQ_new(int size,int(*priority)(void*,void*));

void PQ_free(PriorityQueue*);
void PQ_push(PriorityQueue*,void*);
void *PQ_pop(PriorityQueue*);

int string_alphabetical(void*,void*);
int string_reverse_alphabetical(void*,void*);

#endif
