#include "fm.h"
#include "myctype.h"
#include <stdio.h>
#include <errno.h>
#include "parsetag.h"
#include "local.h"

static struct mailcap DefaultMailcap[] = {
  {"image/*", "xv %s"},
  {"audio/basic", "showaudio %s"},
  {NULL, NULL}
};

void
initMailcap()
{
  UserMailcap = loadMailcap(USER_MAILCAP);
  SysMailcap = loadMailcap(SYS_MAILCAP);
}

int
mailcapMatch(char *cap, char *type)
{
  char           *p;
  for (p = cap; *p != '/'; p++) {
    if (*p != *type)
      return 0;
    type++;
  }
  if (*type != '/')
    return 0;
  p++;
  type++;
  if (*p == '*')
    return 1;
  while (*p) {
    if (*p != *type)
      return 0;
    p++;
    type++;
  }
  return 2;
}

char           *
searchMailcap(struct mailcap * table, char *type)
{
  int             level = 0;
  char           *viewer = 0;
  int             i;

  if (table == NULL) return NULL;
  while (table->type) {
    i = mailcapMatch(table->type, type);
    if (i > level) {
      level = i;
      viewer = table->viewer;
    }
    table++;
  }
  return viewer;
}

void
extractMailcapEntry(char *mcap_entry, char **type, char **cmd)
{
  int j,k;

  while (*mcap_entry && IS_SPACE(*mcap_entry))
    mcap_entry++;
  for (j = 0; mcap_entry[j] && mcap_entry[j] != ';' && !IS_SPACE(mcap_entry[j]);
       j++);
  *type = allocStr(mcap_entry,j);
  if (mcap_entry[j] == ';') j++;
  while (mcap_entry[j] && IS_SPACE(mcap_entry[j]))
    j++;
  for (k = j; mcap_entry[k] && mcap_entry[k] != ';'; k++) {
    if (mcap_entry[k] == '\\')
      k++;
  }
  *cmd = allocStr(&mcap_entry[j],k-j);
}

struct mailcap*
loadMailcap(char *filename)
{
  FILE *f;
  int i,n;
  Str tmp;
  struct mailcap *mcap;
  
  f = fopen(expandName(filename),"r");
  if (f == NULL) return NULL;
  i = 0;
  while (tmp = Strfgets(f),tmp->length > 0) {
    if (tmp->ptr[0] != '#')
      i++;
  }
  fseek(f,0,0);
  n = i;
  mcap = New_N(struct mailcap,n+1);
  i = 0;
  while (tmp = Strfgets(f),tmp->length > 0) {
    if (tmp->ptr[0] == '#')
      continue;
  redo:
    while (IS_SPACE(Strlastchar(tmp)))
      Strshrink(tmp,1);
    if (Strlastchar(tmp) == '\\') {
      /* continuation */
      Strshrink(tmp,1);
      Strcat(tmp,Strfgets(f));
      goto redo;
    }
    extractMailcapEntry(tmp->ptr,&mcap[i].type,&mcap[i].viewer);
    i++;
  }
  mcap[i].type = NULL;
  mcap[i].viewer = NULL;
  fclose(f);
  return mcap;
}  

char           *
searchExtViewer(char *type)
{
  char *p;
  p = searchMailcap(UserMailcap, type);
  if (p == NULL) {
    p = searchMailcap(SysMailcap, type);
    if (p == NULL) {
      p = searchMailcap(DefaultMailcap, type);
    }
  }
  return p;
}

