#include  <stdio.h>
#include <string.h>
#include "fm.h"

#ifdef JP_CHARSET
#include  "Str.h"

#ifdef DEBUG
#include <malloc.h>
#endif

#define	BF_SIZ		4096
#define	uchar		unsigned char
#define	true		1
#define	false		0
#define	CODES		7	/* Number of supported Kanji code */

#define	JSIcode  "\033$@"
#define	JSOcode  "\033(H"
#define	J2SIcode "\033$@"
#define	J2SOcode "\033(J"
#define	NSIcode  "\033$B"
#define	NSOcode  "\033(J"
#define	N2SIcode  "\033$B"
#define	N2SOcode  "\033(B"
#define	N3SIcode "\033$@"
#define	N3SOcode "\033(B"
#define	USIcode  "\033$"
#define	USOcode  "\033+"

char           *SIcode, *SOcode;
uchar          *cOption;

int            euc = false;

Str  conv(char *is, char fc, char tc);
void  n_impr(char s);
void putSFT(unsigned char **pptr, unsigned char *code);
unsigned char   getSLb(unsigned char *ptr, unsigned char *ub);
Str  cConvSE(unsigned char *is);
Str  cConvSJ(unsigned char *is);
Str  cConvJS(char *is);
Str  cConvEE(char *is);
Str  cConvES(char *is);
void put_js(unsigned char ub, unsigned char lb, Str op);
char            checkShiftCode(char *buf, char);

static char* han2zen_tab[] = {
  "!!","!#","!V","!W","!\"","!&","%r","%!",
  "%#","%%","%'","%)","%c","%e","%g","%C",
  "!<","%\"","%$","%&","%(","%*","%+","%-",
  "%/","%1","%3","%5","%7","%9","%;","%=",
  "%?","%A","%D","%F","%H","%J","%K","%L",
  "%M","%N","%O","%R","%U","%X","%[","%^",
  "%_","%`","%a","%b","%d","%f","%h","%i",
  "%j","%k","%l","%m","%o","%s","!+","!,",
};

static
unsigned char   sjis_tab[8][2] = {
{0xf0, 0xff}, {0xf0, 0xff}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0xf0, 0xff}, {0, 0},
};


static
unsigned char   euc_tab[8][2] = {
{0, 0}, {0, 0}, {0, 0xfc}, {0, 0xfc}, {0, 0xfc}, {0, 0xfc}, {0, 0xfc}, {0, 0xfc},
};

typedef struct _ConvRoutine {
  char            key;
  Str           (*routine) ();
  char           *ShiftIn, *ShiftOut;
}               ConvRoutine;

ConvRoutine     FromSJ[] = {
  {'J', cConvSJ, JSIcode, JSOcode},
  {'N', cConvSJ, NSIcode, NSOcode},
  {'n', cConvSJ, N2SIcode, N2SOcode},
  {'m', cConvSJ, N3SIcode, N3SOcode},
  {'U', cConvSJ, USIcode, USOcode},
  {'j', cConvSJ, J2SIcode, J2SOcode},
  {'E', cConvSE, "", ""}
};

ConvRoutine     ToSJ[] = {
  {'J', cConvJS, JSIcode, JSOcode},
  {'N', cConvJS, NSIcode, NSOcode},
  {'n', cConvJS, N2SIcode, N2SOcode},
  {'m', cConvJS, N3SIcode, N3SOcode},
  {'U', cConvJS, USIcode, USOcode},
  {'j', cConvJS, J2SIcode, J2SOcode},
  {'E', cConvES, "", ""}
};

char *
GetSICode(char key)
{
  int i;
  for (i = 0; i < CODES; i++)
    if (FromSJ[i].key == key)
      return FromSJ[i].ShiftIn;
  return "";
}

char *
GetSOCode(char key)
{
  int i;
  for (i = 0; i < CODES; i++)
    if (FromSJ[i].key == key)
      return FromSJ[i].ShiftOut;
  return "";
}

Str
conv(char *is, char fc, char tc)
{
  int i;
  Str os;

  if (fc == 'E' && tc == 'E')
    return cConvEE(is);
  if (fc == tc || fc == '\0' || tc == '\0')
    return Strnew_charp(is);
  if (fc != 'I' && fc != 'S') {
    for (i = 0; i < CODES; i++) {
      if (ToSJ[i].key == fc) {
	SIcode = ToSJ[i].ShiftIn;
	SOcode = ToSJ[i].ShiftOut;
	os = (*ToSJ[i].routine) (is);
	goto next;
      }
    }
    n_impr(fc);
    return NULL;
  } else
    os = Strnew_charp(is);
next:
  if (tc != 'I' && tc != 'S') {
    for (i = 0; i < CODES; i++) {
      if (FromSJ[i].key == tc) {
	SIcode = FromSJ[i].ShiftIn;
	SOcode = FromSJ[i].ShiftOut;
	return (*FromSJ[i].routine) (os->ptr);
      }
    }
    n_impr(tc);
    return NULL;
  } else
    return os;
}

void
n_impr(char s)
{
  fprintf(stderr, "conv: option %c(0x%02x) is not implemented yet... sorry\n", s, s);
  exit(1);
}

void
putSFT(unsigned char **pptr, unsigned char *code)
{				/* Put Shift in/out code */
  while (*code != '\0')
    *((*pptr)++) = *(code++);
}

uchar 
getSLb(unsigned char *ptr, unsigned char *ub)
{				/* Get Shift-JIS Lower byte */
  uchar           c = *ptr;

  *ub <<= 1;
  if (c < 0x9f) {
    if (c > 0x7e)
      c--;
    *ub -= 1;
    c -= 0x3f;
  } else {
    c -= 0x9e;
  }
  return c;
}

/* Convert Shift-JIS to JIS/real JIS/EUC */
static Str
_cConvSJ(unsigned char *is)
{
  Str os = Strnew_size(strlen(is)*3/2);
  uchar           c, km = 0, ub, lb, *p;

  for (p = is; *p != '\0'; p++) {
    c = *p;
    if (0x80 <= c && c <= 0x9f) {
      if (km == 0) {
	Strcat_charp(os,SIcode);
	km = 1;
      }
      p++;
      ub = c - 0x80;
      lb = getSLb(p, &ub);
      ub += 0x20;
      lb += 0x20;
      if (euc) {
	ub |= 0x80;
	lb |= 0x80;
      }
      Strcat_char(os,ub);
      Strcat_char(os,lb);
    } else if (0xe0 <= c && c <= 0xef) {
      if (km == 0) {
	Strcat_charp(os,SIcode);
	km = 1;
      }
      p++;
      ub = (c & 0x7f) - 0x40;
      lb = getSLb(p, &ub);
      ub += 0x20;
      lb += 0x20;
      if (euc) {
	ub |= 0x80;
	lb |= 0x80;
      }
      Strcat_char(os,ub);
      Strcat_char(os,lb);
    } else if (0xa0 <= c && c <= 0xdf) {
      if (km == 0) {
	Strcat_charp(os,SIcode);
	km = 1;
      }
      Strcat_char(os,(han2zen_tab[c-0xa0][0] | (euc?0x80:0)));
      Strcat_char(os,(han2zen_tab[c-0xa0][1] | (euc?0x80:0)));
    } else {
      if (km == 1) {
	Strcat_charp(os, SOcode);
	km = 0;
      }
      Strcat_char(os,c);
    }
  }
  if (km == 1)
    Strcat_charp(os,SOcode);
  return os;
}

Str
cConvSE(unsigned char *is)
{
  euc = true;
  return _cConvSJ(is);
}

Str
cConvSJ(unsigned char *is)
{
  euc = false;
  return _cConvSJ(is);
}

void
put_js(unsigned char ub, unsigned char lb, Str op)
{
  ub -= 0x20;
  lb -= 0x20;
  if ((ub & 1) == 0)
    lb += 94;
  ub = ((ub - 1) >> 1) + 0x81;
  lb += 0x3f;
  if (ub > 0x9f)
    ub += 0x40;
  if (lb > 0x7e)
    lb++;

  Strcat_char(op,ub);
  Strcat_char(op,lb);
}

Str
cConvJS(char *is)
{				/* Convert JIS to Shift-JIS */
  char           *ip = is;
  char            kmode = 0;
  int             il = strlen(SIcode), ol = strlen(SOcode);
  static char    *si1 = "\033(I";
  int             hl = strlen(si1);
  Str             op = Strnew();

  while (*ip != '\0') {
    if (!(*ip & 0x80) && *ip < ' ' && *ip != '\033')
      kmode = 0;
    if (kmode == 1) { /* 2-byte char */
      if ((strncmp(ip, JSOcode, ol) == 0)||
          (strncmp(ip, NSOcode, ol) == 0)||
          (strncmp(ip, N2SOcode, ol) == 0)||
          (strncmp(ip, N3SOcode, ol) == 0)) {
	ip += ol;
	kmode = 0;
      } else if (strncmp(ip, si1, hl) == 0) {
	ip += hl;
	kmode = 2;
      } else {
	put_js(*ip, *(ip + 1), op);
	ip += 2;
      }
    } else if (kmode == 2) { /* 1-byte kana */
      if ((strncmp(ip, JSOcode, ol) == 0)||
          (strncmp(ip, NSOcode, ol) == 0)||
          (strncmp(ip, N2SOcode, ol) == 0)||
          (strncmp(ip, N3SOcode, ol) == 0)) {
	ip += ol;
	kmode = 0;
      }
      else if ((strncmp(ip, JSIcode, il) == 0)||
               (strncmp(ip, NSIcode, il) == 0)||
               (strncmp(ip, N2SIcode, il) == 0)||
               (strncmp(ip, N3SIcode, il) == 0)) {
	ip += il;
	kmode = 1;
      } 
      else {
	if (0x20 <= *ip && *ip <= 0x5f) {
          put_js(han2zen_tab[*ip-0x20][0],han2zen_tab[*ip-0x20][1],op);
	} else {
          Strcat_char(op,*ip);
	}
        ip += 1;
      }
    } else {
      if ((strncmp(ip, JSIcode, il) == 0)||
          (strncmp(ip, NSIcode, il) == 0)||
          (strncmp(ip, N2SIcode, il) == 0)||
          (strncmp(ip, N3SIcode, il) == 0)) {
	ip += il;
	kmode = 1;
      }
      else if (strncmp(ip, si1, hl) == 0) {
	ip += hl;
	kmode = 2;
      } else
	Strcat_char(op,*(ip++));
    }
  }
  return op;
}

Str
cConvEE(char *is)
{                             /* Convert EUC to EUC (no 1byte kana) */
  char           *ip = is;
  uchar           ub;
  Str             op = Strnew_size(strlen(is));

  while (*ip != '\0') {
    ub = (uchar) * (ip++);
    if (ub == 0x8e && (uchar)*ip >= 0xa0 && (uchar)*ip <= 0xdf) {
      ub = (uchar) * (ip++);
      Strcat_char(op, han2zen_tab[ub-0xa0][0] | 0x80);
      Strcat_char(op, han2zen_tab[ub-0xa0][1] | 0x80);
    } else {
      Strcat_char(op, (char) ub);
    }
  }
  return op;
}

Str
cConvES(char *is)
{				/* Convert EUC to Shift-JIS */
  char           *ip = is;
  uchar           ub, lb;
  Str             op = Strnew_size(strlen(is));

  while (*ip != '\0') {
    ub = (uchar) * (ip++);
    if (ub == 0x8e && (uchar)*ip >= 0xa0 && (uchar)*ip <= 0xdf) {
      ub = (uchar) * (ip++);
      put_js(han2zen_tab[ub-0xa0][0],han2zen_tab[ub-0xa0][1],op);
    } else if (ub >= 0x80) {
      ub &= 0x7f;
      lb = (uchar) * (ip++) & 0x7f;
      put_js(ub, lb, op);
    } else {
      Strcat_char(op, (char) ub);
    }
  }
  return op;
}


char 
checkShiftCode(char *buf, char hint)
{
  char            *p, si = '\0', so = '\0';
  char            maybe_euc, maybe_sjis, maybe_sjis_or_euc = 0;

  maybe_euc = maybe_sjis = 1;

  for (p = buf; *p != '\0'; p++) {
    if (*p == '\033') {
      switch (*(++p)) {
      case '$':		/* Shift-in */
	si = *(++p);
	break;
      case '(':		/* Shift-out ) */
	so = *(++p);
	break;
      }
    } else if ((char)0xa1 <= *p && *p <= (char)0xf4) {
      int             c1, c2, bit;

      c1 = ((*p >> 4) & 7);
      c2 = *(++p);
      bit = 1 << ((c2 >> 4) & 7);
      c2 = (c2 & 0x80) ? 1 : 0;
      if ((euc_tab[c1][c2] & bit) == 0)
	maybe_euc = 0;
      if ((sjis_tab[c1][c2] & bit) == 0)
	maybe_sjis = 0;
      maybe_sjis_or_euc = 1;
    } else if ((char)0x80 <= *p && *p <= (char)0x9f) {
      maybe_euc = 0;
      maybe_sjis_or_euc = 1;
      break;
    }
  }
  if (maybe_sjis_or_euc) {
    if (maybe_euc && !maybe_sjis)
      return 'E';
    if (maybe_sjis && !maybe_euc)
      return 'S';
    /* confused */
    return hint;
  }
  switch (si) {
  case '@':
    switch (so) {
    case 'H':
      return 'J';
    case 'J':
      return 'j';
    case 'B':
      return 'm';
    default: /* confused */
      return hint;
    }
  case 'B':
    switch (so) {
    case 'J':
      return 'N';
    case 'B':
      return 'n';
    default: /* confused */
      return hint;
    }
  default:
    /* no kanji is used in this line */
    return hint;
  }
}
#endif
