/* $Id: table.h,v 1.1.1.1 2000/01/04 05:46:50 aito Exp $ */
#if (defined(MESCHACH) && !defined(MATRIX))
#define MATRIX
#endif

#ifdef MATRIX
#ifdef MESCHACH
#include <matrix2.h>
#else
#include "matrix.h"
#endif
#endif

#include "Str.h"

#define MAX_TABLE 20  /* maximum nest level of table */
#define MAX_TABLE_N 20  /* maximum number of table in same level */

#define MAXROW 50
#define MAXCOL 50

#define MAX_WIDTH 80

#define BORDER_NONE 0
#define BORDER_THIN 1
#define BORDER_THICK 2
#define BORDER_NOWIN 3

typedef unsigned char table_attr;

/* flag */
#define TBL_IN_ROW     1
#define TBL_EXPAND_OK  2
#define TBL_IN_COL     4

#define MAXCELL 20
struct table_cell {
    short col[MAXCELL];
    short colspan[MAXCELL];
    char  index[MAXCELL];
    short maxcell;
    short icell;
#ifdef MATRIX
    char  eindex[MAXCELL];
    short necell;
#endif
    short width[MAXCELL];
    short minimum_width[MAXCELL];
    short fixed_width[MAXCELL];
};

struct table_in {
    struct table  *ptr;
    short         col;
    short         row;
    short         cell;
    short         indent;
    TextList      *buf;
};

struct table {
  int             row;
  int             col;
  int             maxrow;
  int             maxcol;
  int             max_rowsize;
  int             height;
  int             border_mode;
  int             total_width;
  int             tabcontentssize;
  int             indent;
  int             cellspacing;
  int             cellpadding;
  int             status;
  int             flag;
#ifdef TABLE_EXPAND
  int             ppc;
#endif
  Str             suspended_input;
  Str             caption;
  TextList        ***tabdata;
  table_attr      **tabattr;
  table_attr      trattr;
  short           tabwidth[MAXCOL];
  short           minimum_width[MAXCOL];
  short           fixed_width[MAXCOL];
  struct table_cell cell;
  short           *tabheight;
  struct table_in *tables;
  short           ntable;
  short           tables_size;
/* use for counting skipped spaces */
  Lineprop        prev_ctype;
  short           prev_spaces;
#ifdef MATRIX
  MAT             *matrix;
  VEC             *vector;
#endif
};

#define TBLM_PRE 1
#define TBLM_NOBR 2
#define TBLM_PRE_INT 32
#define TBLM_INTXTA 64
#define TBLM_INSELECT 128
#define TBLM_PREMODE (TBLM_PRE|TBLM_INTXTA|TBLM_INSELECT)

#define  uchar           unsigned char
struct table_mode {
  uchar pre_mode;
  char indent_level;
  char caption;
  short nobr_offset;
  char nobr_level;
  char mode_level;
};
