/* Marker extension by okabe */
/* $Id: main.c,v 1.10 2000/01/21 07:18:57 aito Exp $ */
#define MAINPROGRAM
#include "fm.h"
#include <signal.h>
#include <setjmp.h>
#include <sys/stat.h>
#include "terms.h"
#include "myctype.h"
#ifdef USE_GPM
#include <gpm.h>
extern int do_getch();
#define getch()	do_getch()
#endif /* USE_GPM */

extern void (*GlobalKeymap[])();
extern void (*EscKeymap[])();
extern void (*EscBKeymap[])();
extern void (*EscDKeymap[])();

#define DSTR_LEN	256

#define HIST_SIZE 100
Hist    *SearchHist;
Hist    *MarkHist;
Hist    *LoadHist;
Hist    *SaveHist;
Hist    *URLHist;
Hist    *ShellHist;

#define N_EVENT_QUEUE 10
typedef struct {
  void (*cmd)();
  void *user_data;
} Event;
static void *cmd_argument;
static Event eventQueue[N_EVENT_QUEUE];
static int n_event_queue;

int             (*searchRoutine) (Buffer*, char*);
static void     _goLine(char *);

JMP_BUF         IntReturn;

static void      cmd_loadfile(char *path);
static void      cmd_loadURL(char *url,ParsedURL *current);
static void      cmd_loadBuffer(Buffer *buf, int prop, int link);
static void      keyPressEventProc(int c);
#ifdef USE_MARK
static void cmd_mark(Lineprop * p);
#endif

static int display_ok = NIL;
int w3m_dump = 0;
int w3m_dump_source = 0;
int w3m_dump_head = 0;
static void dump_source(Buffer*);
static void dump_head(Buffer*);
int prec_num = 0;

#define PREC_NUM (prec_num ? prec_num : 1)
#define PREC_LIMIT 10000

#if defined(AIX) || defined(linux)
/* to cope with Boehm GC... */

#define MAIN real_main

#if defined(DEBIAN)
# include "gc/private/gc_priv.h"
#else
# include "gc_private.h"
#endif
int real_main(int,char**,char**);

int
main(int argc, char **argv, char **envp)
{
    int dummy;
    GC_stackbottom = (ptr_t)(&dummy);
    return(real_main(argc, argv, envp));
}
#else
#define MAIN main
#endif

static void
usage()
{
  fprintf(stderr, "version %s\n",version);
  fprintf(stderr, "usage: w3m [options] [URL or filename]\noptions:\n");
  fprintf(stderr, "    -t tab           set tab width\n");
  fprintf(stderr, "    -r               ignore backspace effect\n");
  fprintf(stderr, "    -l line          # of preserved line (default 10000)\n");
#ifdef JP_CHARSET
  fprintf(stderr, "    -s               Shift_JIS\n");
  fprintf(stderr, "    -j               JIS\n");
  fprintf(stderr, "    -e               EUC-JP\n");
#endif
  fprintf(stderr, "    -B               load bookmark\n");
  fprintf(stderr, "    -bookmark file   specify bookmark file\n");
  fprintf(stderr, "    -T type          specify content-type\n");
  fprintf(stderr, "    -m               internet message mode\n");
  fprintf(stderr, "    -v               visual startup mode\n");
#ifdef COLOR
  fprintf(stderr, "    -M               monochrome display\n");
#endif
  fprintf(stderr, "    -F               automatically render frame\n");
  fprintf(stderr, "    -dump            dump formatted page into stdout\n");
  fprintf(stderr, "    -cols width      specify column width (used with -dump)\n");
  fprintf(stderr, "    -dump_source     dump page source into stdout\n");
  fprintf(stderr, "    -dump_head       dump response of HEAD request into stdout\n");
  fprintf(stderr, "    +<num>           goto <num> line\n");
  fprintf(stderr, "    -num             show line number\n");
  fprintf(stderr, "    -no-proxy        don't use proxy\n");
#ifdef MOUSE
  fprintf(stderr, "    -no-mouse        don't use mouse\n");
#endif
#ifdef USE_COOKIE
  fprintf(stderr, "    -cookie          use cookie (-no-cookie: don't use cookie)\n");
#endif
#ifndef KANJI_SYMBOLS
  fprintf(stderr, "    -no-graph        don't use graphic character\n");
#endif
  fprintf(stderr, "    -S               squeeze multiple blank lines\n");
  fprintf(stderr, "    -W               toggle wrap search mode\n");
  fprintf(stderr, "    -X               don't use termcap init/deinit\n");
  fprintf(stderr, "    -config file     specify config file\n");
  fprintf(stderr, "    -debug           DO NOT USE\n");
  exit(1);
}


int
MAIN(int argc, char **argv, char **envp)
{
  Buffer         *newbuf = NULL;
  char           *p, c;
  int             i;
  FILE           *redin;
  char           *line_str = NULL;
  char           **load_argv;
  FormList       *request;
  int            load_argc = 0;
  int            load_bookmark = NIL;
  int            visual_start = NIL;

#ifndef SYS_ERRLIST
  prepare_sys_errlist();
#endif

  NO_proxy_domains = newTextList();
  fileToDelete = newTextList();

  load_argv = New_N(char*,argc-1);
  load_argc = 0;

  BookmarkFile = NULL;
  rc_dir = expandName(RC_DIR);
  config_file = rcFile("config");

  /* argument search 1 */
  for (i = 1; i < argc; i++) {
    if (*argv[i] == '-') {
      if (!strcmp("-config", argv[i])) {
	argv[i] = "-dummy";
        config_file = argv[++i];
	argv[i] = "-dummy";
      }
    }
  }

  /* initializations */
  init_rc(config_file);
  initKeymap();
#ifdef MENU
  initMenu();
#endif
#ifdef USE_COOKIE
  initCookie();
#endif

  SearchHist = initHist(HIST_SIZE + 1);
  MarkHist   = initHist(HIST_SIZE + 1);
  LoadHist   = initHist(HIST_SIZE + 1);
  SaveHist   = initHist(HIST_SIZE + 1);
  ShellHist  = initHist(HIST_SIZE + 1);
#ifdef USE_HISTORY
  URLHist    = initHist(URLHistSize + 1);
  loadHistory(URLHist);
#else
  URLHist    = initHist(HIST_SIZE + 1);
#endif

  if (HTTP_proxy == NULL &&
      ((p = getenv("HTTP_PROXY")) ||
       (p = getenv("http_proxy")) ||
       (p = getenv("HTTP_proxy")))) {
    HTTP_proxy = p;
    parseURL(p, &HTTP_proxy_parsed, NULL);
  }
  if (GOPHER_proxy == NULL &&
      ((p = getenv("GOPHER_PROXY")) ||
       (p = getenv("gopher_proxy")) ||
       (p = getenv("GOPHER_proxy")))) {
    GOPHER_proxy = p;
    parseURL(p, &GOPHER_proxy_parsed, NULL);
  }
  if (FTP_proxy == NULL &&
      ((p = getenv("FTP_PROXY")) ||
       (p = getenv("ftp_proxy")) ||
       (p = getenv("FTP_proxy")))) {
    FTP_proxy = p;
    parseURL(p, &FTP_proxy_parsed, NULL);
  }
  if (NO_proxy == NULL &&
      ((p = getenv("NO_PROXY")) ||
       (p = getenv("no_proxy")) ||
       (p = getenv("NO_proxy")))) {
    NO_proxy = p;
    set_no_proxy(p);
  }

  if (Editor == NULL && (p = getenv("EDITOR")) != NULL)
    Editor = p;
  if (Mailer == NULL && (p = getenv("MAILER")) != NULL)
    Mailer = p;

  /* argument search 2 */
  for (i = 1; i < argc; i++) {
    if (*argv[i] == '-') {
      if (!strcmp("-t", argv[i])) {
	Tabstop = atoi(argv[++i]);
      } else if (!strcmp("-r", argv[i]))
	ShowEffect = NIL;
      else if (!strcmp("-l", argv[i]))
	PagerMax = atoi(argv[++i]);
#ifdef JP_CHARSET
      else if (!strcmp("-s", argv[i]))
	DisplayCode = CODE_SJIS;
      else if (!strcmp("-j", argv[i]))
	DisplayCode = CODE_JIS1;
      else if (!strcmp("-e", argv[i]))
	DisplayCode = CODE_EUC;
#endif
#ifndef KANJI_SYMBOLS
      else if (!strcmp("-no-graph",argv[i]))
        no_graphic_char = T;
#endif
      else if (!strcmp("-T", argv[i]))
	DefaultType = argv[++i];
      else if (!strcmp("-m", argv[i]))
	SearchHeader = T;
      else if (!strcmp("-v", argv[i]))
	visual_start = T;
#ifdef COLOR
      else if (!strcmp("-M", argv[i]))
	useColor = NIL;
#endif     
      else if (!strcmp("-B", argv[i]))
	load_bookmark = T;
      else if (!strcmp("-bookmark",argv[i]))
	BookmarkFile = argv[++i];
      else if (!strcmp("-F", argv[i]))
	RenderFrame = T;
      else if (!strcmp("-W", argv[i])) {
	if (WrapSearch) {
	  WrapSearch = NIL;
	} else {
	  WrapSearch = T;
	}
      } else if (!strcmp("-dump", argv[i])) {
	w3m_dump = T;
	if (COLS == 0)
	  COLS = 80;
      }
      else if (!strcmp("-dump_source", argv[i])) {
	w3m_dump = T;
	w3m_dump_source = T;
	if (COLS == 0)
	  COLS = 80;
      }
      else if (!strcmp("-dump_head", argv[i])) {
	w3m_dump = T;
	w3m_dump_head = T;
	if (COLS == 0)
	  COLS = 80;
      }
      else if (!strcmp("-halfdump", argv[i])) {
	w3m_halfdump = T;
	if (COLS == 0)
	  COLS = 80;
      }
      else if (!strcmp("-halfload", argv[i])) {
	w3m_halfload = T;
      }
      else if (!strcmp("-cols", argv[i])) 
	COLS = atoi(argv[++i]);
      else if (!strcmp("-num", argv[i]))
	showLineNum = T;
      else if (!strcmp("-no-proxy", argv[i]))
	Do_not_use_proxy = T;
#ifdef MOUSE
      else if (!strcmp("-no-mouse", argv[i])) {
	mouse_end();
	use_mouse = NIL;
      }
#endif
#ifdef USE_COOKIE
      else if (!strcmp("-no-cookie", argv[i])) {
	use_cookie = NIL;
      }
      else if (!strcmp("-cookie", argv[i])) {
	use_cookie = T;
      }
#endif
      else if (!strcmp("-S", argv[i]))
	squeezeBlankLine = T;
      else if (!strcmp("-X", argv[i]))
        Do_not_use_ti_te = T;
      else if (!strcmp("-dummy", argv[i])) {
        /* do nothing */
      }
      else if (!strcmp("-debug", argv[i]))
	w3m_debug = T;
      else {
	usage();
      }
    }
    else if (*argv[i] == '+' ) {
      line_str = argv[i]+1;
    } else {
      load_argv[load_argc++] = argv[i];
    }
  }

  Firstbuf = NULL;
  Currentbuf = NULL;
  if (BookmarkFile == NULL)
    BookmarkFile = rcFile(BOOKMARK);
  if (load_bookmark || load_argc > 0) {
    /* if any arguments are given... */
    if (!w3m_dump && !w3m_halfdump)
      fmInit();
    if (w3m_halfdump)
      printf("<pre>\n");
    if (load_bookmark) {
      newbuf = loadGeneralFile(BookmarkFile, NULL,NO_REFERER,0,NULL);
      if (newbuf == NULL) {
	fprintf(stderr, "w3m: Can't load bookmark\n");
      } else {
	Firstbuf = Currentbuf = newbuf;
      }
    }
    for (i = 0; i < load_argc; i++) {
      if (w3m_dump && w3m_dump_head) {
 	request = New(FormList);
 	request->method = FORM_METHOD_HEAD;
 	newbuf = loadGeneralFile(load_argv[i], NULL,NO_REFERER,0,request);
      } else {
 	newbuf = loadGeneralFile(load_argv[i], NULL,NO_REFERER,0,NULL);
      }
      if (newbuf == NULL) {
	fprintf(stderr, "w3m: Can't load %s\n", load_argv[i]);
	continue;
      } else if (newbuf == NO_BUFFER)
	continue;
      switch(newbuf->real_scheme) {
      case SCM_NNTP:
      case SCM_NEWS:
      case SCM_MAILTO:
	break;
      case SCM_LOCAL:
	insertHist(LoadHist, load_argv[i]);
	break;
      default:
	insertHist(URLHist, load_argv[i]);
	break;
      }
      if (w3m_halfdump) {
	Currentbuf = Firstbuf = newbuf;
        printf("</pre><title>%s</title>\n",newbuf->buffername);
	deleteFiles();
	exit(0);
      }
      if (w3m_dump) {
	Currentbuf = Firstbuf = newbuf;
	if (w3m_dump_source) {
	  dump_source(Currentbuf);
	}
	else if (w3m_dump_head) {
	  dump_head(Currentbuf);
	}
	else {
	  if (Currentbuf->frameset != NULL && RenderFrame) {
	    rFrame();
	  }
	  saveBuffer(Currentbuf,stdout);
	}
	deleteFiles();
#ifdef USE_COOKIE
        save_cookies();
#endif
        exit(0);
      }
      if (Currentbuf == NULL)
	Firstbuf = Currentbuf = newbuf;
      else {
	Currentbuf->nextBuffer = newbuf;
	Currentbuf = newbuf;
      }
      if (Currentbuf->frameset != NULL && RenderFrame) {
	rFrame();
	Currentbuf = newbuf;
      }
    }
  }
  else {
    /* When no arguments other than options are given... */
    if (!isatty(1) || w3m_dump) {		/* redirected output */
      if (isatty(0)) {
	fprintf(stderr, "w3m: Can't redirect\n");
	exit(1);
      }
      /* when -T option is given, behave as an HTML formatter */
      newbuf = openGeneralPagerBuffer(stdin);
      if (newbuf != NO_BUFFER) {
	saveBuffer(newbuf,stdout);
	discardBuffer(newbuf);
      }
      deleteFiles();
      exit(0);
    }
    if (!isatty(0)) {		/* redirected input */
      fmInit();
      redin = fdopen(dup(0), "r");
      newbuf = openGeneralPagerBuffer(redin);
      dup2(1, 0);
      Firstbuf = Currentbuf = newbuf;
    }
  }

  if ((Firstbuf == NULL) && (newbuf == NULL) &&
      (((p = getenv("HTTP_HOME")) != NULL) ||
       ((p = getenv("WWW_HOME")) != NULL))) {
      fmInit();
      newbuf = loadGeneralFile(p,NULL,NO_REFERER,0,NULL);
      if (newbuf == NULL)
	fprintf(stderr, "w3m: Can't load %s\n", p);
      else {
	Firstbuf = Currentbuf = newbuf;
        if (Currentbuf->frameset != NULL && RenderFrame)
	  rFrame();
      }
  }
  if ((Firstbuf == NULL) && (newbuf == NULL) && visual_start) {
    Str s_page;
    fmInit();
    s_page = Strnew_charp("<title>W3M startup page</title><center><b>Welcome to ");
#ifdef JP_CHARSET
    Strcat_charp(s_page,"<a href='http://ei5nazha.yz.yamagata-u.ac.jp/~aito/w3m/'>");
#else
    Strcat_charp(s_page,"<a href='http://ei5nazha.yz.yamagata-u.ac.jp/~aito/w3m/eng'>");
#endif
    Strcat_m_charp(s_page,
		   "w3m</a>!<p><p>This is w3m version ",
		   version,
		   "<br>Written by <a href='mailto:aito@ei5sun.yz.yamagata-u.ac.jp'>Akinori Ito</a>",
		   NULL);
#ifdef DEBIAN
    Strcat_m_charp(s_page,
		   "<p>Debian package is maintained by <a href='mailto:ukai@debian.or.jp'>Fumitoshi UKAI</a>.",
		   "You can read <a href='file:///usr/share/doc/w3m/'>w3m documents on your local system</a>.",
		   NULL);
#endif
    newbuf = loadHTMLString(s_page->ptr);
    if (newbuf == NULL)
      fprintf(stderr, "w3m: Can't load string\n");
    else {
      newbuf->bufferprop |= (BP_INTERNAL | BP_NO_URL);
      Firstbuf = Currentbuf = newbuf;	
    }
  }
  if (Firstbuf == NULL) {
    if (newbuf == NO_BUFFER) {
      if (fmInitialized)
	inputStr("Hit any key to quit w3m:","");
      quitfm();
    }
    deleteFiles();
    fmTerm();
    usage();
  }
#ifdef SIGWINCH
  signal(SIGWINCH, resize_hook);
#endif
  Currentbuf = Firstbuf;
  displayBuffer(Currentbuf, B_NORMAL);
  if (line_str){
    _goLine(line_str);
  }
  for (;;) {
    /* event processing */
    if (n_event_queue > 0) {
      for (i = 0; i < n_event_queue; i++) {
	cmd_argument = eventQueue[i].user_data;
	eventQueue[i].cmd();
      }
      n_event_queue = 0;
    }
    cmd_argument = NULL;
    /* get keypress event */
#ifdef MOUSE
    if (use_mouse) mouse_active();
#endif
    c = getch();
#ifdef MOUSE
    if (use_mouse) mouse_inactive();
#endif
    if ((c & 0x80) == 0) {	/* Ascii */
      if (('0' <= c) && (c <= '9')) {
	prec_num = prec_num * 10 + (int)(c - '0');
	if (prec_num > PREC_LIMIT)
	  prec_num = PREC_LIMIT;
      } else {
        keyPressEventProc((int)c);
	prec_num = 0;
      }
    }
  }
}

static void
keyPressEventProc(int c)
{
    (*GlobalKeymap[c]) ();
    onA();
}

void
pushEvent(void (*event)(),void *user_data)
{
  if (n_event_queue < N_EVENT_QUEUE) {
    eventQueue[n_event_queue].cmd = event;
    eventQueue[n_event_queue].user_data = user_data;
    n_event_queue++;
  }
}

static void
dump_source(Buffer *buf)
{
  FILE *f;
  char c;
  if (buf->sourcefile == NULL)
    return;
  f = fopen(buf->sourcefile,"r");
  if (f == NULL)
    return;
  while (c = fgetc(f), !feof(f)) {
    putchar(c);
  }
  fclose(f);
}

static void
dump_head(Buffer *buf)
{
  TextListItem *ti;

  if (buf->document_header == NULL)
    return;
  for (ti = buf->document_header->first; ti; ti = ti->next) {
    printf("%s", ti->ptr);
  }
  puts("");
}

void
nulcmd(void)
{				/* do nothing */
}


void
escmap(void)
{
  EscKeymap[(int)getch()] ();
}

void
escbmap(void)
{
  char c;
  c = getch();

  if (IS_DIGIT(c))
    escdmap(c);
  else
    EscBKeymap[(int)c] ();
}

void
escdmap(char c)
{
  int d;

  d = (int)c - (int)'0';
  c = getch();
  if (IS_DIGIT(c)) {
    d = d * 10 + (int)c - (int)'0';
    c = getch();
  }
  if (c == '~')
    EscDKeymap[d] ();
}

static void
pushBuffer(Buffer *buf)
{
  Buffer *b;
  if (Firstbuf == Currentbuf) {
    buf->nextBuffer = Firstbuf;
    Firstbuf = Currentbuf = buf;
  }
  else if ((b = prevBuffer(Firstbuf, Currentbuf)) != NULL) {
    b->nextBuffer = buf;
    buf->nextBuffer = Currentbuf;
    Currentbuf = buf;
  }
}

static void
delBuffer(Buffer *buf)
{
  if (buf == NULL)
    return;
  if (Currentbuf == buf)
    Currentbuf = buf->nextBuffer;
  Firstbuf = deleteBuffer(Firstbuf, buf);
  if (!Currentbuf)
    Currentbuf = Firstbuf;
}
  
static void
repBuffer(Buffer *oldbuf, Buffer *buf)
{
  Firstbuf = replaceBuffer(Firstbuf, oldbuf, buf);
  Currentbuf = buf;
}


MySignalHandler
intTrap(SIGNAL_ARG)
{				/* Interrupt catcher */
  LONGJMP(IntReturn, 0);
  SIGNAL_RETURN;
}

#ifdef SIGWINCH
MySignalHandler
resize_hook(SIGNAL_ARG)
{
  setlinescols();
  setupscreen();
  if (Currentbuf)
    displayBuffer(Currentbuf, B_FORCE_REDRAW);
  signal(SIGWINCH,resize_hook);
  SIGNAL_RETURN;
}
#endif

static void
curHome(void)
{
  Currentbuf->currentLine = Currentbuf->topLine;
  Currentbuf->pos = columnPos(Currentbuf->topLine, Currentbuf->currentColumn);
  cursorHome(Currentbuf);
  displayBuffer(Currentbuf, B_NORMAL);
}

/*
 * Command functions: These functions are called with a keystroke.
 */

/* Move page forward */
void
pgFore(void)
{
  if (Currentbuf->firstLine == NULL)
    return;
#ifdef VI_PREC_NUM
  Currentbuf->topLine = lineSkip(Currentbuf->topLine, PREC_NUM * (LASTLINE - 1));
#else
  Currentbuf->topLine = lineSkip(Currentbuf->topLine, prec_num ? prec_num : LASTLINE - 1);
#endif
  curHome();
}

/* Move page backward */
void
pgBack(void)
{
  if (Currentbuf->firstLine == NULL)
    return;
#ifdef VI_PREC_NUM
  Currentbuf->topLine = lineSkip(Currentbuf->topLine, PREC_NUM * (-LASTLINE + 1));
#else
  Currentbuf->topLine = lineSkip(Currentbuf->topLine, prec_num ? -prec_num : -LASTLINE + 1);
#endif
  curHome();
}

#define MAX(a, b)  ((a) > (b) ? (a) : (b))
#define MIN(a, b)  ((a) < (b) ? (a) : (b))

static void
nscroll(int n)
{
  int pos, col;
  Line *curtop = Currentbuf->topLine;
  int lnum, tlnum, llnum;

  if (Currentbuf->firstLine == NULL)
    return;
  lnum = Currentbuf->currentLine->linenumber;
  Currentbuf->topLine = lineSkip(curtop, n);
  if (Currentbuf->topLine == curtop)
    return;

  tlnum = Currentbuf->topLine->linenumber;
  llnum = Currentbuf->topLine->linenumber+LASTLINE-1;
  if (lnum < tlnum)
    lnum = tlnum;
  if (lnum > llnum)
    lnum = llnum;
  gotoLine(Currentbuf, lnum);
  pos = Currentbuf->visualpos;
  col = columnPos(Currentbuf->currentLine, Currentbuf->currentColumn + pos);
  Currentbuf->pos = MIN(col, Currentbuf->currentLine->len -1);
  arrangeCursor(Currentbuf);
  Currentbuf->visualpos = pos;
  displayBuffer(Currentbuf, B_SCROLL);
}
  
/* 1 line up */
void
lup1(void)
{
  nscroll(PREC_NUM);
}

/* 1 line down */
void
ldown1(void)
{
  nscroll(-PREC_NUM);
}

/* move cursor position to the center of screen */
void
ctrCsrV(void)
{
  int offsety;
  if (Currentbuf->firstLine == NULL)
    return;
  offsety = LASTLINE/2-Currentbuf->cursorY;
  if (offsety != 0) {
/*    Currentbuf->currentLine = lineSkip(Currentbuf->currentLine,offsety); */
    Currentbuf->topLine = lineSkip(Currentbuf->topLine, -offsety);
    arrangeCursor(Currentbuf);
    displayBuffer(Currentbuf, B_NORMAL);
  }
}

void
ctrCsrH(void)
{
  int offsetx;
  if (Currentbuf->firstLine == NULL)
    return;
  offsetx = Currentbuf->cursorX-COLS/2;
  if (offsetx != 0) {
    columnSkip(Currentbuf, offsetx);
    arrangeCursor(Currentbuf);
    displayBuffer(Currentbuf, B_NORMAL);
  }
}

/* Redraw screen */
void
rdrwSc(void)
{
  clear();
  arrangeCursor(Currentbuf);
  displayBuffer(Currentbuf, B_FORCE_REDRAW);
}

/* Search regular expression forward */
void
srchfor(void)
{
  MySignalHandler(*prevtrap) ();
  char           *SearchString;
  int i;
  int wrapped = 0;

  SearchString = inputStrHist("Forward: ", NULL, SearchHist);
  if (SearchString != NULL && *SearchString == '\0' && SearchHist->length)
    SearchString = SearchHist->line[SearchHist->offset];
  if (SearchString == NULL || *SearchString == '\0') {
    displayBuffer(Currentbuf, B_NORMAL);
    return;
  }
  prevtrap = signal(SIGINT, intTrap);
  crmode();
  if (SETJMP(IntReturn) == 0)
    for (i=0; i < PREC_NUM; i++)
      wrapped = forwardSearch(Currentbuf, SearchString);
  signal(SIGINT, prevtrap);
  term_raw();
  displayBuffer(Currentbuf, B_NORMAL);
  if (wrapped) {
    disp_message("Search wrapped", NIL);
  }
  searchRoutine = forwardSearch;
}

/* Search regular expression backward */
void
srchbak(void)
{
  MySignalHandler(*prevtrap) ();
  char           *SearchString;
  int i;
  int wrapped = 0;

  SearchString = inputStrHist("Backward: ", NULL, SearchHist);
  if (SearchString != NULL && *SearchString == '\0' && SearchHist->length)
    SearchString = SearchHist->line[SearchHist->offset];
  if (SearchString == NULL || *SearchString == '\0') {
    displayBuffer(Currentbuf, B_NORMAL);
    return;
  }
  prevtrap = signal(SIGINT, intTrap);
  crmode();
  if (SETJMP(IntReturn) == 0)
    for (i=0; i < PREC_NUM; i++)
      wrapped = backwardSearch(Currentbuf, SearchString);
  signal(SIGINT, prevtrap);
  term_raw();
  displayBuffer(Currentbuf, B_NORMAL);
  if (wrapped) {
    disp_message("Search wrapped", NIL);
  }
  searchRoutine = backwardSearch;
}

static void
srch_nxtprv(int reverse)
{
  int i;
  int wrapped = 0;
  char *SearchString;
  static int (*routine[2]) (Buffer*, char*) = {
    forwardSearch,backwardSearch
  };
  MySignalHandler(*prevtrap) ();

  if (searchRoutine == NULL) {
    disp_message("No previous regular expression",T);
    return;
  }
  SearchString = SearchHist->line[SearchHist->offset];
  move(LASTLINE, 0);
  addstr(searchRoutine == forwardSearch ? "Forward: " : "Backward: ");
  addstr(SearchString);
  clrtoeolx();
  move(LASTLINE, 0);
  refresh();
  if (reverse != 0) reverse = 1;
  if (searchRoutine == backwardSearch )
    reverse ^= 1;
  prevtrap = signal(SIGINT, intTrap);
  crmode();
  if (SETJMP(IntReturn) == 0)
    for (i=0; i < PREC_NUM; i++)
      wrapped = (*routine[reverse]) (Currentbuf, SearchString);
  signal(SIGINT, prevtrap);
  term_raw();
  displayBuffer(Currentbuf, B_NORMAL);
  if (wrapped) {
    disp_message("Search wrapped", NIL);
  }
}

/* Search next matching */
void
srchnxt(void)
{
  srch_nxtprv(0);
}

/* Search previous matching */
void
srchprv(void)
{
  srch_nxtprv(1);
}

/* Shift screen left */
void
shiftl(void)
{
  int             i;
  if (Currentbuf->firstLine == NULL)
    return;
  columnSkip(Currentbuf, PREC_NUM * (-COLS + 1) + 1);
  i = columnPos(Currentbuf->currentLine, Currentbuf->currentColumn + COLS - 1);
  if (Currentbuf->pos > i)
    Currentbuf->pos = i;
  arrangeCursor(Currentbuf);
  displayBuffer(Currentbuf, B_NORMAL);
}

/* Shift screen right */
void
shiftr(void)
{
  int             i;
  if (Currentbuf->firstLine == NULL)
    return;
  columnSkip(Currentbuf, PREC_NUM * (COLS - 1) - 1);
  i = columnPos(Currentbuf->currentLine, Currentbuf->currentColumn);
  if (Currentbuf->pos < i)
    Currentbuf->pos = i;
  arrangeCursor(Currentbuf);
  displayBuffer(Currentbuf, B_NORMAL);
}

void
col1R(void)
{
  Buffer         *buf = Currentbuf;
  Line           *l = buf->currentLine;
  int             i, j, delta;
  Lineprop       *p;

  if (l == NULL) return;
  for(j = 0; j < PREC_NUM; j++) {
  i = buf->pos;
  p = l->propBuf;
#ifdef JP_CHARSET
  if (CharType(p[i]) == PC_KANJI1)
    delta = 2;
  else
#endif
    delta = 1;
  if (buf->currentColumn == buf->pos)
    buf->pos += delta;

  columnSkip(Currentbuf, 1);
  arrangeCursor(Currentbuf);
  }
  displayBuffer(Currentbuf, B_NORMAL);
}

void
col1L(void)
{
  Buffer         *buf = Currentbuf;
  Line           *l = buf->currentLine;
  int             i, j, delta;
  Lineprop       *p;

  if (l == NULL) return;
  for(j = 0; j < PREC_NUM; j++) {
  i = buf->pos;
  p = l->propBuf;
#ifdef JP_CHARSET
  if (CharType(p[i - 1]) == PC_KANJI2)
    delta = 2;
  else
#endif
    delta = 1;
  if ( buf->visualpos == COLS-1 )
    buf->pos = MAX(0, buf->pos-delta);

  columnSkip(Currentbuf, -1);
  arrangeCursor(Currentbuf);
  }
  displayBuffer(Currentbuf, B_NORMAL);
}

/* Execute shell command and read output ac pipe. */
void
pipesh(void)
{
  Buffer         *buf;
  char           *cmd;

  cmd = inputLineHist("(read shell[pipe])!", "", IN_COMMAND, ShellHist);
  if (cmd == NULL || *cmd == '\0') {
    displayBuffer(Currentbuf, B_NORMAL);
    return;
  }
  buf = getpipe(cmd);
  if (buf == NULL) {
    disp_message("Execution failed",NIL);
  } else {
    buf->bufferprop |= (BP_INTERNAL | BP_NO_URL);
    pushBuffer(buf);
  }
  displayBuffer(Currentbuf, B_FORCE_REDRAW);
}

/* Execute shell command and load entire output to buffer */
void
readsh(void)
{
  Buffer         *buf;
  MySignalHandler(*prevtrap) ();
  char           *cmd;

  cmd = inputLineHist("(read shell)!", "", IN_COMMAND, ShellHist);
  if (cmd == NULL || *cmd == '\0') {
    displayBuffer(Currentbuf, B_NORMAL);
    return;
  }
  prevtrap = signal(SIGINT, intTrap);
  crmode();
  buf = getshell(cmd);
  signal(SIGINT, prevtrap);
  term_raw();
  if (buf == NULL) {
    disp_message("Execution failed",NIL);
  } else {
    buf->bufferprop |= (BP_INTERNAL | BP_NO_URL);
    pushBuffer(buf);
  }
  displayBuffer(Currentbuf, B_FORCE_REDRAW);
}

static void
cmd_execcmd(char *cmd)
{
  int l = strlen(cmd)-1;
  int bg = 0;
  fmTerm();
  printf("\n");
  while (l > 0) {
    switch (cmd[l]) {
    case ' ':
    case '\t':
    case '\n':
      l--;
      continue;
    case '&':
      bg = 1;
      cmd[l] = '\0';
      break;
    default:
      break;
    }
    break;
  }
  mySystem(cmd,bg);
  if (!bg) {
    printf("[Hit any key]");
    fflush(stdout);
    fmInit();
    getch();
  }
  else
    fmInit();
  displayBuffer(Currentbuf, B_FORCE_REDRAW);
}

/* Execute shell command */
void
execsh(void)
{
  char           *cmd;
  cmd = inputLineHist("(exec shell)!", "", IN_COMMAND, ShellHist);
  if (cmd != NULL && *cmd != '\0')
    system(cmd);
  displayBuffer(Currentbuf, B_NORMAL);
}

/* Load file */
void
ldfile(void)
{
  char           *fn;

  fn = inputFilenameHist("(Load)Filename? ", NULL, LoadHist);
  if (fn == NULL || *fn == '\0') {
    displayBuffer(Currentbuf, B_NORMAL);
    return;
  }
  cmd_loadfile(fn);
}

/* Load help file */
void
ldhelp(void)
{
  cmd_loadURL(helpFile(HELP_FILE), NULL);
}

static void
cmd_loadfile(char *fn)
{
  Buffer         *buf;

  buf = loadGeneralFile(fn,NULL,NO_REFERER,0,NULL);
  if (buf == NULL) {
    disp_message(Sprintf("%s not found", fn)->ptr,NIL);
  } else {
    pushBuffer(buf);
    if (RenderFrame && Currentbuf->frameset != NULL)
      rFrame();
  }
  displayBuffer(Currentbuf, B_NORMAL);
}

/* Move cursor left */
void
movL(void)
{
  int i;
  if (Currentbuf->firstLine == NULL)
    return;
  for (i=0; i < PREC_NUM; i++)
    cursorLeft(Currentbuf);
  displayBuffer(Currentbuf, B_NORMAL);
}

/* Move cursor downward */
void
movD(void)
{
  int i;
  if (Currentbuf->firstLine == NULL)
    return;
  for (i=0; i < PREC_NUM; i++)
    cursorDown(Currentbuf);
  displayBuffer(Currentbuf, B_NORMAL);
}

/* move cursor upward */
void
movU(void)
{
  int i;
  if (Currentbuf->firstLine == NULL)
    return;
  for (i=0; i < PREC_NUM; i++)
    cursorUp(Currentbuf);
  displayBuffer(Currentbuf, B_NORMAL);
}

/* Move cursor right */
void
movR(void)
{
  int i;
  if (Currentbuf->firstLine == NULL)
    return;
  for (i=0; i < PREC_NUM; i++)
    cursorRight(Currentbuf);
  displayBuffer(Currentbuf, B_NORMAL);
}



/* movLW, movRW */
/* 
  From: Takashi Nishimoto <g96p0935@mse.waseda.ac.jp>
  Date: Mon, 14 Jun 1999 09:29:56 +0900
*/

#define IS_WORD_CHAR(c,p) (IS_ALNUM(c) && CharType(p) == PC_ASCII)

static int
prev_nonnull_line(Line *line)
{
  Line *l;

  for (l = line; l != NULL && l->len == 0; l = l->prev)
    ;
  if (l == NULL || l->len == 0)
    return -1;
  
    Currentbuf->currentLine = l;
  if (l != line)
    Currentbuf->pos = Currentbuf->currentLine->len;
  return 0;
}

void
movLW(void)
{
  char *lb;
  Lineprop *pb;
  Line *pline;
  int ppos;
  int i;
  
  if (Currentbuf->firstLine == NULL)
    return;

  for (i = 0; i < PREC_NUM; i++) {
    pline = Currentbuf->currentLine;
    ppos = Currentbuf->pos;
    
    if (prev_nonnull_line(Currentbuf->currentLine) < 0)
      goto end;
  
    while (1) {
    lb = Currentbuf->currentLine->lineBuf;
      pb = Currentbuf->currentLine->propBuf;
      while (Currentbuf->pos > 0 &&
	     !IS_WORD_CHAR(lb[Currentbuf->pos -1], pb[Currentbuf->pos -1])) {
	Currentbuf->pos--;
      }
      if (Currentbuf->pos > 0)
	break;
      if (prev_nonnull_line(Currentbuf->currentLine->prev) < 0) {
	Currentbuf->currentLine = pline;
	Currentbuf->pos = ppos;
	goto end;
  }
      Currentbuf->pos = Currentbuf->currentLine->len;
  }
    
    lb = Currentbuf->currentLine->lineBuf;
    pb = Currentbuf->currentLine->propBuf;
    while (Currentbuf->pos > 0 &&
	   IS_WORD_CHAR(lb[Currentbuf->pos -1], pb[Currentbuf->pos -1])) {
      Currentbuf->pos--;
    }
  }
end:
  arrangeCursor(Currentbuf);
  displayBuffer(Currentbuf, B_NORMAL);
}

static int
next_nonnull_line(Line *line)
{
  Line *l;

  for (l = line; l != NULL && l->len == 0;  l = l->next);

  if (l == NULL || l->len == 0)
    return -1;

  Currentbuf->currentLine = l;
  if (l != line)
    Currentbuf->pos = 0;
    return 0;
}

void
movRW(void)
{
  char *lb;
  Lineprop *pb;
  Line *pline;
  int ppos;
  int i;

  if (Currentbuf->firstLine == NULL)
    return;

  for (i = 0; i < PREC_NUM; i++) {
    pline = Currentbuf->currentLine;
    ppos = Currentbuf->pos;

    if (next_nonnull_line(Currentbuf->currentLine) < 0)
      goto end;
  
    lb = Currentbuf->currentLine->lineBuf;
    pb = Currentbuf->currentLine->propBuf;
  
    while (lb[Currentbuf->pos] &&
	   IS_WORD_CHAR(lb[Currentbuf->pos], pb[Currentbuf->pos]))
      Currentbuf->pos++;

    while (1) {
      while (lb[Currentbuf->pos] &&
	     !IS_WORD_CHAR(lb[Currentbuf->pos], pb[Currentbuf->pos]))
	Currentbuf->pos++;
      if (lb[Currentbuf->pos])
	break;
      if (next_nonnull_line(Currentbuf->currentLine->next) < 0) {
	Currentbuf->currentLine = pline;
	Currentbuf->pos = ppos;
	goto end;
      }
      Currentbuf->pos = 0;
      lb = Currentbuf->currentLine->lineBuf;
      pb = Currentbuf->currentLine->propBuf;
  }
  }
end:
  arrangeCursor(Currentbuf);
  displayBuffer(Currentbuf, B_NORMAL);
}

/* Question and Quit */
void
qquitfm(void)
{
  char *ans;
  if (!confirm_on_quit)
    quitfm();
  ans = inputStr("Do you want to exit w3m? (y or n)","");
  if (ans == NULL || tolower(*ans) == 'y')
    quitfm();
  displayBuffer(Currentbuf,B_NORMAL);
}

/* Quit */
void
quitfm(void)
{
  fmTerm();
  deleteFiles();
#ifdef USE_COOKIE
  save_cookies();
#endif
#ifdef USE_HISTORY
  if (URLSaveHist)
    saveHistory(URLHist);
#endif
  exit(0);
}

/* Select buffer */
void
selBuf(void)
{
  Buffer         *buf;
  int            ok;
  char            cmd;

  ok = NIL;
  do {
    buf = selectBuffer(Firstbuf, Currentbuf, &cmd);
    switch (cmd) {
    case 'B':
      ok = T;
      break;
    case '\n':
    case ' ':
      Currentbuf = buf;
      ok = T;
      break;
    case 'D':
      delBuffer(buf);
      if (Firstbuf == NULL) {
	/* No more buffer */
	Firstbuf = nullBuffer();
	Currentbuf = Firstbuf;
      }
      break;
    case 'q':
      qquitfm();
      break;
    case 'Q':
      quitfm();
      break;
    }
  } while (!ok);
  displayBuffer(Currentbuf, B_FORCE_REDRAW);
}

/* Suspend (on BSD), or run interactive shell (on SysV) */
void
susp(void)
{
#ifndef SIGSTOP
  char *shell;
#endif
  move(LASTLINE, 0);
  clrtoeolx();
  refresh();
  fmTerm();
#ifndef SIGSTOP
  shell = getenv("SHELL");
  if (shell == NULL)
    shell = "/bin/sh";
  system(shell);
#else
  kill(getpid(), SIGSTOP);
#endif
  fmInit();
  displayBuffer(Currentbuf, B_FORCE_REDRAW);
}

/* Go to specified line */
static void
_goLine(char *l)
{
  if (l == NULL || *l == '\0' || Currentbuf->currentLine == NULL) {
    displayBuffer(Currentbuf, B_FORCE_REDRAW);
    return;
  }
  if (((*l == '^') || (*l == '$')) && prec_num)
    gotoLine(Currentbuf, prec_num);
  else if (*l == '^') {
    Currentbuf->topLine = Currentbuf->currentLine = Currentbuf->firstLine;
  } else if (*l == '$') {
    Currentbuf->topLine = lineSkip(Currentbuf->lastLine, -(LASTLINE+1) / 2);
    Currentbuf->currentLine = Currentbuf->lastLine;
  } else
    gotoLine(Currentbuf, atoi(l));
  arrangeCursor(Currentbuf);
  displayBuffer(Currentbuf, B_FORCE_REDRAW);
}

void
goLine(void)
{
  char           *l = inputStr("Goto line: ", "");
  prec_num = 0;
  _goLine(l);
}

void
goLineF(void)
{
  _goLine("^");
}

void
goLineL(void)
{
  _goLine("$");
}

/* Go to the beginning of the line */
void
linbeg(void)
{
  if (Currentbuf->firstLine == NULL)
    return;
  Currentbuf->pos = 0;
  arrangeCursor(Currentbuf);
  displayBuffer(Currentbuf, B_NORMAL);
}

/* Go to the bottom of the line */
void
linend(void)
{
  if (Currentbuf->firstLine == NULL)
    return;
  Currentbuf->pos = Currentbuf->currentLine->len - 1;
  arrangeCursor(Currentbuf);
  displayBuffer(Currentbuf, B_NORMAL);
}

/* Run editor on the current buffer */
void
editBf(void)
{
  char           *fn = Currentbuf->filename;
  int             lnum = 0, is_source;
  Buffer         *buf, *fbuf = NULL;
  Str             cmd = Strnew();

  if (fn == NULL || 
      Currentbuf->pagerSource != NULL || /* Behaving as a pager */
      Currentbuf->type == NULL || /* Reading shell */
      Currentbuf->currentURL.scheme != SCM_LOCAL ||
      !strcmp(Currentbuf->currentURL.file,"-") || /* file is std input */
      Currentbuf->bufferprop & BP_FRAME) { /* Frame */
    disp_message("Can't edit other than local file",T);
    return;
  }
  if (Currentbuf->frameset != NULL)
    fbuf = Currentbuf->linkBuffer[LB_FRAME];
  is_source = Currentbuf->bufferprop & BP_SOURCE;
  if (Currentbuf->currentLine)
    lnum = Currentbuf->currentLine->linenumber;
  Strcat_charp(cmd,Editor);
  if (strcasestr(Editor,"vi")) {
    Strcat(cmd,Sprintf(" +%d",lnum));
  }
  Strcat_m_charp(cmd," ",Currentbuf->filename,NULL);
  fmTerm();
  system(cmd->ptr);
  fmInit();
  buf = loadGeneralFile(fn,NULL,NO_REFERER,0,NULL);
  if (buf == NULL) {
    disp_message("Re-loading failed",NIL);
    buf = nullBuffer();
  }
  if (fbuf != NULL)
    Firstbuf = deleteBuffer(Firstbuf, fbuf);
  repBuffer(Currentbuf, buf);
  if (is_source) {
    vwSrc();
    if (Currentbuf != buf)
      Firstbuf = deleteBuffer(Firstbuf, buf);
  }
  gotoLine(Currentbuf, lnum);
  arrangeCursor(Currentbuf);
  displayBuffer(Currentbuf, B_NORMAL);
}

/* Run editor on the current screen */
void
editScr(void)
{
  int             lnum = 0;
  Str             cmd = Strnew();
  Str             tmpf;
  FILE           *f;

  tmpf = Sprintf("%s/w3mscr%d",rc_dir,getpid());
  f = fopen(tmpf->ptr,"w");
  if (f == NULL) {
    cmd = Sprintf("Can't open %s\n", tmpf->ptr);
    disp_message(cmd->ptr,T);
    return;
  }
  saveBuffer(Currentbuf,f);
  fclose(f);
  if (Currentbuf->currentLine)
    lnum = Currentbuf->currentLine->linenumber;
  Strcat_charp(cmd,Editor);
  if (strcasestr(Editor,"vi")) {
    Strcat(cmd,Sprintf(" +%d",lnum));
  }
  Strcat_char(cmd,' ');
  Strcat(cmd,tmpf);
  fmTerm();
  system(cmd->ptr);
  fmInit();
  unlink(tmpf->ptr);
  gotoLine(Currentbuf, lnum);
  arrangeCursor(Currentbuf);
  displayBuffer(Currentbuf, B_FORCE_REDRAW);
}

#ifdef USE_MARK

/* Set / unset mark */
void
_mark(void)
{
  Line           *l;
  if (Currentbuf->firstLine == NULL)
    return;
  l = Currentbuf->currentLine;
  cmd_mark(&l->propBuf[Currentbuf->pos]);
  redrawLine(Currentbuf, l, l->linenumber - Currentbuf->topLine->linenumber);
}

static void
cmd_mark(Lineprop * p)
{
  if ((*p & PM_MARK) && (*p & PE_STAND))
    *p &= ~PE_STAND;
  else if (!(*p & PM_MARK) && !(*p & PE_STAND))
    *p |= PE_STAND;
  *p ^= PM_MARK;
}

/* Go to next mark */
void
nextMk(void)
{
  Line           *l;
  int             i;

  if (Currentbuf->firstLine == NULL)
    return;
  i = Currentbuf->pos + 1;
  l = Currentbuf->currentLine;
  if (i >= l->len) {
    i = 0;
    l = l->next;
  }
  while (l != NULL) {
    for (; i < l->len; i++) {
      if (l->propBuf[i] & PM_MARK) {
	Currentbuf->currentLine = l;
	Currentbuf->pos = i;
	arrangeCursor(Currentbuf);
	displayBuffer(Currentbuf, B_NORMAL);
	return;
      }
    }
    l = l->next;
    i = 0;
  }
  disp_message("No mark exist after here",T);
}

/* Go to previous mark */
void
prevMk(void)
{
  Line           *l;
  int             i;

  if (Currentbuf->firstLine == NULL)
    return;
  i = Currentbuf->pos - 1;
  l = Currentbuf->currentLine;
  if (i < 0) {
    l = l->prev;
    if (l != NULL)
      i = l->len - 1;
  }
  while (l != NULL) {
    for (; i >= 0; i--) {
      if (l->propBuf[i] & PM_MARK) {
	Currentbuf->currentLine = l;
	Currentbuf->pos = i;
	arrangeCursor(Currentbuf);
	displayBuffer(Currentbuf, B_NORMAL);
	return;
      }
    }
    l = l->prev;
    if (l != NULL)
      i = l->len - 1;
  }
  disp_message("No mark exist before here",T);
}

/* Mark place to which the regular expression matches */
void
reMark(void)
{
  Line           *l;
  char           *MarkString = NULL;
  char           *p, *p1, *p2;
  char *regexCompile(char*,int);
  int regexMatch(char*,int);
  void matchedPosition(char**,char**);

  if (MarkHist->length) {
    MarkString = MarkHist->line[MarkHist->offset];
    MarkHist->position = MarkHist->offset;
  }
  MarkString = inputStrHist("(Mark)Regexp: ", MarkString, MarkHist);
  if (MarkString == NULL || *MarkString == '\0') {
    displayBuffer(Currentbuf, B_NORMAL);
    return;
  }
  if ((MarkString = regexCompile(MarkString,1)) != NULL) {
    disp_message(MarkString, T);
    return;
  }
  for (l = Currentbuf->firstLine; l != NULL; l = l->next) {
    p = l->lineBuf;
    for (;;) {
      if (regexMatch(p, p == l->lineBuf) == 1) {
	matchedPosition(&p1, &p2);
	cmd_mark(l->propBuf + (p1 - l->lineBuf));
	p = p2;
      } else
	break;
    }
  }

  displayBuffer(Currentbuf, B_FORCE_REDRAW);
}
#endif

#ifdef JP_CHARSET
static char*
cURLcode(char *url, Buffer *buf)
{
  char *p;
  Str s;

  for (p = url; *p; p++) {
    if (*p & 0x80) {
      /* URL contains Kanji... uugh */
      s = conv(url,InnerCode,buf->document_code);
      return s->ptr;
    }
  }
  return url;
}
#else
#define cURLcode(url,buf) (url)
#endif

static Buffer *
loadLink(char *url, char *target, char *referer, FormList *request)
{
  Buffer *buf;
  struct frame_body *f_body;
  int flag;

  message(Sprintf("loading %s\n", url)->ptr, 0, 0);
  refresh();

  if (Currentbuf->bufferprop & BP_FRAME && target != NULL && !do_download) {
    buf = Currentbuf->linkBuffer[LB_N_FRAME];
    if (buf == NULL)
      goto normal_load;
    f_body = search_frame(buf->frameset,target);
    if (f_body == NULL)
      goto normal_load;
    delBuffer(Currentbuf);
    Currentbuf = buf;
    if (f_body->to_delete)
      unlink(f_body->source);
    f_body->source = NULL;
    f_body->url = url;
    f_body->referer = referer;
    rFrame();
    return buf;
  }

normal_load:
  buf = loadGeneralFile(cURLcode(url,Currentbuf),
			baseURL(Currentbuf),
			referer,
			flag,
			request);
  if (buf == NULL) {
    disp_message(Sprintf("Can't load %s\n", url)->ptr, NIL);
  } else if (buf != NO_BUFFER) {
    pushBuffer(buf);
    addUniqHist(URLHist, parsedURL2Str(&Currentbuf->currentURL)->ptr);
    if (RenderFrame && Currentbuf->frameset != NULL)
      rFrame();
  }
  displayBuffer(Currentbuf, B_NORMAL);
  return buf;
}

/* follow HREF link */
void
followA(void)
{
  Line           *l;
  Anchor         *a;
  Buffer         *buf;
  int             ln,i;

  if (Currentbuf->firstLine == NULL)
    return;
  l = Currentbuf->currentLine;

  a = retrieveCurrentAnchor(Currentbuf);
  if (a == NULL) {
    followForm();
    return;
  }
  if (*a->url == '#') {		/* index within this buffer */
    ln = searchURLLabelLine(Currentbuf, a->url + 1);
    if (ln < 0) {
      disp_message("Not found",T);
      return;
    }
    buf = newBuffer(Currentbuf->width);
    copyBuffer(buf,Currentbuf);
    for(i = 0; i < MAX_LB; i++)
      buf->linkBuffer[i] = NULL;
    buf->currentURL.label = allocStr(a->url + 1, 0);
    (*buf->clone)++;
    pushBuffer(buf);
    gotoLine(Currentbuf, ln);
    arrangeCursor(Currentbuf);
    displayBuffer(Currentbuf, B_FORCE_REDRAW);
    return;
  }
  if (!strncasecmp(a->url,"mailto:",7)) {
    /* invoke external mailer */
    Str tmp;
    tmp = Strnew_m_charp(Mailer," ",a->url+7,NULL);
    cmd_execcmd(tmp->ptr);
    return;
  }
  else if (!strncasecmp(a->url,"news:",5) &&
	   strchr(a->url,'@') == NULL) {
    /* news:newsgroup is not supported */
    disp_message("news:newsgroup_name is not supported",T);
    return;
  }
  loadLink(a->url,a->target,a->referer,NULL);
}

/* view inline image */
void
followI(void)
{
  Line           *l;
  Anchor         *a;
  Buffer         *buf;

  if (Currentbuf->firstLine == NULL)
    return;
  l = Currentbuf->currentLine;

  a = retrieveCurrentImg(Currentbuf);
  if (a == NULL)
    return;
  message(Sprintf("loading %s\n", a->url)->ptr, 0, 0);
  refresh();
  buf = loadGeneralFile(cURLcode(a->url,Currentbuf), baseURL(Currentbuf),NULL,0,NULL);
  if (buf == NULL) {
    disp_message(Sprintf("Can't load %s\n", a->url)->ptr, NIL);
  } else if (buf != NO_BUFFER) {
    pushBuffer(buf);
  }
  displayBuffer(Currentbuf, B_NORMAL);
}

static void
do_update_form_radio(FormItemList *f, void *data)
{
  Buffer *buf = (Buffer*)data;
  formUpdateBuffer(&buf->formitem->anchors[f->anchor_num],buf,f);
}

static FormItemList *
save_submit_formlist(FormItemList *src)
{
  FormList *list;
  FormList *srclist;
  FormItemList *srcitem;
  FormItemList *item;
  FormItemList *ret = NULL;
#ifdef MENU_SELECT
  FormSelectOptionItem *opt;
  FormSelectOptionItem *curopt;
  FormSelectOptionItem *srcopt;
#endif

  if (src == NULL)
    return NULL;
  srclist = src->parent;
  list = New(FormList);
  list->method = srclist->method;
  list->action = Strdup(srclist->action);
  list->charset = srclist->charset;
  list->enctype = srclist->enctype;
  list->nitems = srclist->nitems;
  list->body = srclist->body;
  list->boundary = srclist->boundary;
  list->length = srclist->length;

  for (srcitem = srclist->item; srcitem; srcitem = srcitem->next) {
    item = New(FormItemList);
    item->type = srcitem->type;
    item->name = Strdup(srcitem->name);
    item->value = Strdup(srcitem->value);
    item->checked = srcitem->checked;
    item->accept = srcitem->accept;
    item->size = srcitem->size;
    item->rows = srcitem->rows;
    item->maxlength = srcitem->maxlength;
#ifdef MENU_SELECT
    opt = curopt = NULL;
    for (srcopt = srcitem->select_option; srcopt; srcopt = srcopt->next) {
      if (!srcopt->checked)
	continue;
      opt = New(FormSelectOptionItem);
      opt->value = Strdup(srcopt->value);
      opt->label = Strdup(srcopt->label);
      opt->checked = srcopt->checked;
      if (item->select_option == NULL) {
	item->select_option = curopt = opt;
      } else {
	curopt->next = opt;
	curopt = curopt->next;
      }
    }
    item->select_option = opt;
    if (srcitem->label)
      item->label = Strdup(srcitem->label);
#endif
    item->parent = list;
    item->next = NULL;

    if (list->lastitem == NULL) {
      list->item = list->lastitem = item;
    } else {
      list->lastitem->next = item;
      list->lastitem = item;
    }

    if (srcitem == src)
      ret = item;
  }

  return ret;
}

static void
query_from_followform(Str *query, FormItemList *fi, int multipart)
{
  FormItemList *f2;
  FILE *body;

  if (multipart) {
    *query = Sprintf("%s/w3mform%d.%lx", rc_dir, getpid(),
		      (unsigned long) fi->parent);
    body = fopen((*query)->ptr, "w");
    if (body == NULL) {
      return;
    }
    fi->parent->body = (*query)->ptr;
    fi->parent->boundary = Sprintf("------------------------------%d%ld%ld%ld",
      getpid(), fi->parent, fi->parent->body, fi->parent->boundary)->ptr;
  }
  *query = Strnew();
  for (f2 = fi->parent->item; f2; f2 = f2->next) {
    if (f2->name == NULL || f2->name->length == 0)
      continue;
    switch (f2->type) {
    case FORM_INPUT_RESET:
      /* do nothing */
      continue;
    case FORM_INPUT_SUBMIT:
    case FORM_INPUT_IMAGE:
      if (f2 != fi || f2->value == NULL)
	continue;
      break;
    case FORM_INPUT_RADIO:
    case FORM_INPUT_CHECKBOX:
      if (!f2->checked) 
	continue;
      }
      if (multipart) {
	if (f2->type == FORM_INPUT_IMAGE) {
	  *query = Strdup(f2->name); 
	  Strcat_charp(*query,".x");
	  form_write_data(body, fi->parent->boundary, (*query)->ptr, "0");
	  *query = Strdup(f2->name); 
	  Strcat_charp(*query,".y");
	  form_write_data(body, fi->parent->boundary, (*query)->ptr, "0");
	} else if (f2->name && f2->name->length > 0) {
  #ifdef JP_CHARSET
	  if (fi->parent->charset != 0)
	    *query = conv(f2->value->ptr,InnerCode,fi->parent->charset);
	  else
	    *query = conv(f2->value->ptr,InnerCode,Currentbuf->document_code);
  #else
	  *query = f2->value;
  #endif
	  if (f2->type == FORM_INPUT_FILE)
	    form_write_form_file(body, fi->parent->boundary, f2->name->ptr, (*query)->ptr);
	  else
	    form_write_data(body, fi->parent->boundary, f2->name->ptr, (*query)->ptr);
	}
      } else {
	if (f2->type == FORM_INPUT_IMAGE) {
	  Strcat(*query,f2->name);
	  Strcat_charp(*query,".x=0&");
	  Strcat(*query,f2->name);
	  Strcat_charp(*query,".y=0");
	} else {
	  if (f2->name && f2->name->length > 0) {
	    Strcat(*query,f2->name);
	    Strcat_char(*query,'=');
	  }
	  if (fi->parent->method == FORM_METHOD_INTERNAL) 
	    Strcat(*query,form_quote(f2->value));
	  else {
  #ifdef JP_CHARSET
	    if (fi->parent->charset != 0)
	      Strcat(*query,form_quote(conv(f2->value->ptr,InnerCode,fi->parent->charset)));
	    else
	      Strcat(*query,form_quote(conv(f2->value->ptr,InnerCode,Currentbuf->document_code)));
  #else
	    Strcat(*query,form_quote(f2->value));
  #endif
	  }
	}
	if (f2->next)
	  Strcat_char(*query,'&');
      }
  }
  if (multipart) {
    fprintf(body, "--%s--\r\n", fi->parent->boundary);
    fclose(body);
  } else {
    /* remove trailing & */
    while (Strlastchar(*query) == '&')
      Strshrink(*query,1);
  }
}

/* process form */
void
followForm(void)
{
  Line           *l;
  Anchor         *a;
  char           *p;
  FormItemList   *fi,*f2;
  Str            tmp = Strnew(),tmp2 = Strnew();
  int             multipart = 0;

  if (Currentbuf->firstLine == NULL)
    return;
  l = Currentbuf->currentLine;

  a = retrieveCurrentForm(Currentbuf);
  if (a == NULL)
    return;
  fi = (FormItemList*)a->url;
  switch (fi->type) {
  case FORM_INPUT_TEXT:
    p = inputStr("TEXT:", fi->value ? fi->value->ptr : NULL);
    if (p == NULL)
      return;
    fi->value = Strnew_charp(p);
    formUpdateBuffer(a,Currentbuf,fi);
    if (fi->accept || fi->parent->nitems == 1) goto do_submit;
    break;
  case FORM_INPUT_FILE:
    p = inputFilenameHist("Filename:", fi->value ? fi->value->ptr : NULL, NULL);
    if (p == NULL)
      return;
    fi->value = Strnew_charp(p);
    formUpdateBuffer(a,Currentbuf,fi);
    if (fi->accept || fi->parent->nitems == 1) goto do_submit;
    break;
  case FORM_INPUT_PASSWORD:
    p = inputLine("TEXT:", fi->value ? fi->value->ptr : NULL, IN_PASSWORD);
    if (p == NULL)
      return;
    fi->value = Strnew_charp(p);
    formUpdateBuffer(a,Currentbuf,fi);
    if (fi->accept) goto do_submit;
    break;
  case FORM_TEXTAREA:
    if (fi->rows == 1) {
      p = inputStr("TEXT:", fi->value ? fi->value->ptr : NULL);
      if (p == NULL)
	return;
      fi->value = Strnew_charp(p);
    }
    else
      input_textarea(fi);
    formUpdateBuffer(a,Currentbuf,fi);
    break;
  case FORM_INPUT_RADIO:
    form_recheck_radio(fi,Currentbuf,do_update_form_radio);
    break;
  case FORM_INPUT_CHECKBOX:
    fi->checked = !fi->checked;
    formUpdateBuffer(a,Currentbuf,fi);
    break;
#ifdef MENU_SELECT
  case FORM_SELECT:
    formChooseOptionByMenu(fi,
      Currentbuf->cursorX - Currentbuf->pos + a->start.pos,
      Currentbuf->cursorY);
    formUpdateBuffer(a,Currentbuf,fi);
    break;
#endif
  case FORM_INPUT_IMAGE:
  case FORM_INPUT_SUBMIT:
  case FORM_INPUT_BUTTON:
  do_submit:
    multipart = (fi->parent->method == FORM_METHOD_POST &&
		 fi->parent->enctype == FORM_ENCTYPE_MULTIPART);
    query_from_followform(&tmp, fi, multipart);

    tmp2 = Strdup(fi->parent->action);
    if (!Strcmp_charp(tmp2,"!CURRENT_URL!")) {
      /* It means "current URL" */
      tmp2 = parsedURL2Str(&Currentbuf->currentURL);
    }

    if (fi->parent->method == FORM_METHOD_GET) {
      Strcat_charp(tmp2,"?");
      Strcat(tmp2,tmp);
      loadLink(tmp2->ptr,fi->parent->target,NULL,NULL);
    }
    else if (fi->parent->method == FORM_METHOD_POST) {
      Buffer *buf;
      if (multipart) {
	struct stat st;
	stat(fi->parent->body, &st);
	fi->parent->length = st.st_size;
      } else {
	fi->parent->body = tmp->ptr;
	fi->parent->length = tmp->length;
      }
      buf = loadLink(tmp2->ptr,fi->parent->target,NULL,fi->parent);
      if (multipart) {
	unlink(fi->parent->body);
      }
      if (buf) /* buf must be Currentbuf */
	buf->form_submit = save_submit_formlist(fi);
    }
    else { /* internal */
      do_internal(tmp2->ptr,tmp->ptr);
      return;
    }
    break;
  case FORM_INPUT_RESET:
    for (f2 = fi->parent->item; f2; f2 = f2->next) {
      if (f2->name && f2->value && 
          f2->type != FORM_INPUT_RADIO && 
          f2->type != FORM_INPUT_CHECKBOX && 
          f2->type != FORM_INPUT_SUBMIT && 
          f2->type != FORM_INPUT_HIDDEN && 
          f2->type != FORM_INPUT_RESET) {
        f2->value = Strnew();
        formUpdateBuffer(&Currentbuf->formitem->anchors[f2->anchor_num],Currentbuf,f2);
      }
    }
    break;
  case FORM_INPUT_HIDDEN:
  default:
    break;
  }
  displayBuffer(Currentbuf, B_FORCE_REDRAW);
}

void
drawAnchorCursor(Buffer *buf)
{
  Anchor *an;
  Line *l;
  int i, j, hseq, prevhseq;
  int tline, eline;

  if (buf->firstLine == NULL)
      return;
  if (buf->href == NULL)
      return;

  an = retrieveCurrentAnchor(buf);
  if (an != NULL)
      hseq = an->hseq;
  else
      hseq = -1;
  tline = buf->topLine->linenumber;
  eline = tline + LASTLINE;
  prevhseq = buf->hmarklist->prevhseq;
  
  l = buf->firstLine;
  for (j = 0; j < buf->href->nanchor; j++) {
      an = &buf->href->anchors[j];
      for (; l != NULL; l = l->next) {
	  if (l->linenumber == an->start.line)
	      break;
      }
      if (l==NULL)
	  break;
      if (an->end.line != an->start.line)
	  continue;
      if (hseq >= 0 && an->hseq == hseq) {
	  for (i=an->start.pos; i<an->end.pos; i++) {
	      if (l->propBuf[i] & (PE_IMAGE | PE_ANCHOR | PE_FORM) )
		  l->propBuf[i] |= PE_ACTIVE;
	  }
	  if (l->linenumber >= tline && l->linenumber < eline)
              redrawLineRegion(buf, l, l->linenumber -tline,
			       an->start.pos, an->end.pos);
      } else if (prevhseq >=0 && an->hseq == prevhseq) {
          if (l->linenumber >= tline && l->linenumber < eline)
              redrawLineRegion(buf, l, l->linenumber -tline,
                               an->start.pos, an->end.pos);
      }
  }
  l = buf->firstLine;
  for (j = 0; j < buf->href->nanchor; j++) {
      an = &buf->href->anchors[j];
      for (; l != NULL; l = l->next) {
	  if (l->linenumber == an->start.line)
	      break;
      }
      if (l==NULL)
	  break;
      if (an->end.line != an->start.line)
	  continue;
      if (hseq >= 0 && an->hseq == hseq) {
	  for (i=an->start.pos; i<an->end.pos; i++)
	      l->propBuf[i] &= ~PE_ACTIVE;
      }
  }
  buf->hmarklist->prevhseq = hseq;
}

/* underline an anchor if cursor is on the anchor. */
void
onA(void)
{
  drawAnchorCursor(Currentbuf);
  displayBuffer(Currentbuf, B_NORMAL);
}

/* go to the top anchor */
void
topA(void)
{
  HmarkerList *hl = Currentbuf->hmarklist;
  BufferPoint *po;
  Anchor *an;
  int hseq;

  if (Currentbuf->firstLine == NULL)
      return;
  if (!hl || hl->nmark==0)
      return;

  hseq = 0;
  do {
      if (hseq >= hl->nmark)
	  return;
      po = hl->marks +hseq;
      an = retrieveAnchor(Currentbuf->href, po->line, po->pos);
      if (an == NULL)
	  an = retrieveAnchor(Currentbuf->formitem, po->line, po->pos);
      hseq++;
  } while (an == NULL);
  
  gotoLine(Currentbuf, po->line);
  Currentbuf->pos = po->pos;
  arrangeCursor(Currentbuf);
  displayBuffer(Currentbuf, B_NORMAL);
}

/* go to the last anchor */
void
lastA(void)
{
  HmarkerList *hl = Currentbuf->hmarklist;
  BufferPoint *po;
  Anchor *an;
  int hseq;

  if (Currentbuf->firstLine == NULL)
      return;
  if (!hl || hl->nmark==0)
      return;
  
  hseq = hl->nmark -1;
  do {
      if (hseq < 0)
	  return;
      po = hl->marks +hseq;
      an = retrieveAnchor(Currentbuf->href, po->line, po->pos);
      if (an == NULL)
	  an = retrieveAnchor(Currentbuf->formitem, po->line, po->pos);
      hseq--;
  } while (an == NULL);
  
  gotoLine(Currentbuf, po->line);
  Currentbuf->pos = po->pos;
  arrangeCursor(Currentbuf);
  displayBuffer(Currentbuf, B_NORMAL);
}

/* go to the next anchor */
void
nextA(void)
{
  HmarkerList *hl = Currentbuf->hmarklist;
  BufferPoint *po;
  Anchor *an, *pan;
  int i,x,y;

  if (Currentbuf->firstLine == NULL)
    return;
  if (!hl || hl->nmark==0)
      return;

  an = retrieveCurrentAnchor(Currentbuf);
  if (an == NULL)
      an = retrieveCurrentForm(Currentbuf);
  
  y = Currentbuf->currentLine->linenumber;
  x = Currentbuf->pos;

  for (i=0; i < PREC_NUM; i++) {
    pan = an;
    if (an && an->hseq >= 0) {
      int hseq = an->hseq +1;
      do {
	if (hseq >= hl->nmark) {
	  pan = an;
	  goto _end;
	}
	po = &hl->marks[hseq];
	an = retrieveAnchor(Currentbuf->href, po->line, po->pos);
	if (an == NULL)
	  an = retrieveAnchor(Currentbuf->formitem, po->line, po->pos);
	hseq++;
      } while (an == NULL || an==pan);
    } else {
      an = closest_next_anchor(Currentbuf->href,NULL,x,y);
      an = closest_next_anchor(Currentbuf->formitem,an,x,y);
      if (an == NULL) {
	an = pan;
	break;
      }
      x = an->start.pos; y = an->start.line;
    }
  }

_end:
  if (an == NULL || an->hseq < 0) return;
  po = &hl->marks[an->hseq];
  gotoLine(Currentbuf, po->line);
  Currentbuf->pos = po->pos;
  arrangeCursor(Currentbuf);
  displayBuffer(Currentbuf, B_NORMAL);
}

/* go to the previous anchor */
void
prevA(void)
{
  HmarkerList *hl = Currentbuf->hmarklist;
  BufferPoint *po;
  Anchor *an, *pan;
  int i,x,y;

  if (Currentbuf->firstLine == NULL)
    return;
  if (!hl || hl->nmark==0)
      return;

  an = retrieveCurrentAnchor(Currentbuf);
  if (an == NULL)
      an = retrieveCurrentForm(Currentbuf);

  y = Currentbuf->currentLine->linenumber;
  x = Currentbuf->pos;

  for (i=0; i < PREC_NUM; i++) {
    pan = an;
      if (an && an->hseq >= 0) {
	  int hseq = an->hseq -1;
	  do {
	      if (hseq < 0) {
		  an = pan;
		  goto _end;
	      }
	      po = hl->marks + hseq;
	      an = retrieveAnchor(Currentbuf->href, po->line, po->pos);
	      if (an == NULL)
		  an = retrieveAnchor(Currentbuf->formitem, po->line, po->pos);
	      hseq--;
	  } while (an == NULL || an==pan);
      } else {
    an = closest_prev_anchor(Currentbuf->href,NULL,x,y);
    an = closest_prev_anchor(Currentbuf->formitem,an,x,y);
    if (an == NULL) {
      an = pan;
      break;
    }
    x = an->start.pos; y = an->start.line;
  }
  }

_end:
  if (an == NULL || an->hseq < 0) return;
  po = hl->marks + an->hseq;
  gotoLine(Currentbuf, po->line);
  Currentbuf->pos = po->pos;
  arrangeCursor(Currentbuf);
  displayBuffer(Currentbuf, B_NORMAL);
}

static int
checkBackBuffer(Buffer *buf)
{
  Buffer *nbuf = buf->nextBuffer;

  if (nbuf == NULL)
    return NIL;
  else if (RenderFrame && nbuf == buf->linkBuffer[LB_N_FRAME])
    return checkBackBuffer(nbuf);
  else
    return T;
}

static void
realBackBuffer()
{
  Buffer *buf;

  buf = Currentbuf->linkBuffer[LB_N_FRAME];
  delBuffer(Currentbuf);
  if (RenderFrame && Currentbuf == buf)
    realBackBuffer();
}

/* delete current buffer and back to the previous buffer */
void
backBf(void)
{
  if (!checkBackBuffer(Currentbuf)) {
    disp_message("Can't back...",T);
    return;
  }
  realBackBuffer();
  clear();
  displayBuffer(Currentbuf, B_FORCE_REDRAW);
}

void
deletePrevBuf()
{
  Buffer *buf = Currentbuf->nextBuffer;
  if (buf)
    delBuffer(buf);
}

static void
cmd_loadURL(char *url, ParsedURL *current)
{
  Buffer         *buf;

  if (!strncasecmp(url,"news:",5) &&
	   strchr(url,'@') == NULL) {
    /* news:newsgroup is not supported */
    disp_message("news:newsgroup_name is not supported",T);
    return;
  }
  
  message(Sprintf("loading %s\n", url)->ptr, 0, 0);
  refresh();
  buf = loadGeneralFile(url, current,NO_REFERER,0,NULL);
  if (buf == NULL) {
    disp_message(Sprintf("Can't load %s\n", url)->ptr,NIL);
  } else if (buf != NO_BUFFER) {
    pushBuffer(buf);
    if (RenderFrame && Currentbuf->frameset != NULL)
      rFrame();
  }
  displayBuffer(Currentbuf, B_NORMAL);
}


/* go to specified URL */
void
goURL(void)
{
  char           *url;

  if (cmd_argument)
    url = (char*)cmd_argument;
  else
    url = inputStrHist("Goto URL: ", NULL, URLHist);
  if (url == NULL || *url == '\0') {
    displayBuffer(Currentbuf, B_FORCE_REDRAW);
    return;
  }
  cmd_loadURL(url,baseURL(Currentbuf));
}

static void
cmd_loadBuffer(Buffer *buf, int prop, int link)
{
  if (buf == NULL) {
    disp_message("Can't load string",NIL);
  } else if (buf != NO_BUFFER) {
    buf->bufferprop |= (BP_INTERNAL | prop);
    if (!(buf->bufferprop & BP_NO_URL))
      copyParsedURL(&buf->currentURL,&Currentbuf->currentURL);
    if (link != LB_NOLINK) {
      buf->linkBuffer[REV_LB[link]] = Currentbuf;
      Currentbuf->linkBuffer[link] = buf;
    }
    pushBuffer(buf);
  }
  displayBuffer(Currentbuf, B_FORCE_REDRAW);
}

/* load bookmark */
void
ldBmark(void)
{
  cmd_loadURL(BookmarkFile, NULL);
}


/* Add current to bookmark */
void
adBmark(void)
{
  Str url,title,tmp;
  /*  cmd_loadBuffer(load_bookmark_panel(Currentbuf), BP_NO_URL, LB_NOLINK); */
  url = form_quote(parsedURL2Str(&Currentbuf->currentURL));
  title = form_quote(Strnew_charp(Currentbuf->buffername));
  tmp = Sprintf("%s/w3mbookmark?mode=panel&bmark=%s&url=%s&title=%s",
		LIB_DIR,BookmarkFile,url->ptr,title->ptr);
  cmd_loadURL(tmp->ptr,NULL);
}

/* option setting */
void
ldOpt(void)
{
  cmd_loadBuffer(load_option_panel(), BP_NO_URL, LB_NOLINK);
}

/* page info */
void
pginfo(void)
{
  Buffer *buf;

  if ((buf = Currentbuf->linkBuffer[LB_N_INFO]) != NULL) {
    Currentbuf = buf;
    displayBuffer(Currentbuf, B_NORMAL);
    return;
  }
  if ((buf = Currentbuf->linkBuffer[LB_INFO]) != NULL)
    delBuffer(buf);
  buf = page_info_panel(Currentbuf);
#ifdef JP_CHARSET
  if (buf != NULL)
    buf->document_code = Currentbuf->document_code;
#endif
  cmd_loadBuffer(buf, BP_NORMAL, LB_INFO);
}

void
follow_map(struct parsed_tagarg *arg)
{
  Buffer *buf;

  buf = follow_map_panel(Currentbuf, arg);
  if (buf != NULL)
    cmd_loadBuffer(buf, BP_NORMAL, LB_NOLINK);
}

#ifdef USE_COOKIE
/* cookie list */
void
cooLst(void)
{
  Buffer *buf;

  buf = cookie_list_panel();
  if (buf != NULL)
    cmd_loadBuffer(buf, BP_NO_URL, LB_NOLINK);
}
#endif

#ifdef USE_HISTORY
/* History page */
void
ldHist(void)
{
  cmd_loadBuffer(historyBuffer(URLHist), BP_NO_URL, LB_NOLINK);
}
#endif

/* download HREF link */
void
svA(void)
{
  do_download = T;
  followA();
  do_download = NIL;
}

/* download IMG link */
void
svI(void)
{
  do_download = T;
  followI();
  do_download = NIL;
}

/* save buffer */
void
svBuf(void)
{
  char           *file;
  FILE           *f;
  int             is_pipe;

  file = inputLineHist("Save buffer to: ", NULL, IN_COMMAND, SaveHist);
  if (file == NULL || *file == '\0') {
    displayBuffer(Currentbuf, B_FORCE_REDRAW);
    return;
  }
  if (*file == '|') {
    is_pipe = T;
    f = popen(file+1,"w");
  }
  else {
    file = expandName(file);
    if (checkOverWrite(file) < 0)
      return;
    f = fopen(file, "w");
    is_pipe = NIL;
  }
  if (f == NULL) {
    disp_message(Sprintf("Can't open %s\n", file)->ptr, T);
    return;
  }
  saveBuffer(Currentbuf, f);
  if (is_pipe)
    pclose(f);
  else
    fclose(f);
  displayBuffer(Currentbuf, B_NORMAL);
}

/* save source */
void
svSrc(void)
{
  char *defname = "file.html";
  if (Currentbuf->sourcefile == NULL)
    return;
  if (Currentbuf->currentURL.file != NULL)
    defname = mybasename(Currentbuf->currentURL.file);
  doFileCopy(Currentbuf->sourcefile,defname);
  displayBuffer(Currentbuf, B_NORMAL);
}

/* peek URL */
void
peekURL(void)
{
  Anchor         *a;
  ParsedURL      pu;
  Str             s;

  if (Currentbuf->firstLine == NULL)
    return;
  a = retrieveCurrentAnchor(Currentbuf);
  if (a == NULL) {
    a = retrieveCurrentImg(Currentbuf);
    if (a == NULL)
      return;
  }
  parseURL2(a->url,&pu,baseURL(Currentbuf));
  s = parsedURL2Str(&pu);
  disp_message(s->ptr,T);
}

/* show current URL */
void
curURL(void)
{
  Str s;

  if (Currentbuf->bufferprop & BP_INTERNAL)
    return;
  s = parsedURL2Str(&Currentbuf->currentURL);
  disp_message(s->ptr, T);
}


/* view HTML source */

void
vwSrc(void)
{
  Buffer         *buf;

  if (Currentbuf->type == NULL ||
      Currentbuf->bufferprop & BP_FRAME)
    return;
  if ((buf = Currentbuf->linkBuffer[LB_SOURCE]) != NULL ||
      (buf = Currentbuf->linkBuffer[LB_N_SOURCE]) != NULL) {
    Currentbuf = buf;
    displayBuffer(Currentbuf, B_NORMAL);
    return;
  }
  if (Currentbuf->sourcefile == NULL) {
    if (Currentbuf->pagerSource &&
	!strcasecmp(Currentbuf->type,"text/plain")) {
      FILE *f;
      Str tmpf = Sprintf("%s/w3mscr%d.%lx", rc_dir, getpid(),
			(unsigned long)Currentbuf);
      f = fopen(tmpf->ptr,"w");
      if (f == NULL)
	return;
      saveBuffer(Currentbuf, f);
      fclose(f);
      Currentbuf->sourcefile = tmpf->ptr;
    } else {
      return;
    }
  } 
  if (!strcasecmp(Currentbuf->type,"text/html")) {
    buf = loadFile(Currentbuf->sourcefile);
    if (buf == NULL)
      return;
    buf->type = "text/plain";
    buf->bufferprop |= BP_SOURCE;
    buf->buffername = Sprintf("source of %s", Currentbuf->buffername)->ptr;
    buf->linkBuffer[LB_N_SOURCE] = Currentbuf;
    Currentbuf->linkBuffer[LB_SOURCE] = buf;
  } else if (!strcasecmp(Currentbuf->type,"text/plain")) {
    char *old_type = DefaultType;
    DefaultType = "text/html";
    buf = loadGeneralFile(Currentbuf->sourcefile, NULL,NO_REFERER,0,NULL);
    DefaultType = old_type;
    if (buf == NULL)
      return;
    if (!strcmp(buf->buffername, mybasename(Currentbuf->sourcefile)))
      buf->buffername = Sprintf("HTML view of %s", Currentbuf->buffername)->ptr;
    buf->linkBuffer[LB_SOURCE] = Currentbuf;
    Currentbuf->linkBuffer[LB_N_SOURCE] = buf;
  } else {
    return;
  }
  buf->currentURL = Currentbuf->currentURL;
  buf->real_scheme = Currentbuf->real_scheme;
  buf->sourcefile = Currentbuf->sourcefile;
  buf->clone = Currentbuf->clone;
  (*buf->clone)++;
  pushBuffer(buf);
  displayBuffer(Currentbuf, B_NORMAL);
}

/* reload */
void
reload(void)
{
  Buffer *buf, *fbuf = NULL;
  Str url;
  int linenum, is_frame, is_source;
  FormList *request;
  int multipart;

  if (Currentbuf->bufferprop & BP_INTERNAL) {
    disp_message("Can't reload...", NIL);
    return;
  }
  if (Currentbuf->currentURL.scheme == SCM_LOCAL &&
      !strcmp(Currentbuf->currentURL.file,"-")) {
    /* file is std input */
    disp_message("Can't reload stdin",T);
    return;
  }
  is_frame = Currentbuf->bufferprop & BP_FRAME;
  if (is_frame)
    fbuf = Currentbuf->linkBuffer[LB_N_FRAME];
  else if (Currentbuf->frameset != NULL)
    fbuf = Currentbuf->linkBuffer[LB_FRAME];
  is_source = Currentbuf->bufferprop & BP_SOURCE;
  if (Currentbuf->firstLine == NULL)
    linenum = 1;
  else
    linenum = Currentbuf->currentLine->linenumber;
  multipart = 0;
  if (Currentbuf->form_submit) {
    request = Currentbuf->form_submit->parent;
    if (request->method == FORM_METHOD_POST
	&& request->enctype == FORM_ENCTYPE_MULTIPART)
    {
      Str query;
      struct stat st;
      multipart = 1;
      query_from_followform(&query, Currentbuf->form_submit, multipart);
      stat(request->body, &st);
      request->length = st.st_size;
    }
  } else {
    request = NULL;
  }
  url = parsedURL2Str(&Currentbuf->currentURL);
  message("Reloading...",0,0);
  refresh();
  buf = loadGeneralFile(url->ptr, NULL,NO_REFERER,RG_NOCACHE,request);
  if (multipart)
    unlink(request->body);
  if (buf == NULL) {
    disp_message("Can't reload...", NIL);
    return;
  }
  buf->form_submit = Currentbuf->form_submit;
  if (fbuf != NULL)
    Firstbuf = deleteBuffer(Firstbuf, fbuf);
  repBuffer(Currentbuf, buf);
  if (is_source) {
    vwSrc();
    if (Currentbuf != buf)
      Firstbuf = deleteBuffer(Firstbuf, buf);
  } else if (is_frame && buf->frameset != NULL) {
    rFrame();
  }
  gotoLine(Currentbuf,linenum);
  arrangeCursor(Currentbuf);
  displayBuffer(Currentbuf, B_NORMAL);
}

/* mark URL-like patterns as anchors */
void
chkURL(void)
{
  static char    *url_like_pat[] = {
    "http://[a-zA-Z0-9][a-zA-Z0-9:%\\-\\./?=~_\\&+@#,]*",
#ifdef USE_SSL
    "https://[a-zA-Z0-9][a-zA-Z0-9:%\\-\\./?=~_\\&+@#,]*",
#endif
    "gopher://[a-zA-Z0-9][a-zA-Z0-9:%\\-\\./_]*",
    "ftp://[a-zA-Z0-9][a-zA-Z0-9%\\-\\./_+:@]*",
    "news:[^<> 	][^<> 	]*",
    NULL,
  };
  int             i;
  for (i = 0; url_like_pat[i]; i++) {
    reAnchor(Currentbuf, url_like_pat[i]);
  }

  displayBuffer(Currentbuf, B_FORCE_REDRAW);
}

/* mark Message-ID-like patterns as NEWS anchors */
void
chkNMID(void)
{
  static char    *url_like_pat[] = {
    "<[^<> 	][^<> 	]*@[A-z0-9\\.\\-_][A-z0-9\\.\\-_]*>",
    NULL,
  };
  int             i;
  for (i = 0; url_like_pat[i]; i++) {
    reAnchorNews(Currentbuf, url_like_pat[i]);
  }

  displayBuffer(Currentbuf, B_FORCE_REDRAW);
}

/* render frame */
void
rFrame(void)
{
  Buffer *buf;

  if ((buf = Currentbuf->linkBuffer[LB_FRAME]) != NULL) {
    Currentbuf = buf;
    displayBuffer(Currentbuf, B_NORMAL);
    return;
  }
  if (Currentbuf->frameset == NULL) {
    if ((buf = Currentbuf->linkBuffer[LB_N_FRAME]) != NULL) {
      Currentbuf = buf;
      displayBuffer(Currentbuf, B_NORMAL);
    }
    return;
  }
  if (fmInitialized) {
    message("Rendering frame",0,0);
    refresh();
  }
  buf = renderFrame(Currentbuf);
  if (buf == NULL)
    return;
  buf->linkBuffer[LB_N_FRAME] = Currentbuf;
  Currentbuf->linkBuffer[LB_FRAME] = buf;
  pushBuffer(buf);
  if (fmInitialized && display_ok)
    displayBuffer(Currentbuf, B_FORCE_REDRAW);
}
  
/* spawn external browser */
static void 
invoke_browser(char *url)
{
  Str tmp;
  char *browser = NULL;
  int bg = 0;

  switch (prec_num) {
  case 0: case 1:
    browser = ExtBrowser;
    break;
  case 2:
    browser = ExtBrowser2;
    break;
  case 3:
    browser = ExtBrowser3;
    break;
  }
  if (browser == NULL || *browser == '\0') {
    tmp = Strnew_charp(inputStr("Browse cmd:",url));
  }
  else if (strcasestr(browser,"%s")) {
    tmp = Sprintf(browser,url);
  }
  else {
    tmp = Strnew_charp(browser);
    Strcat_char(tmp,' ');
    Strcat_charp(tmp,url);
  }
  Strremovetrailingspaces(tmp);
  if (Strlastchar(tmp) == '&') {
    Strshrink(tmp,1);
    bg = 1;
  }
  fmTerm();
  mySystem(tmp->ptr,bg);
  fmInit();
  displayBuffer(Currentbuf, B_FORCE_REDRAW);
}

void extbrz()
{
  if (Currentbuf->bufferprop & BP_INTERNAL) {
    disp_message("Can't browse...", NIL);
    return;
  }
  if (Currentbuf->currentURL.scheme == SCM_LOCAL &&
      !strcmp(Currentbuf->currentURL.file,"-")) {
    /* file is std input */
    disp_message("Can't browse stdin",T);
    return;
  }
  invoke_browser(parsedURL2Str(&Currentbuf->currentURL)->ptr);
}

void linkbrz()
{
  Anchor *a;
  ParsedURL      pu;

  if (Currentbuf->firstLine == NULL)
    return;
  a = retrieveCurrentAnchor(Currentbuf);
  if (a == NULL)
    return;
  parseURL2(a->url,&pu,baseURL(Currentbuf));
  invoke_browser(parsedURL2Str(&pu)->ptr);  
}

/* show current line number and number of lines in the entire document */
void curlno()
{
  Str tmp;
  int cur = 0, all;
  if (Currentbuf->currentLine != NULL)
    cur = Currentbuf->currentLine->linenumber;
  all = Currentbuf->allLine;
  if (all == 0 && Currentbuf->lastLine != NULL) 
    all = Currentbuf->lastLine->linenumber;
  if (all == 0)
    all = 1;
#ifdef JP_CHARSET
  tmp = Sprintf("line %d/%d (%d%%) code %c",cur,all,cur*100/all,
                Currentbuf->document_code);
#else
  tmp = Sprintf("line %d/%d (%d%%)",cur,all,cur*100/all);
#endif
                
  disp_message(tmp->ptr,NIL);
}

#ifdef MOUSE
/* Addition:mouse event */
#define MOUSE_BTN1_DOWN 0
#define MOUSE_BTN2_DOWN 1
#define MOUSE_BTN3_DOWN 2
#define MOUSE_BTN_UP 3


static void
process_mouse(int btn, int x, int y)
{
  int i, delta_x, delta_y;
  static int press_btn, press_x, press_y;

  if (btn == MOUSE_BTN_UP) {
    switch (press_btn) {
      case MOUSE_BTN1_DOWN:
	if (press_x != x || press_y != y) {
	  delta_x = x - press_x;
	  delta_y = y - press_y;

	  if (abs(delta_x) < abs(delta_y) / 3)
	    delta_x = 0;
	  if (abs(delta_y) < abs(delta_x) / 3)
	    delta_y = 0;
	  
	  if (delta_y > 0) {
	    prec_num = delta_y;
            if(reverse_mouse) lup1();
              else ldown1();
	  } else if (delta_y < 0) {
	    prec_num = -delta_y;
            if(reverse_mouse) ldown1();
              else lup1();
	  }

	  if (delta_x > 0) {
	    for (i = 0; i < delta_x; i++)
              if(reverse_mouse) col1L();
              else col1R();
	  } else if (delta_x < 0) {
	    for (i = 0; i < -delta_x; i++)
              if(reverse_mouse) col1R();
              else col1L();
	  }
	} else {
	  if (y == LASTLINE) {
	    switch (x) {
	    case 0: case 1:
	      backBf();
	      break;
	    case 2: case 3:
	      pgBack();
	      break;
	    case 4: case 5:
	      pgFore();
	      break;
	    }
	    return;
	  }
	  if (y == Currentbuf->cursorY && 
	      (x == Currentbuf->cursorX 
#ifdef JP_CHARSET
	       || ((Currentbuf->currentLine->propBuf[Currentbuf->pos] & PC_KANJI1)
		    && x == Currentbuf->cursorX + 1)
#endif
	       )) {
	    followA();
	    return;
	  }

	  cursorXY(Currentbuf, x, y);
	  displayBuffer(Currentbuf, B_NORMAL);
	  
	}
	break;
      case MOUSE_BTN2_DOWN:
	backBf();
        break;
      case MOUSE_BTN3_DOWN:
#ifdef MENU
	cursorXY(Currentbuf, x, y);
	onA();
	mainMenu(x, y);
#endif
	break;
    }
  } else {
    press_btn = btn;
    press_x = x;
    press_y = y;
  }
}

void msToggle( void )
{
  if (use_mouse) {
    use_mouse = NIL;
  } else {
    use_mouse = T;
  }
  displayBuffer(Currentbuf,B_FORCE_REDRAW);
}

void mouse()
{
  int btn, x, y;

  btn = (unsigned char)getch() - 32;
  x = (unsigned char)getch() - 33;
  if (x < 0) x += 0x100;
  y = (unsigned char)getch() - 33;
  if (y < 0) y += 0x100;

  if (Currentbuf->firstLine == NULL)
	return;
  if (x < 0 || x >= COLS || y < 0 || y > LASTLINE)
    return;
  process_mouse(btn,x,y);
}

#ifdef USE_GPM
int gpm_process_mouse(Gpm_Event *event, void *data)
{
  int btn,x,y;
  if (event->type&GPM_UP)
    btn = MOUSE_BTN_UP;
  else if (event->type&GPM_DOWN) {
    switch (event->buttons) {
    case GPM_B_LEFT:   btn=MOUSE_BTN1_DOWN; break;
    case GPM_B_MIDDLE: btn=MOUSE_BTN2_DOWN; break;
    case GPM_B_RIGHT:  btn=MOUSE_BTN3_DOWN; break;
    }
  }
  else {
    GPM_DRAWPOINTER(event);
    return 0;
  }
  x = event->x;
  y = event->y;
  process_mouse(btn, x-1, y-1);
  return 0;
}
#endif
#endif

void wrapToggle( void )
{
  if (WrapSearch) {
    WrapSearch = NIL;
    disp_message("Wrap search off", NIL);
  } else {
    WrapSearch = T;
    disp_message("Wrap search on", NIL);
  }
}

#ifdef DICT
static char *
GetWord(Buffer *buf)
{
  Line     *l = buf->currentLine;
  char     *lb = l->lineBuf;
  int      i,b,e,pos = buf->pos;

  i=pos;
  while(!isalpha(lb[i]) && i >= 0) i--;
  pos=i;
  while(isalpha(lb[i]) && i >= 0) i--;
  i++;
  if (!isalpha(lb[i])) return NULL;
  b=i; i=pos;
  while(isalpha(lb[i]) && i <= l->len -1) i++;
  e=i-1;
  return Strnew_charp_n(&lb[b], e-b+1)->ptr;
}

static void
execdict(char *word)
{
  Buffer         *buf;
  Str             cmd, bn;
  MySignalHandler(*prevtrap) ();

  if (word == NULL || *word == '\0') {
    displayBuffer(Currentbuf, B_NORMAL);
    return;
  }
  cmd = Strnew_charp(DICTCMD);
  Strcat_char(cmd, ' ');
  Strcat_charp(cmd, word);
  prevtrap = signal(SIGINT, intTrap);
  crmode();
  buf = getshell(cmd->ptr);
  bn = Sprintf ("%s %s", DICTBUFFERNAME, word);
  buf->buffername = bn->ptr;
  buf->filename = word;
  signal(SIGINT, prevtrap);
  term_raw();
  if (buf == NULL) {
    disp_message("Execution failed",NIL);
  } else if (buf->firstLine == NULL) {
    /* if the dictionary doesn't describe the word. */
    disp_message(Sprintf("Word \"%s\" Not Found",word)->ptr,NIL);
  } else {
    buf->bufferprop |= (BP_INTERNAL | BP_NO_URL);
    pushBuffer(buf);
  }
  displayBuffer(Currentbuf, B_FORCE_REDRAW);
}

void
dictword(void)
{
  execdict(inputStr("(dictionary)!", ""));
}

void
dictwordat(void)
{
  execdict(GetWord(Currentbuf));
}
#endif
