/*
 * w3m local.h
 */

#ifndef LOCAL_H
#define LOCAL_H

#include <sys/types.h>
#ifdef DIRENT
#include <dirent.h>
typedef struct dirent Directory;
#else
#include <sys/dir.h>
typedef struct direct Directory;
#endif
#include <sys/stat.h>

#ifndef S_IFMT
#define S_IFMT  0170000
#endif
#ifndef S_IFREG
#define S_IFREG 0100000
#endif

#define NOT_REGULAR(m)	(((m) & S_IFMT) != S_IFREG)

#ifndef S_ISDIR
#ifndef S_IFDIR
#define S_IFDIR 0040000
#endif
#define S_ISDIR(m)	(((m) & S_IFMT) == S_IFDIR)
#endif

#ifdef READLINK
#ifndef S_IFLNK
#define S_IFLNK 0120000
#endif
#ifndef S_ISLNK
#define S_ISLNK(m)	(((m) & S_IFMT) == S_IFLNK)
#endif
#endif

#endif
