#include "fm.h"
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#ifdef READLINK
#include <unistd.h>
#endif
#include "pq.h"
#include "local.h"

#define CGIFN_NORMAL     0
#define CGIFN_DROOT      1
#define CGIFN_CGIBIN     2

Buffer *
dirBuffer(char *dname)
{
  Str tmp;
  DIR *d;
  Directory *dir;
  struct stat st;
  PriorityQueue *pq;
  char *p, *qdir, *q;
  char fbuf[1024];
#ifdef READLINK
  struct stat lst;
  char lbuf[1024];
#endif
  int l, nrow, n = 0, maxlen = 0;
  Str dirname;

  dirname = Strnew_charp(dname);
  d = opendir(dirname->ptr);
  if (d == NULL)
    return NULL;
  qdir = htmlquote_str(dirname->ptr);
  tmp = Sprintf("<title>Directory list of %s</title><h1>Directory list of %s</h1>\n",qdir,qdir);
  pq = PQ_new(100,string_alphabetical);
  while ((dir = readdir(d)) != NULL) {
    PQ_push(pq,(void*)allocStr(dir->d_name,0));
    if (multicolList) {
      l = strlen(dir->d_name);
      if (l > maxlen)
        maxlen = l;
      n++;
    }
  }
  
  if (multicolList) {
    l = COLS / (maxlen + 2);
    if (! l) l = 1;
    nrow = (n + l - 1) / l;
    n = 1;
    Strcat_charp(tmp,"<TABLE><TR>\n");
  }
  while ((p = (char*)PQ_pop(pq)) != NULL) {
    if (strcmp(p, ".") == 0)
      continue;
    if (Strlastchar(dirname) == '/')
      sprintf(fbuf,"%s%s",dirname->ptr,p);
    else
      sprintf(fbuf,"%s/%s",dirname->ptr,p);
#ifdef READLINK
    if (lstat(fbuf,&lst) < 0)
      continue;
#endif
    if (stat(fbuf,&st) < 0)
      continue;
    if (multicolList) {
      if (n == 1)
        Strcat_charp(tmp,"<TD>");
    } else {
      if (S_ISDIR(st.st_mode))
	Strcat_charp(tmp,"[DIR]&nbsp; ");
#ifdef READLINK
      else if (S_ISLNK(lst.st_mode))
	Strcat_charp(tmp,"[LINK] ");
#endif
      else
	Strcat_charp(tmp,"[FILE] ");
    }
    q = htmlquote_str(p);
    Strcat_charp(tmp,"<A HREF=\"file://");
    Strcat_charp(tmp,qdir);
    if (dirname->ptr[dirname->length - 1] != '/')
      Strcat_char(tmp,'/');
    Strcat_charp(tmp,q);
    if (S_ISDIR(st.st_mode))
      Strcat_char(tmp,'/');
    Strcat_charp(tmp,"\">");
    Strcat_charp(tmp,q);
    if (S_ISDIR(st.st_mode))
      Strcat_char(tmp,'/');
    Strcat_charp(tmp,"</a>");
    if (multicolList) {
      if (n++ == nrow) {
	Strcat_charp(tmp,"</TD>\n");
	n = 1;
      } else {
	Strcat_charp(tmp,"<BR>\n");
      }
    } else {
#ifdef READLINK
      if (S_ISLNK(lst.st_mode)) {
	if ((l = readlink(fbuf, lbuf, 1024)) > 0) {
	  lbuf[l] = '\0';
	  Strcat_charp(tmp," -> ");
	  Strcat_charp(tmp,htmlquote_str(lbuf));
	  if (S_ISDIR(st.st_mode))
	    Strcat_char(tmp,'/');
	}
      }
#endif
    Strcat_charp(tmp,"<br>\n");
    }
  }
  if (multicolList) {
    Strcat_charp(tmp,"</TR></TABLE>\n");
  }

  return loadHTMLString(tmp->ptr);
}

static int
check_local_cgi(char *file, int status)
{
  struct stat st;

  if (status != CGIFN_CGIBIN &&
      strncmp(file,LIB_DIR,strlen(LIB_DIR)) != 0) {
    /*
     * a local-CGI script should be located on either
     * /cgi-bin/ directory or LIB_DIR (typically /usr/local/lib/w3m).
     */
    return -1;
  }
  if (stat(file,&st) < 0)
    return -1;
  if ((st.st_uid == geteuid() && (st.st_mode & S_IXUSR)) ||
      (st.st_gid == getegid() && (st.st_mode & S_IXGRP)) ||
      (st.st_mode & S_IXOTH)) { /* executable */
    return 0;
  }
  return -1;
}

void
set_environ(char *var, char *value)
{
#ifdef HAVE_SETENV
  setenv(var,value,1);
#else
#ifdef HAVE_PUTENV
  Str tmp = Strnew_charp(var);
  Strcat_char(tmp,'=');
  Strcat_charp(tmp,value);
  putenv(tmp->ptr);
#else
  extern char **environ;
  char **ne;
  char *p;
  int i,l,el;
  char **e,**newenv;

  /* I have no setenv() nor putenv() */
  /* This part is taken from terms.c of skkfep */
  l = strlen(var);
  for (e = environ, i = 0; *e != NULL; e++,i++) {
    if (strncmp(e,var,l) == 0 && (*e)[l] == '=') {
      el = strlen(*e)-l-1;
      if (el >= strlen(value)) {
	strcpy(*e+l+1,value);
	return 0;
      }
      else {
	for (; *e != NULL; e++,i++) {
	  *e = *(e+1);
	}
	i--;
	break;
      }
    }
  }
  newenv = (char**)GC_malloc((i+2)*sizeof(char*));
  if (newenv == NULL)
    return;
  for (e = environ, ne = newenv; *e != NULL; *(ne++) = *(e++));
  *(ne++) = p;
  *ne = NULL;
  environ = newenv;
#endif /* HAVE_PUTENV */
#endif /* HAVE_SETENV */
}

static void
set_cgi_environ()
{
  set_environ("SERVER_SOFTWARE",version);
  set_environ("SERVER_PROTOCOL","HTTP/1.0");
  set_environ("REMOTE_HOST","localhost");
  set_environ("REMOTE_ADDR","127.0.0.1");
  set_environ("SERVER_PORT","80"); /* dummy */
}

static Str
checkPath(char *fn,char *path)
{
  Str tmp;
  struct stat st;
  while (*path) {
    tmp = Strnew();
    while (*path && *path != ':')
      Strcat_char(tmp,*path++);
    if (*path == ':')
      path++;
    if (Strlastchar(tmp) != '/')
      Strcat_char(tmp,'/');
    Strcat_charp(tmp,fn);
    if (stat(tmp->ptr,&st) == 0)
      return tmp;
  }
  return NULL;
}

static char*
cgi_filename(char *fn,int *status)
{
  Str tmp;
  struct stat st;
  if (cgi_bin != NULL && strncmp(fn,"/cgi-bin/",9) == 0) {
    *status = CGIFN_CGIBIN;
    tmp = checkPath(fn+9,cgi_bin);
    if (tmp == NULL)
      return fn;
    return tmp->ptr;
  }
  if (strncmp(fn,"/$LIB/",6) == 0) {
    *status = CGIFN_NORMAL;
    tmp = Strnew_charp(LIB_DIR);
    fn += 5;
    if (Strlastchar(tmp) == '/')
      fn++;
    Strcat_charp(tmp,fn);
    return tmp->ptr;
  }
  if (*fn == '/' && document_root != NULL && stat(fn,&st) < 0) {
    *status = CGIFN_DROOT;
    tmp = Strnew_charp(document_root);
    if (Strlastchar(tmp) != '/')
      Strcat_char(tmp,'/');
    Strcat_charp(tmp,fn);
    return tmp->ptr;
  }
  *status = CGIFN_NORMAL;
  return fn;
}

FILE *
localcgi_post(char *file, FormList *request)
{
  FILE *f;
  Str tmp1,tmp2;
  int status;

  file = cgi_filename(file,&status);
  if (check_local_cgi(file,status) < 0)
    return NULL;
  set_cgi_environ();
  set_environ("REQUEST_METHOD","POST");
  set_environ("CONTENT_LENGTH",Sprintf("%d",request->length)->ptr);
  if (request->enctype == FORM_ENCTYPE_MULTIPART) {
    set_environ("CONTENT_TYPE",
      Sprintf("multipart/form-data; boundary=%s",request->boundary)->ptr);
  } else {
    set_environ("CONTENT_TYPE","application/x-www-form-urlencoded");
  }
  tmp1 = Sprintf("%s/w3mcgitmp%d",rc_dir,getpid());
  f = fopen(tmp1->ptr,"w");
  if (f == NULL)
    return NULL;
  pushText(fileToDelete,tmp1->ptr);
  if (request->enctype == FORM_ENCTYPE_MULTIPART) {
    FILE *fd;
    int c;
    fd = fopen(request->body, "r");
    if (fd != NULL) {
      while((c = fgetc(fd)) != EOF)
	fputc(c,f);
      fclose(fd);
    }
  } else {
    fputs(request->body,f);
  }
  fclose(f);
  tmp2 = Sprintf("%s < %s",file,tmp1->ptr);
  return popen(tmp2->ptr,"r");
}

FILE *
localcgi_get(char *file, char *request)
{
  int status;

  file = cgi_filename(file,&status);
  if (check_local_cgi(file,status) < 0)
    return NULL;
  set_cgi_environ();
  set_environ("REQUEST_METHOD","GET");
  set_environ("QUERY_STRING",request);
  return popen(file,"r");
}


    
