/* $Id: linein.c,v 1.3 2000/01/21 07:58:41 aito Exp $ */
#include "fm.h"
#include "local.h"
#include "myctype.h"

#ifdef USE_GPM
#include <gpm.h>
extern int do_getch();
#define getch()	do_getch()
#endif

#define STR_LEN	256

static char     strBuf[STR_LEN];
static Lineprop strProp[STR_LEN];

static char     CompleteBuf[STR_LEN];
static char     CFileName[STR_LEN];
static char     CBeforeBuf[STR_LEN];
static char     CAfterBuf[STR_LEN];
static char     CDirBuf[STR_LEN];
static char     **CFileBuf = NULL;
static int      NCFileBuf;
static int      NCFileOffset;

static
void            insertself(char c), _mvR(void), _mvL(void), delC(void),
                insC(void), _mvB(void), _mvE(void),
                _enter(void), _quo(void), _bs(void), killn(void), killb(void),
                _inbrk(void),
                _esc(void), _prev(void), _next(void),
                _compl(void), _rcompl(void), _tcompl(void);

#define iself ((void(*)())insertself)

static
void            next_compl(int next);
static
char           *doComplete(char *ifn, int *status, int next);

void            (*InputKeymap[32]) () = {
/* C-@		C-a	C-b	C-c	C-d	C-e	C-f	C-g	*/
   _compl,	_mvB,	_mvL,	_inbrk,	delC,	_mvE,	_mvR,	_inbrk,
/* C-h		C-i	C-j	C-k	C-l	C-m	C-n	C-o	*/
   _bs,		iself,	_enter,	killn,	iself,	_enter,	_next,	iself,
/* C-p		C-q	C-r	C-s	C-t	C-u	C-v	C-w	*/
   _prev,	_quo,	iself,	iself,	iself,	killb,	_quo,	iself,
/* C-x		C-y	C-z	C-[	C-\	C-]	C-^	C-_	*/
   _tcompl,	iself,	iself,	_esc,	iself,	iself,	iself,	iself,
};

static int     strCmp(const void *s1, const void *s2);
static void    setStrType(char *str, Lineprop *prop);

static int      CPos, CLen;
static int     i_cont, i_broken, i_quote;
static int     cm_mode, cm_next, cm_clear;

static Hist    *CurrentHist;
static int     use_hist;
static int     in_kanji;

char           *
inputLineHist(char *prompt, char *def_str, int flag, Hist *hist)
{
  int             i, opos, offset, x;
  char            c, *p;
  int            redrawOK;
  Lineprop        mode;
#ifdef JP_CHARSET
  Str             tmp = Strnew();
#endif

  mode = PC_ASCII;
  in_kanji = NIL;

  CurrentHist = hist;
  if (hist != NULL)
    use_hist = T;
  else
    use_hist = NIL;
  if (flag & IN_FILENAME)
    cm_mode = CPL_ALWAYS;
  else if (flag & IN_PASSWORD)
    cm_mode = CPL_NEVER;
  else if (flag & IN_COMMAND)
    cm_mode = CPL_ON;
  else
    cm_mode = CPL_OFF;
  opos = strlen(prompt);
  move(LASTLINE, 0);
  addstr(prompt);
  i = 0;
  if (def_str) {
    strcpy(strBuf, def_str);
    setStrType(strBuf, strProp);
    for (; strBuf[i] != '\0'; i++) {
      if (flag & IN_PASSWORD)
        addChar('*', 0);
      else
        addChar(strBuf[i], strProp[i]);
    }
  }
  clrtoeolx();
  refresh();
  strBuf[i] = '\0';
  CLen = CPos = i;
  offset = 0;
  i_cont = T;
  i_broken = NIL;
  i_quote = NIL;
  cm_next = NIL;
  do {
    c = getch();
    redrawOK = T;
    cm_clear = T;
    if (!i_quote &&
 	(((cm_mode & CPL_ALWAYS) && (c == CTRL_I || c == ' ')) ||
 	 ((cm_mode & CPL_ON)     && (c == CTRL_I))) ) {
      _compl();
    } else if (!(c & ~0x1f)) {		/* Control code */
      if (!i_quote)
        (*InputKeymap[(int)c]) (c);
      else {
	insertself(c);
	i_quote = NIL;
      }
      if (cm_clear)
	cm_next = NIL;
    } else if (c == 0177) {	
      if (!i_quote)
	_bs();
      else
	insertself(c);
      i_quote = NIL;
      cm_next = NIL;
#ifdef JP_CHARSET
    } else if (mode == PC_KANJI1) {
      i_quote = NIL;
      cm_next = NIL;
      if (CLen >= STR_LEN)
	continue;
      Strcat_char(tmp, (c | (DisplayCode == 'S' ? 0 : 0x80)));
      tmp = conv(tmp->ptr, (DisplayCode == 'S' ? 'S' : 'E'), InnerCode);
      insC();
      strBuf[CPos] = tmp->ptr[0];
      strProp[CPos] = PC_KANJI1;
      CPos++;
      insC();
      strBuf[CPos] = tmp->ptr[1];
      strProp[CPos] = PC_KANJI2;
      CPos++;
      mode = PC_KANJI2;
    } else if ((c & 0x80) || in_kanji) {	/* Kanji 1 */
      i_quote = NIL;
      cm_next = NIL;
      if (CLen >= STR_LEN - 1)
	continue;
      Strclear(tmp);
      Strcat_char(tmp, (c | 0x80));
      mode = PC_KANJI1;
      redrawOK = NIL;
#endif
    } else {
      i_quote = NIL;
      cm_next = NIL;
      if (CLen >= STR_LEN)
	continue;
      insC();
      strBuf[CPos] = c;
      strProp[CPos] = PC_ASCII;
      CPos++;
      mode = PC_ASCII;
    }
    if (redrawOK) {
      if (CPos - offset < 10)
	offset = (CPos > 10) ? (CPos - 10) : 0;
      if (flag & IN_PASSWORD) {
	x = opos + (offset > 0) + CPos - offset;
	if (x > COLS - 2) {
	  offset = opos + 1 + CPos - COLS + 2;
	  x = COLS - 2;
	}
      } else {
	x = calcPosition(&strBuf[offset], CPos - offset, opos + (offset > 0), CP_FORCE);
        while (x > COLS - 2) {
	  offset += x - COLS + 2;
	  if (offset >= CPos)
	    offset = CPos - 1;
	  x = calcPosition(&strBuf[offset], CPos - offset, opos + 1, CP_FORCE);
        }
      }
      move(LASTLINE, 0);
      addstr(prompt);
      i = offset;
      if (offset) {
        addstr("{");
#ifdef JP_CHARSET
	if (strProp[offset] == PC_KANJI2 && !(flag & IN_PASSWORD)) {
          addstr(" ");
	  i++;
	}
#endif
      }
      for (; strBuf[i] != '\0'; i++) {
        if (flag & IN_PASSWORD)
          addChar('*',0);
        else
	  addChar(strBuf[i], strProp[i]);
      }
      clrtoeolx();
      move(LASTLINE, x);
      refresh();
    }
  } while (i_cont);
  if (use_hist)
    hist->position = (hist->offset + 1) % hist->size;
  if (i_broken)
    return NULL;
  move(LASTLINE, 0);
  refresh();
  p = strBuf;
  if (flag & (IN_FILENAME | IN_COMMAND)) {
    while(*p && IS_SPACE(*p))
      p++;
  }
  if (use_hist) {
    if (strcmp(hist->line[hist->offset], p))
      addHist(hist, p);
  }
  if (flag & IN_FILENAME)
    return expandName(p);
  else
    return allocStr(p,0);
}

static void
_esc(void)
{
  char c,c2;

  switch(c = getch()) {
  case '[':
  case 'O':
    switch(c = getch()) {
    case 'A':
      _prev();
      break;
    case 'B':
      _next();
      break;
    case 'C':
      _mvR();
      break;
    case 'D':
      _mvL();
      break;
    }
    break;
  case CTRL_I:
  case ' ':
    _rcompl();
    break;
  case '$':
    /* ISO-2022-jp characters */
    c2 = getch();
    in_kanji = T; 
    break;
  case '(':
    /* ISO-2022-jp characters */
    c2 = getch();
    in_kanji = NIL;
    break;
  }
}

static void
insC(void)
{
  int             i;

  for (i = CLen; i > CPos; i--) {
    strBuf[i] = strBuf[i - 1];
    strProp[i] = strProp[i - 1];
  }
  strBuf[++CLen] = '\0';
}

static void
delC(void)
{
  int             i = CPos;
  int             delta = 1;

  if (CLen == CPos) return;
#ifdef JP_CHARSET
  if (strProp[i] == PC_KANJI1)
    delta = 2;
#endif
  for (i = CPos; i < CLen; i++) {
    strBuf[i] = strBuf[i + delta];
    strProp[i] = strProp[i + delta];
  }
  CLen -= delta;
}

static void
_mvL(void)
{
  if (CPos > 0)
    CPos--;
#ifdef JP_CHARSET
  if (strProp[CPos] == PC_KANJI2)
    CPos--;
#endif
}

static void
_mvR(void)
{
  if (CPos < CLen)
    CPos++;
#ifdef JP_CHARSET
  if (strProp[CPos] == PC_KANJI2)
    CPos++;
#endif
}

static void
_bs(void)
{
  if (CPos > 0) {
    _mvL();
    delC();
  }
}

static void
_enter(void)
{
  i_cont = NIL;
}

static void
insertself(char c)
{
  if (CLen >= STR_LEN)
    return;
  insC();
  strBuf[CPos] = c;
  strProp[CPos] = PC_CTRL;
  CPos++;
}

static void
_quo(void)
{
  i_quote = T;
}

static void
_mvB(void)
{
  CPos = 0;
}

static void
_mvE(void)
{
  CPos = CLen;
}

static void
killn(void)
{
  CLen = CPos;
  strBuf[CLen] = '\0';
}

static void
killb(void)
{
  while (CPos > 0)
    _bs();
}

static void
_inbrk(void)
{
  i_cont = NIL;
  i_broken = T;
}

static void
_compl(void)
{
  next_compl(1);
}

static void
_rcompl(void)
{
  next_compl(-1);
}

static void
_tcompl(void)
{
  if (cm_mode & CPL_OFF)
    cm_mode = CPL_ON;
  else if (cm_mode & CPL_ON)
    cm_mode = CPL_OFF;
}

static void
next_compl(int next)
{
  int            status;
  int            b, a;
  char           buf[STR_LEN];
  char           *s;

  if (cm_mode == CPL_NEVER || cm_mode & CPL_OFF)
    return;
  cm_clear = NIL;
  if (!cm_next) {
    for(b = CPos - 1; b >= 0; b--) {
      if (strBuf[b] == ' ' || strBuf[b] == CTRL_I)
	break;
    }
    b++;
    a = CPos;
    strncpy(CBeforeBuf, strBuf, b);
    CBeforeBuf[b] = '\0';
    strncpy(buf, &strBuf[b], a-b);
    buf[a-b] = '\0';
    strcpy(CAfterBuf, &strBuf[a]);
    s = doComplete(buf, &status, next);
  } else {
    s = doComplete(strBuf, &status, next);
  }

  if (status != CPL_OK && status != CPL_MENU)
    bell();
  if (status == CPL_FAIL)
    return;
  if (strlen(CBeforeBuf) + strlen(s) + strlen(CAfterBuf) >= STR_LEN) {
    bell();
    return;
  }
  strcpy(strBuf, CBeforeBuf);
  strcat(strBuf, s);
  CPos = strlen(strBuf);
  strcat(strBuf, CAfterBuf);
  CLen = strlen(strBuf);
  setStrType(strBuf, strProp);
}

static char    *
doComplete(char *ifn, int *status, int next)
{
  int             l, fl, i;
  char           *fn;
  DIR            *d;
  Directory      *dir;
  struct stat     st;

if (! cm_next) {
  copydicname(CompleteBuf, ifn);
  strcpy(CDirBuf, CompleteBuf);
  l = strlen(CompleteBuf);
  if (l == 0) {
    CompleteBuf[0] = '.';
    CompleteBuf[1] = '\0';
    l = 1;
  }
  if (l > 1 && CompleteBuf[l - 1] == '/') {
    CompleteBuf[--l] = '\0';
  }
  if ((d = opendir(expandName(CompleteBuf))) == NULL) {
    strcpy(CompleteBuf, ifn);
    *status = CPL_FAIL;
    return CompleteBuf;
  }
  fn = lastFileName(ifn);
  fl = strlen(fn);
  NCFileBuf = 0;
  CFileName[0] = '\0';
  for (;;) {
    dir = readdir(d);
    if (dir == NULL)
      break;
    if (fl == 0 && (!strcmp(dir->d_name, ".") || !strcmp(dir->d_name, "..")))
      continue;
    if (!strncmp(dir->d_name, fn, fl)) {	/* match */
      NCFileBuf++;
      CFileBuf = New_Reuse(char *, CFileBuf, NCFileBuf);
      CFileBuf[NCFileBuf - 1] = New_N(char, strlen(dir->d_name) + 1);
      strcpy(CFileBuf[NCFileBuf - 1], dir->d_name);
      if (NCFileBuf == 1) {
	strncpy(CFileName, dir->d_name, STR_LEN);
      } else {
	for (i = 0; CFileName[i] == dir->d_name[i]; i++);
	CFileName[i] = '\0';
      }
    }
  }
  closedir(d);
  if (NCFileBuf == 0) {
    strcpy(CompleteBuf, ifn);
    *status = CPL_FAIL;
    return CompleteBuf;
  }
  qsort(CFileBuf, NCFileBuf, sizeof(CFileBuf[0]), strCmp);
  NCFileOffset = 0;
  if (NCFileBuf >= 2) {
    cm_next = T;
    *status = CPL_AMBIG;
  } else {
    *status = CPL_OK;
  }
} else {
  strncpy(CFileName, CFileBuf[NCFileOffset], STR_LEN);
  NCFileOffset = (NCFileOffset + next + NCFileBuf) % NCFileBuf;
  *status = CPL_MENU;
}
  strcpy(CompleteBuf, CDirBuf);
  l = strlen(CompleteBuf);
  if (l == 0)
    strcpy(CompleteBuf, CFileName);
  else if (CompleteBuf[l - 1] == '/')
    strcpy(&CompleteBuf[l], CFileName);
  else {
    CompleteBuf[l] = '/';
    strcpy(&CompleteBuf[l + 1], CFileName);
  }
  if (*status != CPL_AMBIG) {
    if (stat(expandName(CompleteBuf), &st) != -1 && S_ISDIR(st.st_mode))
      strcat(CompleteBuf, "/");
  }
  return CompleteBuf;
}

static int
strCmp(const void *s1, const void *s2)
{
  unsigned char *p1 = *(unsigned char **)s1;
  unsigned char *p2 = *(unsigned char **)s2;

  while((*p1 != '\0') && (*p1 == *p2)) {
    p1++;
    p2++;
  }
  return(*p1 - *p2);
}

static void
_prev(void)
{
  Hist *hist = CurrentHist;
  int p;

  if (! use_hist || hist == NULL)
    return;
  if (hist->size <= 0)
    return;

  p = (hist->offset - hist->length + 1 + hist->size) % hist->size;
  if (hist->position == p)
    return;
  p = hist->position;
  hist->position = (hist->position - 1 + hist->size) % hist->size;
  if (hist->position == hist->offset)
    strcpy(hist->line[p], strBuf);
  strcpy(strBuf, hist->line[hist->position]);
  setStrType(strBuf, strProp);
  CLen = CPos = strlen(strBuf);
}

static void
_next(void)
{
  Hist *hist = CurrentHist;
  int p;

  if (! use_hist || hist == NULL)
    return;
  if (hist->size <= 0)
    return;

  p = (hist->offset + 1) % hist->size;
  if (hist->position == p)
    return;
  hist->position = (hist->position + 1) % hist->size;
  strcpy(strBuf, hist->line[hist->position]);
  setStrType(strBuf, strProp);
  CLen = CPos = strlen(strBuf);
}

static void
setStrType(char *str, Lineprop *prop)
{
  Lineprop ctype = PC_ASCII, prev_ctype;
  Lineprop *p = prop;
  char     *s = str;

  for (; *s != '\0'; s++, p++) {
    prev_ctype = ctype;
    *p = ctype = get_ctype((unsigned char)*s, prev_ctype);
#ifdef JP_CHARSET
    if (prev_ctype == PC_KANJI1 && ctype != PC_KANJI2)
      *(p-1) = PC_ASCII;
#endif
  }
}
