#include "fm.h"
#include "parsetag.h"
#include "myctype.h"
#include <signal.h>
#include <setjmp.h>

#ifdef KANJI_SYMBOLS
#define RULE_WIDTH 2
#else
#define RULE_WIDTH 1
#endif

static JMP_BUF  AbortLoading;

static          MySignalHandler
KeyAbort(SIGNAL_ARG)
{
  LONGJMP(AbortLoading, 1);
}

struct frameset*
newFrameSet(struct parsed_tagarg *arg)
{
  struct parsed_tagarg *t;
  struct frameset *f;
  int n,i,allcol;
  char *cols,*rows,*p,*q;
  char *length[100];

  f = New(struct frameset);
  f->name = NULL;
  cols = rows = NULL;
  for (t = arg; t; t = t->next) {
    if (!strcasecmp(t->arg,"cols") && t->value)
      cols = t->value;
    else if (!strcasecmp(t->arg,"rows") && t->value)
      rows = t->value;
  }
  if (cols && strchr(cols,',')) {
    p = cols;
    n = 0;
    allcol = COLS-(n-1)*RULE_WIDTH-2; /* -2 is arbitrary */
    q = p;
    do {
      if (*q == ',' || *q == '\0') {
       if (*(q - 1) == '%') {
         Str tmp = Sprintf("%d",allcol*PIXEL_PER_CHAR*atoi(p)/100);
         length[n] = tmp->ptr;
        } else {
         length[n] = allocStr(p,q-p);
       }
       n++;
       p = q+1;
      }
      q++;
    } while (q[-1]);
    f->col = n;
    f->width = New_N(char*,n);
    for (i = 0; i < n; i++) {
      f->width[i] = length[i];
    }
  } else {
    f->col = 1;
    f->width = New_N(char*,1);
    f->width[0] = "*";
  }
  if (rows && strchr(rows,',')) {
    p = rows;
    n = 0;
    allcol = LINES-(n-1)*RULE_WIDTH-2; /* -2 is arbitrary */
    q = p;
    do {
      if (*q == ',' || *q == '\0') {
       if (*(q - 1) == '%') {
         Str tmp = Sprintf("%d",allcol*PIXEL_PER_CHAR*atoi(p)/100);
         length[n] = tmp->ptr;
        } else {
         length[n] = allocStr(p,q-p);
       }
       n++;
       p = q+1;
      }
      q++;
    } while (q[-1]);
    f->row = n;
    f->height = New_N(char*,n);
    for (i = 0; i < n; i++) {
      f->height[i] = length[i];
    }
  } else {
    f->row = 1;
    f->height = New_N(char*,1);
    f->height[0] = "*";
  }
  n = f->row * f->col;
  f->i = 0;
  f->set = New_N(union frame_element,n);
  f->set_attr = NewAtom_N(char,n);

  for (i = 0; i < n; i++) {
    f->set[i].body = NULL;
    f->set_attr[i] = F_UNKNOWN;
  }
  return f;
}

void
addFrame(struct frameset *f, struct parsed_tagarg *arg)
{
  struct parsed_tagarg *t;
  struct frame_body *body;

  if (f == NULL || f->i >= f->col * f->row)
    return;

  body = New(struct frame_body);
  body->url = NULL;
  body->name = NULL;
  body->source = NULL;
  body->referer = NULL;
  body->request = NULL;
  body->to_delete = 0;
  for (t = arg; t; t = t->next) {
    if (!strcasecmp(t->arg,"src") && t->value)
      body->url = t->value;
    else if (!strcasecmp(t->arg,"name") && t->value)
      body->name = t->value;
  }
  f->set_attr[f->i] = F_BODY;
  f->set[f->i].body = body;
  f->i++;
}

void
deleteFrame(struct frame_body *b)
{
  if (b == NULL) return;
  if (b->source && b->to_delete)
    unlink(b->source);
}

void
addFrameSet(struct frameset *f, struct frameset *fset)
{
  int i;

  if (f == NULL) return;
  i = f->i;
  if (i >= f->col * f->row) return;
  f->set_attr[i] = F_FRAMESET;
  f->set[i].frame = fset;
  f->i++;
}

void
deleteFrameSet(struct frameset *f)
{
  int i;
  if (f == NULL) return;
  for (i = 0; i < f->col * f->row; i++) {
    if (f->set_attr[i] == F_FRAMESET)
      deleteFrameSet(f->set[i].frame);
    else if (f->set_attr[i] == F_BODY)
      deleteFrame(f->set[i].body);
  }
}

static char *prohibit_tags[] = {
  "html","head","body","/html","/head","/body",
  "meta","doctype","base",
  NULL
};

struct frameset *
frame_download_source(struct frame_body *b, Buffer *current)
{
  Buffer *buf;
  Str tmp;
  ParsedURL url;
  int flag;

  if (b->url == NULL || b->url[0] == '\0')
    return NULL;
  parseURL2(b->url,&url,&current->currentURL);
  if (url.scheme == SCM_LOCAL) {
    b->source = url.file;
    b->to_delete = 0;
  }
  flag = 0;
  if ((current->currentURL).is_nocache)
    flag |= RG_NOCACHE;
  buf = loadGeneralFile(b->url,baseURL(current),b->referer,flag,b->request);
			
  if (buf == NULL || buf == NO_BUFFER) {
    b->source = NULL;
    b->to_delete = 0;
    return NULL;
  }
  if (buf->frameset != NULL) {
    struct frameset *ret_frameset;

    ret_frameset = buf->frameset;
    buf->frameset = NULL;
    discardBuffer(buf);
    return ret_frameset;
  }
  if (buf->currentURL.scheme != SCM_LOCAL) {
    tmp = Sprintf("%s/w3mframe%d.%x",rc_dir,getpid(),b);
    rename(buf->sourcefile,tmp->ptr);
    b->source = tmp->ptr;
    b->to_delete = 1;
    buf->sourcefile = NULL;
  }
  discardBuffer(buf);
  return NULL;
}

int
createFrameFile(struct frameset *f, FILE *f1, Buffer *current, int level)
{
  int r,c,i,status,pre,a_target,is_anchor;
  FILE *f2;
  Str tmp,tok,continuation;
  char code;
  char *p, *d_target, *p_target, *s_target, *t_target;
  ParsedURL base;
  MySignalHandler (*prevtrap)(SIGNAL_ARG) = NULL;

  if (f == NULL)
    return -1;

  if (level == 0) {
    if (SETJMP(AbortLoading) != 0) {
      if (fmInitialized)
        term_raw();
      signal(SIGINT, prevtrap);
      return -1;
    }
    prevtrap = signal(SIGINT, KeyAbort);
    if (fmInitialized)
      term_cbreak();

    f->name = "_top";
  }

  if (level == 0) {
    fprintf(f1, "<html><head><title>%s</title></head><body>\n",
	    current->buffername);
    fputs("<table hborder width=\"100%\">\n", f1);
  }
  else if (level > 0)
    fprintf(f1, "<table hborder width=\"%d\">\n", level);
  else 
    fputs("<table hborder>\n", f1);
  tok = Strnew();
  continuation = Strnew();
  status = R_ST_NORMAL;
  pre = 0;
  for (r = 0; r < f->row; r++) {
    fputs("<tr>\n", f1);
    for (c = 0; c < f->col; c++) {
      i = c + r * f->col;
      if (!r) {
        fprintf(f1, "<td width=\"%s\">\n", f->width[c]);
      }
      else {
        fputs("<td>\n", f1);
      }
      if (f->set_attr[i] == F_BODY &&
	  f->set[i].body != NULL) {
	if (f->set[i].body->source == NULL) {
	  struct frameset *f_frameset;

	  f_frameset = frame_download_source(f->set[i].body,current);
	  if (f_frameset) {
	    deleteFrame(f->set[i].body);
	    f->set[i].body = NULL; 
	    f->set_attr[i] = F_FRAMESET;
	    f->set[i].frame = f_frameset;
	    goto render_frameset;
	  }
	}
	if (!f->set[i].body->name && f->name) {
	  int k = i;
	  size_t j = 3;

	  while (k > 9) {
	    j++;
	    k /= 10;
	  }
	  j += strlen(f->name);
	  snprintf((f->set[i].body->name = GC_MALLOC_ATOMIC(j)), j,
		   "%s_%d", f->name, i);
	}
	if (f->set[i].body->source == NULL)
	  continue;
	parseURL2(f->set[i].body->url,&base,&current->currentURL);
	f2 = fopen(f->set[i].body->source,"r");
	if (f2 == NULL) {
	  fprintf(f1, "Can't open %s", f->set[i].body->url);
	  continue;
	}
	d_target = "_blank";
	p_target = f->name;
	s_target = f->set[i].body->name;
	t_target = "_top";
	code = 0;
	while (1) {
	  tmp = Strmyfgets(f2);
	  if (tmp->length == 0) break;
#ifdef JP_CHARSET
	  code = checkShiftCode(tmp->ptr,code);
	  if (code != '\0' && code != InnerCode) {
	    tmp = conv(tmp->ptr,code,InnerCode);
	  }
#endif
	  if (pre)
	    Strchop(tmp);
	  p = tmp->ptr;
	  while (read_token(tok,&p,&status,pre,0)) {
	    if (continuation->length > 0) {
	      Strcat(continuation,tok);
	      tok = continuation;
	      continuation = Strnew();
	    }
	    if (status != R_ST_NORMAL) {
	      if (Strlastchar(tok) == '\n') {
		Strchop(tok);
	      }
	      if (ST_IS_REAL_TAG(status)) {
		Strcat_char(tok,' ');
	      }
	      continuation = tok;
	      tok = Strnew();
	      break;
	    }
	    if (tok->ptr[0] == '<') {
	      struct parsed_tagarg *targ,*t;
	      Str tagname = Strnew();
	      int j;
	      ParsedURL url;

	      for (j = 1; 
		   j < tok->length && !IS_SPACE(tok->ptr[j]) && tok->ptr[j] != '>'; 
		   j++) {
		Strcat_char(tagname,tok->ptr[j]);
	      }
	      if (!strcasecmp(tagname->ptr,"base")) {
		targ = parse_tag(tok->ptr);
		for (t = targ; t; t = t->next) {
		  if (!strcasecmp(t->arg,"href") && t->value)
		    parseURL(t->value,&base,NULL);
		  else if (!strcasecmp(t->arg,"target") && t->value) {
		    if (!strcasecmp(t->value,"_self"))
		      d_target = s_target;
		    else if (!strcasecmp(t->value,"_parent"))
		      d_target = p_target;
		    else
		      d_target = t->value;
		  }
		}
	      }
	      if (!strcasecmp(tagname->ptr,"title")) {
		fprintf(f1,"<!-- title:");
		continue;
	      }
	      else if (!strcasecmp(tagname->ptr,"/title")) {
		fprintf(f1,"-->");
		continue;
	      }
	      else if (strcasemstr(tagname->ptr,prohibit_tags,NULL) >= 0) {
		Strshrinkfirst(tok,j);
		Strshrink(tok,1);
		fprintf(f1,"<!-- %s %s -->",tagname->ptr,tok->ptr);
		continue;
	      }
 
	      targ = parse_tag(tok->ptr);
	      if (!strcasecmp(tagname->ptr,"pre")) {
		pre = 1;
		tmp = Strnew_charp(p);
		Strchop(tmp);
		p = tmp->ptr;
	      }
	      else if (!strcasecmp(tagname->ptr,"/pre"))
		pre = 0;
 
	      fprintf(f1,"<%s",tagname->ptr);
	      is_anchor = 0;
	      a_target = 0;
	      if (!strcasecmp(tagname->ptr,"a")) {
		is_anchor = 1;
		a_target = 2;
		for (t = targ; t; t = t->next) {
		  if (a_target == 2 && !strcasecmp(t->arg,"href") && t->value)
		    a_target = 1;
		  else if (!strcasecmp(t->arg,"target") && t->value) {
		    a_target = 0;
		    if (!strcasecmp(t->value,"_self"))
		      t->value = s_target;
		    else if (!strcasecmp(t->value,"_parent"))
		      t->value = p_target;
		    break;
		  }
		}
	      }
	      if (!strcasecmp(tagname->ptr,"form")) {
		a_target = 1;
		for (t = targ; t; t = t->next) {
		  if (!strcasecmp(t->arg,"target") && t->value) {
		    a_target = 0;
		    if (!strcasecmp(t->value,"_self"))
		      t->value = s_target;
		    else if (!strcasecmp(t->value,"_parent"))
		      t->value = p_target;
		    break;
		  }
		}
	      }
	      for (t = targ; t; t = t->next) {
		if ((!strcasecmp(t->arg,"src") || 
		     !strcasecmp(t->arg,"href") ||
		     !strcasecmp(t->arg,"action")) &&
		    t->value) {
		  if (strncasecmp(t->value,"mailto:",7) != 0) {
		    parseURL2(t->value,&url,&base);
		    t->value = htmlquote_str(parsedURL2Str(&url)->ptr);
		    if (code != '\0')
		      fprintf(f1," CHARSET=\"%c\"",code);
		  }
		}
		fprintf(f1," %s",t->arg);
		if (t->value)
		  fprintf(f1,"=\"%s\"",t->value);
	      }
	      if (a_target == 1) {
		/* there is HREF attribute and no TARGET attribute */
		fprintf(f1," TARGET=\"%s\"", d_target);
	      }
	      if (is_anchor)
		fprintf(f1," REFERER=\"%s\"",
			htmlquote_str(parsedURL2Str(&base)->ptr));
	      fprintf(f1,">");
	    }
	    else {
	      fputs(tok->ptr,f1);
	    }
	  }
	  fputc('\n',f1);
	}
	fclose(f2);
      }
      else if (f->set_attr[i] == F_FRAMESET) {
	int w;

      render_frameset:
	if (!f->set[i].frame->name && f->name) {
	  int k = i;
	  size_t j = 3;

	  while (k > 9) {
	    j++;
	    k /= 10;
	  }
	  j += strlen(f->name);
	  snprintf((f->set[i].frame->name = GC_MALLOC_ATOMIC(j)), j,
		   "%s_%d", f->name, i);
	}
        if (strcmp(f->width[c],"*")==0)
          w = -1;
        else
          w = atoi(f->width[c]);
        createFrameFile(f->set[i].frame,f1,current,w);
      }
      fputs("</td>\n", f1);
    }
    fputs("</tr>\n", f1);
  }

  fprintf(f1,"</table>\n");
  if (level == 0) {
    fprintf(f1,"</body></html>\n");
    signal(SIGINT,prevtrap);
    if (fmInitialized)
      term_raw();
  }
  return 0;
}

Buffer *
renderFrame(Buffer *Cbuf)
{
  Str tmp;
  FILE *f;
  Buffer *buf;
  int flag;

  tmp = Sprintf("%s/w3mframe%d.%lx.html",rc_dir,getpid(),(unsigned long)Cbuf->frameset);
  f = fopen(tmp->ptr,"w");
  if (f == NULL) return NULL;
  if (createFrameFile(Cbuf->frameset,f,Cbuf,0) < 0)
    return NULL;
  fclose(f);
  flag = 0;
  if ((Cbuf->currentURL).is_nocache)
    flag |= RG_NOCACHE;  
  buf = loadGeneralFile(tmp->ptr,NULL,NULL,flag,NULL);
  if (buf == NULL) return NULL;
  buf->sourcefile = tmp->ptr;
  buf->bufferprop |= BP_FRAME;
  copyParsedURL(&buf->currentURL,&Cbuf->currentURL);
  return buf;
}

struct frame_body*
search_frame(struct frameset *fset, char *name)
{
  int i;
  struct frame_body *b;

  for (i = 0; i < fset->col * fset->row; i++) {
    if (fset->set_attr[i] == F_FRAMESET &&
	fset->set[i].frame != NULL) {
      if (!strcmp(fset->set[i].frame->name,name)) {
	b = New(struct frame_body);
	b->url = NULL;
	b->name = fset->set[i].frame->name;
	b->source = NULL;
	b->referer = NULL;
	b->request = NULL;
	b->to_delete = 0;
	deleteFrameSet(fset->set[i].frame);
	fset->set[i].frame = NULL;
	fset->set_attr[i] = F_BODY;
	fset->set[i].body = b;
	return b;
      }
      b = search_frame(fset->set[i].frame,name);
      if (b) return b;
    }
    else if (fset->set_attr[i] == F_BODY &&
             fset->set[i].body != NULL) {
      if (fset->set[i].body->name != NULL &&
          !strcmp(fset->set[i].body->name,name)) {
        return fset->set[i].body;
      }
    }
  }
  return NULL;
}
