#include "animpoint.h"

AnimPoint::AnimPoint()
{
	init();
}

void AnimPoint::operator= ( const AnimPoint & other )
{
	copy (other);
}

void AnimPoint::operator= ( const QPointF & other )
{
	init();
	setX (other.x() );
	setY (other.x() );
}

bool AnimPoint::operator== ( const QPointF& other )
{
	QPointF p( x(),y());
	return p == other;
}

bool AnimPoint::operator== ( AnimPoint  other )
{
    if (rx() != other.rx() ) return false;
    if (ry() != other.ry() ) return false;
    if (animated != other.animated ) return false;

	return true;
}

void AnimPoint::init ()
{
	animated=false;
}

void AnimPoint::copy (AnimPoint other)
{
	setX (other.x() );
	setY (other.x() );
	animated=other.animated;
}


void AnimPoint::setDest(const QPointF &p)
{
	destPos=p;
}

void AnimPoint::setAnimated(bool b)
{
	animated=b;
}

bool AnimPoint::isAnimated()
{
	return animated;
}

void AnimPoint::animate()
{
	setX (x()+1);
	setY (y()+1);
}



