/*
 * Vomit - VoIP sniffer
 *
 * Copyright 2001 Niels Provos <provos@citi.umich.edu>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/wait.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <sys/queue.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <err.h>
#include <netdb.h>
#include <pcap.h>
#include <pcap.h>
#ifdef BSD
#include <pcap-int.h>
#endif
#include <event.h>

#include "config.h"

#include "pcapu.h"
#include "buffer.h"
#include "voip.h"

#ifndef howmany
#define howmany(x,y)	(((x) + ((y) - 1)) / (y))
#endif

int debug;
int pcap_off;
pcap_t *pcap_pd;

int
cleanup(void)
{
        pcap_close(pcap_pd);
        exit(0);
}

void
sigcb(int sig)
{
	extern int event_gotsig;

	event_gotsig = 1;
}

void
usage(char *name)
{
	fprintf(stderr, 
		"%s: [-h] [-r <file>] [filter]\n\n"
		"\t-r <file> specifies the tcpdump dump file\n"
		"\t-h        help\n",
		name);
}


int
main(int argc, char **argv)
{
	extern char *optarg;
	extern int optind;
	extern int (*event_sigcb)(void);
	int ch;
	char *name = argv[0];
	char *fromfile = NULL;
	char *filter = "udp or tcp";
	char *dev = NULL;

	debug = 0;
	while ((ch = getopt(argc, argv, "vr:h")) != -1)
		switch(ch) {
		case 'v':
			debug++;
			break;
		case 'r':
			fromfile = optarg;
			break;
		case 'h':
		default:
			usage(name);
			exit(1);
		}

	argc -= optind;
	argv += optind;

	if (argc)
		filter = copy_argv(argv);
	
	event_init();

	if ((pcap_pd = pcap_init(dev, fromfile, filter, 1500)) == NULL)
		errx(1, "couldn't initialize sniffing");

	if ((pcap_off = pcap_dloff(pcap_pd)) < 0)
		errx(1, "couldn't determine link layer offset");
	
	signal(SIGHUP, sigcb);
	signal(SIGINT, sigcb);
	signal(SIGTERM, sigcb);

	event_sigcb = cleanup;

	voip_init();

	event_dispatch();

	return (1);
}
