/* System dependencies */
#include "dep.h"

struct Format {
    char *text;		/* The input format text */
    char *p;		/* For walking through the input. */
    int file;		/* !0 means format comes from file */
    int linenum;	/* current line number in format list */
    char *line;		/* pointer to start of current line */
    char *item;		/* pointer to one past last item */
};
extern long count_reg[256];
extern int process_to_eof;
extern int debug;
extern char *prog;
#ifndef VIZ_MAIN
extern struct Format Fmt;
#endif

#define UPTO_EOF -1000	/* Code for '$' used as a number; must not be -255..0,
			 * because those are the codes for the $x registers.
			 */

#define T_LISTHEAD	00000001
#define T_COPYOUT	00000010
#define T_IOSPEC	00000100
#define T_NEWLINE	00001000
#define T_MATH		00010000
#define T_SEEK		00100000

typedef struct {
    short size;
    char ichar;
    char ochar;
    unsigned char reg_no;	/* If reg_no != 0, indicates that the value
				 * read in at runtime is to be stored in
				 * count_reg[reg_no].
				 */
    char *fmt;			/* Format spec, such as "%d", to control
				 * printing of these data.
				 */

} IOSPEC;

typedef struct member *LISTHEAD;

typedef struct {
    short reg_no;
    short operator;
    long operand;
} REG_MATH;

typedef struct {
    long count;
    int direction;
} STRM_SEEK;

typedef union {
	LISTHEAD sublist;
	char *copyout;
	IOSPEC iospec;
	REG_MATH math;
	STRM_SEEK seek;
} ITEM;

typedef struct member {
    struct member *next;

    int type;		/* One of T_LISTHEAD, T_COPYOUT, T_IOSPEC,
			 * T_NEWLINE, T_MATH, T_PRINT
			 */

    long count;		/* Number of repeats of u.<type>.
			 * If count < 0, take actual count from
			 * count_reg[-count].
			 */

    ITEM u;		/* union of listhead ptr, copyout ptr, iospec, math */
} MEMBER;

typedef MEMBER *MEMP;

#define NIL ((MEMP) 0)

MEMP rootlist;


typedef union {
    char *sval;
    int ival;
    long lval;
    unsigned long nval;
    ITEM item;
    MEMP memp;
} YYSTYPE;

extern void printlist();	/* Prints a list in human-readable form */
extern int condenselist();	/* Condenses a list to most efficient form */
extern int listlen();		/* Length of a list */
extern int duplicates();	/* Non-zero if two lists or mem's are similar */
extern MEMP newlist();		/* Creates a new listhead */
extern MEMP addmember();	/* Adds a member to the tail of a list */
extern IOSPEC makecore();	/* Creates the basic structure of a member */
extern IOSPEC makecorepct();	/* like makecore(), but takes user's own fmt */
extern int defaultichar();	/* Returns default ichar for given ochar */
extern int defaultochar();	/* Returns default ochar for given ichar */
extern int getsize();		/* Returns size of input data, given ichar */
extern int inval4reg();		/* Checks if datum can be stored in a #x reg */
extern int comb_dup_nl();	/* Combines duplicate non-list members */
extern int comb_dup_list();	/* Combines duplicates sublists */
extern int merge_sublist();	/* Merges a sublist into parent list */
extern void viz_decode();	/* Interprets viz copyouts */



/* REVERSE_nn reverses an nn-char atomic object, x.  It
 * requires an additional argument Type_nn that specifies the
 * type of the atomic object.
 */
#define REVERSE_2(x, Type_2) { \
	union { char c[2]; Type_2 i; } u0, u1; \
	u0.i = (x); \
	u1.c[1] = u0.c[0]; \
	u1.c[0] = u0.c[1]; \
	(x) = u1.i; \
    }

#define REVERSE_3(x, Type_3) { \
	union { char c[3]; Type_3 i; } u0, u1; \
	u0.i = (x); \
	u1.c[2] = u0.c[0]; \
	u1.c[1] = u0.c[1]; \
	u1.c[0] = u0.c[2]; \
	(x) = u1.i; \
    }

#define REVERSE_4(x, Type_4) { \
	union { char c[4]; Type_4 i; } u0, u1; \
	u0.i = (x); \
	u1.c[3] = u0.c[0]; \
	u1.c[2] = u0.c[1]; \
	u1.c[1] = u0.c[2]; \
	u1.c[0] = u0.c[3]; \
	(x) = u1.i; \
    }

#define REVERSE_5(x, Type_5) { \
	union { char c[5]; Type_5 i; } u0, u1; \
	u0.i = (x); \
	u1.c[4] = u0.c[0]; \
	u1.c[3] = u0.c[1]; \
	u1.c[2] = u0.c[2]; \
	u1.c[1] = u0.c[3]; \
	u1.c[0] = u0.c[4]; \
	(x) = u1.i; \
    }

#define REVERSE_6(x, Type_6) { \
	union { char c[6]; Type_6 i; } u0, u1; \
	u0.i = (x); \
	u1.c[5] = u0.c[0]; \
	u1.c[4] = u0.c[1]; \
	u1.c[3] = u0.c[2]; \
	u1.c[2] = u0.c[3]; \
	u1.c[1] = u0.c[4]; \
	u1.c[0] = u0.c[5]; \
	(x) = u1.i; \
    }

#define REVERSE_7(x, Type_7) { \
	union { char c[7]; Type_7 i; } u0, u1; \
	u0.i = (x); \
	u1.c[6] = u0.c[0]; \
	u1.c[5] = u0.c[1]; \
	u1.c[4] = u0.c[2]; \
	u1.c[3] = u0.c[3]; \
	u1.c[2] = u0.c[4]; \
	u1.c[1] = u0.c[5]; \
	u1.c[0] = u0.c[6]; \
	(x) = u1.i; \
    }

#define REVERSE_8(x, Type_8) { \
	union { char c[8]; Type_8 i; } u0, u1; \
	u0.i = (x); \
	u1.c[7] = u0.c[0]; \
	u1.c[6] = u0.c[1]; \
	u1.c[5] = u0.c[2]; \
	u1.c[4] = u0.c[3]; \
	u1.c[3] = u0.c[4]; \
	u1.c[2] = u0.c[5]; \
	u1.c[1] = u0.c[6]; \
	u1.c[0] = u0.c[7]; \
	(x) = u1.i; \
    }

#if ( L_SHORT == 2 )
#define REVERSE_SHORT REVERSE_2
#endif
#if ( L_SHORT == 3 )
#define REVERSE_SHORT REVERSE_3
#endif
#if ( L_SHORT == 4 )
#define REVERSE_SHORT REVERSE_4
#endif
#if ( L_SHORT == 5 )
#define REVERSE_SHORT REVERSE_5
#endif
#if ( L_SHORT == 6 )
#define REVERSE_SHORT REVERSE_6
#endif
#if ( L_SHORT == 7 )
#define REVERSE_SHORT REVERSE_7
#endif
#if ( L_SHORT == 8 )
#define REVERSE_SHORT REVERSE_8
#endif


#if ( L_INT == 2 )
#define REVERSE_INT REVERSE_2
#endif
#if ( L_INT == 3 )
#define REVERSE_INT REVERSE_3
#endif
#if ( L_INT == 4 )
#define REVERSE_INT REVERSE_4
#endif
#if ( L_INT == 5 )
#define REVERSE_INT REVERSE_5
#endif
#if ( L_INT == 6 )
#define REVERSE_INT REVERSE_6
#endif
#if ( L_INT == 7 )
#define REVERSE_INT REVERSE_7
#endif
#if ( L_INT == 8 )
#define REVERSE_INT REVERSE_8
#endif

#if ( L_LONG == 2 )
#define REVERSE_LONG  REVERSE_2
#endif
#if ( L_LONG == 3 )
#define REVERSE_LONG  REVERSE_3
#endif
#if ( L_LONG == 4 )
#define REVERSE_LONG  REVERSE_4
#endif
#if ( L_LONG == 5 )
#define REVERSE_LONG  REVERSE_5
#endif
#if ( L_LONG == 6 )
#define REVERSE_LONG  REVERSE_6
#endif
#if ( L_LONG == 7 )
#define REVERSE_LONG  REVERSE_7
#endif
#if ( L_LONG == 8 )
#define REVERSE_LONG  REVERSE_8
#endif


/* Macro <S><o>_fmt give format for printing data of size S in format o */

#define Bb_fmt "0b%s  "
#define Bo_fmt "%#5o "
#define Bd_fmt "%5d "
#define Bu_fmt "%4u "
#define Bx_fmt "%#5x "

#define Cb_fmt "0b%s  "
#define Co_fmt "%#5o "
#define Cd_fmt "%5d "
#define Cu_fmt "%4u "
#define Cx_fmt "%#5x "

#define Zb_fmt "0b%s  "
#define Zo_fmt "%#5o "
#define Zd_fmt "%5d "
#define Zu_fmt "%4u "
#define Zx_fmt "%#5x "

#if ( L_SHORT == 2 )
#define Sb_fmt "0b%s,%s  "	/* Args are 1 string per byte */
#endif
#if ( L_SHORT == 3 )
#define Sb_fmt "0b%s,%s,%s  "
#endif
#if ( L_SHORT == 4 )
#define Sb_fmt "0b%s,%s,%s,%s  "
#endif
#if ( L_SHORT == 5 )
#define Sb_fmt "0b%s,%s,%s,%s,%s  "
#endif
#if ( L_SHORT == 6 )
#define Sb_fmt "0b%s,%s,%s,%s,%s,%s  "
#endif
#if ( L_SHORT == 7 )
#define Sb_fmt "0b%s,%s,%s,%s,%s,%s,%s  "
#endif
#if ( L_SHORT == 8 )
#define Sb_fmt "0b%s,%s,%s,%s,%s,%s,%s,%s  "
#endif
#define So_fmt "%#8o "
#define Sd_fmt "%6d "
#define Su_fmt "%6u "
#define Sx_fmt "%#7x "

#if ( L_INT == 2 )
#define Ib_fmt "0b%s,%s  "	/* Args are 1 string per byte */
#endif
#if ( L_INT == 3 )
#define Ib_fmt "0b%s,%s,%s  "
#endif
#if ( L_INT == 4 )
#define Ib_fmt "0b%s,%s,%s,%s  "
#endif
#if ( L_INT == 5 )
#define Ib_fmt "0b%s,%s,%s,%s,%s  "
#endif
#if ( L_INT == 6 )
#define Ib_fmt "0b%s,%s,%s,%s,%s,%s  "
#endif
#if ( L_INT == 7 )
#define Ib_fmt "0b%s,%s,%s,%s,%s,%s,%s  "
#endif
#if ( L_INT == 8 )
#define Ib_fmt "0b%s,%s,%s,%s,%s,%s,%s,%s  "
#endif
#define Io_fmt "%#14o "
#define Id_fmt "%12d "
#define Iu_fmt "%12u "
#define Ix_fmt "%#10x "

#if ( L_LONG == 2 )
#define Lb_fmt "0b%s,%s  "	/* Args are 1 string per byte */
#endif
#if ( L_LONG == 3 )
#define Lb_fmt "0b%s,%s,%s  "
#endif
#if ( L_LONG == 4 )
#define Lb_fmt "0b%s,%s,%s,%s  "
#endif
#if ( L_LONG == 5 )
#define Lb_fmt "0b%s,%s,%s,%s,%s  "
#endif
#if ( L_LONG == 6 )
#define Lb_fmt "0b%s,%s,%s,%s,%s,%s  "
#endif
#if ( L_LONG == 7 )
#define Lb_fmt "0b%s,%s,%s,%s,%s,%s,%s  "
#endif
#if ( L_LONG == 8 )
#define Lb_fmt "0b%s,%s,%s,%s,%s,%s,%s,%s  "
#endif
#define Lo_fmt "%#14lo "
#define Ld_fmt "%12ld "
#define Lu_fmt "%12lu "
#define Lx_fmt "%#10lx "

#define Ff_fmt "%7f "
#define Fg_fmt "%7g "

#define Df_fmt "%.16f  "
#define Dg_fmt "%.16g  "

/* Buffer size for fread */
#define BUFFERSIZE 8192
