
/* The following macros are 15-20% faster than using the usual [but
 * much more compact] (c + 1 - '0') sort of translation.
 */
#define translate_octal(cc, s)		\
{					\
    register i;				\
    for (cc = 0, i=4; isdigit(*s) && *s != '8' && *s != '9' && --i != 0;) { \
	cc <<= 3;			\
	switch (*s++) {			\
	case '0':			\
	    break;			\
	case '1':			\
	    cc |= 1;			\
	    break;			\
	case '2':			\
	    cc |= 2;			\
	    break;			\
	case '3':			\
	    cc |= 3;			\
	    break;			\
	case '4':			\
	    cc |= 4;			\
	    break;			\
	case '5':			\
	    cc |= 5;			\
	    break;			\
	case '6':			\
	    cc |= 6;			\
	    break;			\
	default:			\
	    cc |= 7;			\
	    break;			\
	}				\
    }					\
}

#define translate_hex(cc, s)		\
{					\
    for (cc = 0; isxdigit(*s); ) {	\
	cc <<= 4;			\
	switch (*s++) {			\
	case '0':			\
	    break;			\
	case '1':			\
	    cc |= 1;			\
	    break;			\
	case '2':			\
	    cc |= 2;			\
	    break;			\
	case '3':			\
	    cc |= 3;			\
	    break;			\
	case '4':			\
	    cc |= 4;			\
	    break;			\
	case '5':			\
	    cc |= 5;			\
	    break;			\
	case '6':			\
	    cc |= 6;			\
	    break;			\
	case '7':			\
	    cc |= 7;			\
	    break;			\
	case '8':			\
	    cc |= 8;			\
	    break;			\
	case '9':			\
	    cc |= 9;			\
	    break;			\
	case 'a':			\
	case 'A':			\
	    cc |= 10;			\
	    break;			\
	case 'b':			\
	case 'B':			\
	    cc |= 11;			\
	    break;			\
	case 'c':			\
	case 'C':			\
	    cc |= 12;			\
	    break;			\
	case 'd':			\
	case 'D':			\
	    cc |= 13;			\
	    break;			\
	case 'e':			\
	case 'E':			\
	    cc |= 14;			\
	    break;			\
	default:			\
	    cc |= 15;			\
	    break;			\
	}				\
    }					\
}
