#include <stdio.h>
#include <ctype.h>
#include "string.h"
#include "viz.h"
#include "translate.h"

/* Takes a line of printable text containing viz(1)-style escape
 * sequences and turns it into the (possibly binary) text represented
 * by the text.  Note that non-printing characters embedded in the
 * input text aren't changed, because we are only translating the
 * printable viz(1)-style stuff.

 */

void
inviz_text(s, mode, outbuf)
register char *s;	/* line to translate.  If mode is 'c', s should begin
			 * after the 'c' mode character.
			 */
register char mode;	/* 'c' or 'a'; not checked for validity */
char *outbuf;		/* Where the output goes; assumed long enough.
			 * Note that the output will never be longer than
			 * the input.
			 */
{
    register char *outbuf_p = outbuf;

    register unsigned char c;
    register n;

    for (; *s && *s != '\n'; s++) {
	if (mode == 'c'  &&  isspace(*s)) {
	    /* Eat whitespace in 'c' mode */
	    continue;
	}

	if (*s == '\\') {
	    switch (*++s) {
#ifdef __STDC__
	    case 'a':
		*outbuf_p++ = '\a';
		break;
#endif
	    case 'b':
		*outbuf_p++ = '\b';
		break;
	    case 'f':
		*outbuf_p++ = '\f';
		break;
	    case 'n':
		*outbuf_p++ = '\n';
		break;
	    case 'r':
		*outbuf_p++ = '\r';
		break;
	    case 't':
		*outbuf_p++ = '\t';
		break;
#ifdef __STDC__
	    case 'v':
		*outbuf_p++ = '\v';
		break;
#endif
	    case '\\':
		*outbuf_p++ = '\\';
		break;
	    case '^':
		*outbuf_p++ = '^';
		break;
	    case '\'':
		*outbuf_p++ = '\'';
		break;
	    case '"':
		*outbuf_p++ = '"';
		break;
	    case '?':
		*outbuf_p++ = '?';
		break;
	    case '0':
	    case '1':
	    case '2':
	    case '3':
	    case '4':
	    case '5':
	    case '6':
	    case '7':
		translate_octal(c, s);
		s--;
		*outbuf_p++ = c;
		break;
	    case 'x':
		s++;
		translate_hex(c, s);
		s--;
		*outbuf_p++ = c;
		break;
	    default:
		*outbuf_p++ = *s;
		break;
	    }
	} else if (*s == '^') {
	    n = (int) *++s + 1 - 'A';
	    *outbuf_p++ = n;
	} else {
	    /* Print character literally. */
	    *outbuf_p++ = *s;
	}
    }
    (void) fwrite(outbuf, 1, outbuf_p - outbuf, stdout);
}
