#include <stdio.h>
#include <ctype.h>
#include "translate.h"

extern char *prog;

void
inviz_num(str, line)
register char *str;
int line;
{
    typedef union {
	char c;		unsigned char uc;
	short s;	unsigned short us;
	int i;		unsigned int ui;
	long l;		unsigned long ul;
	float f;
	double d;
    } ANYVAL;
    register ANYVAL rv;
    ANYVAL v;
    float f;

    register j;
    char *next;
    register char *p;

    int negative;

    char mode = 'I';
    char outbuf[1000];

    double strtod();
    unsigned long strtou();

    while (*str) {
	if (isspace(*str)) {
	    str++;
	    continue;
	}

	switch (*str) {
	case 'C':
	case 'S':
	case 'I':
	case 'L':
	case 'F':
	case 'D':
	    mode = *str++;
	    break;
	case '\\':
	    str++;
	    if (*str == '#' && *(str+1)) {
		mode = *++str;
		str++;
	    } else if (*str == 'x') {
		str++;
		translate_hex(rv.uc, str);
		(void) putchar(rv.uc);
	    } else {
		translate_octal(rv.uc, str);
		(void) putchar(rv.uc);
	    }
	    break;
	case '-':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	    /* Translate a number */
	    if (mode == 'F' || mode == 'D') {
		v.d = strtod(str, &next);
		if (next == str) {
		    (void) fprintf(stderr,
			"%s: Error while translating number on line %d\n.",
			prog, line);
		    (void) fprintf(stderr, "Line ignored from `%s'\n", str);
		    return;
		}
		str = next;
		if (mode == 'F') {
		    f = v.d;
		    for (j = sizeof(float), p = (char *) &f; j; --j)
			(void) putchar(*p++);
		} else {
		    for (j = sizeof(double), p = (char *) &v.d; j; --j)
			(void) putchar(*p++);
		}
	    } else {
		if (*str == '-') {
		    str++;
		    negative = 1;
		} else {
		    negative = 0;
		}
		rv.ul = strtou(str, &next, 0);
		if (next == str) {
		    (void) fprintf(stderr,
			"%s: Error while translating number on line %d\n.",
			prog, line);
		    (void) fprintf(stderr, "Line ignored from `%s'\n", str);
		    return;
		}
		str = next;
		if (negative) {
		    switch (mode) {
		    case 'C':
			(void) putchar((char) -rv.ul);
			break;
		    case 'S':
			v.s = (short) -rv.ul;
			for (j = sizeof(short), p = (char *) &v.s; j; --j)
			    (void) putchar(*p++);
			break;
		    case 'I':
			v.i = (int) -rv.ul;
			for (j = sizeof(int), p = (char *) &v.i; j; --j)
			    (void) putchar(*p++);
			break;
		    case 'L':
			v.l = (long) -rv.ul;
			for (j = sizeof(long), p = (char *) &v.l; j; --j)
			    (void) putchar(*p++);
			break;
		    }
		} else {
		    switch (mode) {
		    case 'C':
			(void) putchar((unsigned char) rv.ul);
			break;
		    case 'S':
			v.us = (unsigned short) rv.ul;
			for (j = sizeof(short), p = (char *) &v.us; j; --j)
			    (void) putchar(*p++);
			break;
		    case 'I':
			v.ui = (unsigned int) rv.ul;
			for (j = sizeof(int), p = (char *) &v.ui; j; --j)
			    (void) putchar(*p++);
			break;
		    case 'L':
			v.ul = (unsigned long) rv.ul;
			for (j = sizeof(long), p = (char *) &v.ul; j; --j)
			    (void) putchar(*p++);
			break;
		    }
		}
	    }
	    break;
	default:
	    (void) fprintf(stderr, "%s: Invalid input on line %d\n",
		prog, line);
	    exit(1);
	    break;
	}
    }
}
