/* Input:
 *	1. Everything up to the last tab on a line is skipped over.
 *	2. The sequence \# indicates the rest of the line is numeric mode.
 *	3. In text mode, all C escapes are accepted, and ^c
 *	   stands for the code (c+1-'A').
 *	4. In numeric mode, c/C/S/I/L/F/D is used to give sufficient
 *	   type/size information to properly convert input.
 */

#include <stdio.h>
#include <ctype.h>
#include "string.h"
#include "viz.h"
#include "version.h"
#include "translate.h"

char *prog;

void inviz_text();
void inviz_num();

main(argc, argv)
int argc;
char **argv;
{

    int i=1;

    prog = argv[0];

    if (argc == 1) {
	(void) inviz();
    } else {
	do {
	    if (freopen(argv[i], "r", stdin) == (FILE *) NULL) {
		(void) fprintf(stderr, "%s: failed to open %s: ",prog, argv[i]);
		perror("");
	    } else {
		clearerr(stdin);
		(void) inviz();
	    }
		
	} while (++i < argc);
    }

    return 0;
}
inviz()
{
    char *s;
    char inbuf[BUFFERSIZE];
    char outbuf[BUFFERSIZE];
    int line, n;

    for (line = 1; fgets(inbuf, BUFFERSIZE, stdin) != NULL; line++) {
	n = strlen(inbuf);
	/* Remove newline left on by fgets */
	if (inbuf[n-1] == '\n')
	    inbuf[n-1] = '\0';

	/* Discard everything up to the last tab */
	s = strrchr(inbuf, '\t');
	if (s)
	    s++;
	else
	    s = inbuf;
	

	/* Determine mode and call appropriate processing function */
	if (strncmp(s, "\\#", 2) == 0)
	    inviz_num(s + 2, line);
	else
	    inviz_text(s, 'a', outbuf);
    }
}
