#include <io.h>
#include <conio.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <process.h>
#include <errno.h>

void cd_to_prog_dir(char *argv0)
{
	int n = strlen(argv0);
	do n--;
	while (n>=0 && argv0[n] !='\\' && argv0[n] !='/');
	if (n>=0) {
		argv0[n] = '\0';
		chdir(argv0);
	}
}

void error(const char *message)
{
	printf("%s\nPress any key to continue... ", message);
	getch();
	exit(1);
}

char *trim(char *s)
{
	while (isspace(*s))
		s++;
	int n = strlen(s);
	while (n && isspace(s[--n]))
		s[n] = '\0';
	return s;
}

void get_name_hostname(char *name, char *hostname, char *line)
{
	FILE *fp = fopen("vitetris.cfg", "r");
	if (!fp)
		error("Could not open vitetris.cfg for reading!");

	while (fgets(line, 80, fp) && line[0] != '[') {
		char *p = strchr(line, '=');
		if (p) {
			p++;
			if (!strncmp(line, "name", 4))
				strncpy(name, trim(p), 30);
			if (!strncmp(line, "hostname", 8))
				strncpy(hostname, trim(p), 70);
		}
	}
	fclose(fp);
}

int main(int argc, char **argv)
{
	cd_to_prog_dir(argv[0]);
	char name[32] = "\"";
	char hostname[80] = "";
	char buf[80];
	char *p;
	get_name_hostname(name+1, hostname, buf);
	printf("Connect to");
	if (hostname[0])
		printf(" [%s]", hostname);
	printf(": ");
	if (!fgets(buf, 80, stdin))
		return 0;
	p = trim(buf);
	if (*p)
		strncpy(hostname, p, 70);
	printf("Enter your name");
	if (name[1])
		printf(" [%s]", name+1);
	printf(": ");
	if (!fgets(buf, 80, stdin))
		return 0;
	p = trim(buf);
	if (*p)
		strncpy(name+1, p, 30);
	strcat(name, "\"");
	p = strchr(hostname, ' ');
	if (p && isdigit(p[1]))
		*p = ':';
	p = strchr(hostname, ':');
	if (!p)
		strcat(hostname, ":34034");
	if (strchr(hostname, ' ') || strchr(hostname, '\t')) {
		memmove(hostname+1, hostname, strlen(hostname));
		hostname[0] = '"';
		strcat(hostname, "\"");
	}
	execl("tetrisal.exe", "tetrisal.exe",
	      "-name", name, "connect", hostname, NULL);
	perror("tetrisal.exe");
	return 1;
}
