/*	$Csoft: videod.c,v 1.7 2003/05/13 13:39:08 vedge Exp $	*/

/*
 * TODO: - set frequency/channel via command line and antenna/cable (?)
 *       - set hue/brightness/contrast/chromaU/chromaV via command line (?)
 */

/*
 * Copyright (c) 2003 CubeSoft Communications, Inc.
 * <http://www.csoft.org>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/* Copyright (c) 1999 Thomas Runge (runge@rostock.zgdv.de)
 *
 * Based on grab.c by Roger Hardiman, videocapture.c by Amancio Hasty,
 *  libjpeg.doc by the Independent JPEG Group
 *
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by Mark Tinguely and Jim Lowe
 * 4. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <sys/mman.h>
#include <sys/param.h>
#include <sys/time.h>

#include <fcntl.h>
#include <signal.h>
#include <errno.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <unistd.h>

#include <jpeglib.h>

#include <dev/ic/bt8xx.h>

/* PAL is 768 x 576. NTSC is 640 x 480 */
#define PAL_MAXCOLS 768
#define PAL_MAXROWS 576
#define NTSC_MAXCOLS 640
#define NTSC_MAXROWS 480

int keep_running;

struct capjpeg {
	struct jpeg_error_mgr		jerr;
	struct jpeg_compress_struct	cinfo;

	JSAMPLE	*rgb_buffer;
	char	*copybuf;

	int	cols;
	int	rows;
};

static const struct {
	char	*name;
	int	 ind;
} ports[] = {
	{ "rca",	METEOR_INPUT_DEV0 },
	{ "dev1",	METEOR_INPUT_DEV1 },
	{ "dev2",	METEOR_INPUT_DEV2 },
	{ "dev3",	METEOR_INPUT_DEV3 },
	{ "svideo",	METEOR_INPUT_DEV_SVIDEO }
};
static const int nports = sizeof(ports) / sizeof(ports[0]);

static void
done(int sig)
{
	keep_running = 0;
}

static void
jpeg_init(struct capjpeg *ctx, int quality)
{
	ctx->cinfo.err = jpeg_std_error(&ctx->jerr);
	jpeg_create_compress(&ctx->cinfo);

	ctx->cinfo.image_width  = ctx->cols;
	ctx->cinfo.image_height = ctx->rows;
	ctx->cinfo.input_components = 3;
	ctx->cinfo.in_color_space = JCS_RGB;

	jpeg_set_defaults(&ctx->cinfo);

	jpeg_set_quality(&ctx->cinfo, quality, TRUE);
}

static void
jpeg_encode(struct capjpeg *ctx, char *path)
{
	FILE *fp = stdout;
	JSAMPROW row_pointer[1];
	JSAMPLE *src = ctx->rgb_buffer;
	unsigned char *p;
	char tmpfile[FILENAME_MAX];
	int i;

	snprintf(tmpfile, FILENAME_MAX, "%s.tmp", path);

	if ((fp = fopen(tmpfile, "wb")) == NULL) {
		warn("fopen");
		return;
	}

	jpeg_stdio_dest(&ctx->cinfo, fp);

	jpeg_start_compress(&ctx->cinfo, TRUE);

	while (ctx->cinfo.next_scanline < ctx->cinfo.image_height) {
		p = ctx->copybuf;
		for (i = ctx->cols; i; i--) {
			*p++ = src[2];
			*p++ = src[1];
			*p++ = src[0];
			src += 4;
		}
		row_pointer[0] = ctx->copybuf;
		jpeg_write_scanlines(&ctx->cinfo, row_pointer, 1);
	}

	jpeg_finish_compress(&ctx->cinfo);

	fflush(fp);
	fclose(fp);

	if (rename(tmpfile, path) == -1)
		warn("rename");
}

int
main(int argc, char **argv)
{
	struct capjpeg actx, *ctx = &actx;
	char dev_path[MAXPATHLEN];
	char *path = "video";
	int width = 640;
	int height = 480;
	int quality = 75;
	int single = METEOR_CAP_SINGLE;
	int input = METEOR_INPUT_DEV0;
	int i, fmt, ch;
	int video = -1;
	int snap_ival = 10;
	int sleep_secs = 5;
	struct meteor_geomet geo;
	struct timeval timeout;
	extern char *__progname;
	char vpath[FILENAME_MAX];

	keep_running = 1;

	bzero(ctx, sizeof(*ctx));

	signal(SIGPIPE, done);
	signal(SIGINT,  done);
	
	snprintf(dev_path, sizeof(dev_path), "/dev/bktr0");

	while ((ch = getopt(argc, argv, "i:f:d:w:h:q:s:p:v?")) != -1) {
		switch (ch) {
		case 'i':
			snap_ival = atoi(optarg);
			break;
		case 's':
			sleep_secs = atoi(optarg);
			break;
		case 'f':
			path = optarg;
			break;
		case 'd':
			snprintf(dev_path, sizeof(dev_path), optarg);
			break;
		case 'w':
			width = atoi(optarg);
			break;
		case 'h':
			height = atoi(optarg);
			break;
		case 'q':
			quality = atoi(optarg);
			if (quality < 0 || quality > 100)
				quality = 75;
				break;
		case 'p':
			for (i = 0; i < nports; i++) {
				if (strcmp(ports[i].name, optarg) == 0) {
					input = ports[i].ind;
					break;
				}
			}
			if (i == nports) {
				fprintf(stderr,
				    "No such port `%s'. Valid ports are:",
				    optarg);
				for (i = 0; i < nports; i++)
					fprintf(stderr, " %s", ports[i].name);
				fprintf(stderr, ".\n");
				exit(EXIT_FAILURE);
			}
			break;
		case 'v':
			fprintf(stderr, "%s %s\n", __progname, VERSION);
			exit(EXIT_SUCCESS);
			break;
		case '?':
		default:
			fprintf(stderr, "Usage: %s [-f basename] [-d device] "
			    "[-p port] [-w width] [-h height] [-q quality] "
			    "[-s sleep-secs] [-i snap-minutes] [-v]\n",
			    __progname);
			exit(EXIT_SUCCESS);
			break;
		}
	}

	if ((video = open(dev_path, O_RDONLY)) == -1)
		err(1, dev_path);
	
	timeout.tv_sec = sleep_secs;
	timeout.tv_usec = 0;
	
	/* Allocate a rendering context. */
	ctx->cols = width;
	ctx->rows = height;
	ctx->copybuf = (char*)malloc(ctx->cols*3);
	if (ctx->copybuf == NULL)
		err(1, "malloc");
	
	/* Adjust the geometry. */
	if ((unsigned) ctx->cols > PAL_MAXCOLS ||
	    (unsigned) ctx->cols <= 0 ||
	    (unsigned) ctx->rows > PAL_MAXROWS ||
	    (unsigned) ctx->rows <= 0) {
		ctx->cols = PAL_MAXCOLS;
		ctx->rows = PAL_MAXROWS;
	}
	geo.columns = ctx->cols;
	geo.rows = ctx->rows;
	geo.frames = 1;
	geo.oformat = METEOR_GEO_RGB24;
	
	/* Adjust the geometry to the video format. */
	if (ioctl(video, METEORGFMT, &fmt) == -1)
		err(1, "METEORGFMT");
	if (fmt == METEOR_FMT_NTSC) {
		if (geo.rows <= NTSC_MAXROWS / 2) {
			geo.oformat |= METEOR_GEO_ODD_ONLY; 
		}
	}
	if (fmt == METEOR_FMT_PAL) {
		if (geo.rows <= PAL_MAXROWS / 2) {
			geo.oformat |= METEOR_GEO_ODD_ONLY; 
		}
	}
	
	/* Set the geometry, format and input. */
	if (ioctl(video, METEORSETGEO, &geo) == -1)
		err(1, "METEORSETGEO");
	if (ioctl(video, METEORSFMT, &fmt) == -1)
		err(1, "METEORSFMT");
	if (ioctl(video, METEORSINPUT, &input) == -1)
		err(1, "METEORSINPUT");
	
	/* Map the video device into memory. */
	ctx->rgb_buffer = (JSAMPLE *)
	    mmap(NULL, ctx->rows * ctx->cols * 4, PROT_READ, MAP_SHARED,
	    video, 0);
	if (ctx->rgb_buffer == MAP_FAILED)
		err(1, "mmap");
	
	/* Initialize the JPEG settings. */
	jpeg_init(ctx, quality);

	while (keep_running) {
		const time_t clock = time(NULL);
		struct tm *tm = localtime(&clock);
		static int last_min = -1;

		if (ioctl(video, METEORCAPTUR, &single) != 0)
			err(1, "METEORCAPTUR single");

		if (tm->tm_min != last_min && (tm->tm_min % snap_ival) == 0) {
			char mon_dir[FILENAME_MAX];
			char day_dir[FILENAME_MAX];

			snprintf(mon_dir, FILENAME_MAX, "%d-%d",
			    tm->tm_year + 1900,
			    tm->tm_mon + 1);
			snprintf(day_dir, FILENAME_MAX, "%s/%d",
			    mon_dir, tm->tm_mday);

			if (mkdir(mon_dir, 0755) != 0 && errno != EEXIST)
				warn(mon_dir);
			if (mkdir(day_dir, 0755) != 0 && errno != EEXIST)
				warn(day_dir);

			snprintf(vpath, FILENAME_MAX, "%s/%s.%d-%d.jpg",
			    day_dir, path, tm->tm_hour, tm->tm_min);

			last_min = tm->tm_min;
		} else {
			snprintf(vpath, FILENAME_MAX, "%s.jpg", path);
		}
		jpeg_encode(ctx, vpath);

		/* Sleep */
		select(-1, NULL, NULL, NULL, &timeout);
	}
	
	/* Unmap the video device. */
	if (munmap(ctx->rgb_buffer, ctx->rows * ctx->cols * 4) == -1)
		err(1, "munmap");

	free(ctx->copybuf);
	jpeg_destroy_compress(&ctx->cinfo);

	close(video);
	exit(EXIT_SUCCESS);
}

