#
# Copyright (c) 1994 Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 3. All advertising materials mentioning features or use of this software
#    must display the following acknowledgement:
#	This product includes software developed by the Network Research
#	Group at Lawrence Berkeley Laboratory.
# 4. Neither the name of the University nor of the Laboratory may be used
#    to endorse or promote products derived from this software without
#    specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#
# @(#) $Header: /cs/research/mice/starship/src/local/CVS_repository/vic/tkerror.tcl,v 1.2 1998/12/15 13:35:04 ucackha Exp $ (LBL)
#

proc tkerror { msg } {
	global errorInfo V
	set info $errorInfo
	if { [string match "no more colors*" $msg] } {
		puts "$V(app): $msg"
		return
	}
	puts "$V(app)-[version]: tcl runtime error: $msg"
	puts "stack trace:"
	puts $info
	puts \
"Please mail this error message and, if possible, an explanation\
\nof what user-action caused it to $V(app)@cs.ucl.ac.uk."
}

proc "" args {
	global errorInfo V
	set info $errorInfo
	puts "$V(app)-[version]: null proc called:"
	puts "stack trace:"
	puts $info
	puts \
"Please mail this error message and, if possible, an explanation\
\nof what user-action caused it to $V(app)@cs.ucl.ac.uk."
}
