%define prefix   /usr

#Uncomment these if they are not defined by your rpm macros file
#%define _prefix                /usr
#%define _exec_prefix           %{_prefix}
#%define _bindir                %{_exec_prefix}/bin
#%define _sbindir               %{_exec_prefix}/sbin
#%define _libexecdir            %{_exec_prefix}/libexec
#%define _datadir               %{_prefix}/share
#%define _sysconfdir            %{_prefix}/etc
#%define _sharedstatedir        %{_prefix}/com
#%define _localstatedir         %{_prefix}/var
#%define _lib                   lib
#%define _libdir                %{_exec_prefix}/%{_lib}
#%define _includedir            %{_prefix}/include
#%define _oldincludedir         /usr/include
#%define _infodir               %{_prefix}/info
#%define _mandir                %{_prefix}/man


Summary: Library of Abstract Data Types 
Name: vanessa_adt
Version: 0.0.6
Release: 1
Copyright: GNU Lesser General Public Licence
URL: http://www.vergenet.net/linux/vanessa/
Packager: Horms <horms@verge.net.au>
Group: Development/Libraries
Source0: ftp://vergenet.net/pub/vanessa_adt/vanessa_adt/%{name}-%{version}.tar.gz
BuildRoot: /var/tmp/%{name}-%{version}-root
Docdir: %{prefix}/doc
Provides: %{name}-%{version}
BuildPrereq: automake autoconf libtool vanessa_logger-devel
Requires: vanessa_logger

%description
Library of Abstract Data Types (ADTs) that may be useful.  Includes queue,
dynamic array and key value ADT.

%package devel
Summary: Headers and static libraries for development
Group: Development/Libraries
Requires: %{name}-%{version} vanessa_logger-devel
Provides: %{name}-devel-%{version}


%description devel
Headers and static libraries required to develop against vanessa_adt.

%prep
%setup

%build

# I am providing my own configure macro replacement. Hopefully this
# will result in fewer portability problems than using the one supplied
# by various vendours. I fear that I hope in vein.
CFLAGS="${CFLAGS:-%optflags}" ; export CFLAGS
if [ -f confgure.in ]; then
	aclocal
	libtoolize --force --copy
	autoheader
	automake
	autoconf
fi
./configure %{_target_platform} \
       --prefix=%{_prefix} \
       --exec-prefix=%{_exec_prefix} \
       --bindir=%{_bindir} \
       --sbindir=%{_sbindir} \
       --sysconfdir=%{_sysconfdir} \
       --datadir=%{_datadir} \
       --includedir=%{_includedir} \
       --libdir=%{_libdir} \
       --libexecdir=%{_libexecdir} \
       --localstatedir=%{_localstatedir} \
       --sharedstatedir=%{_sharedstatedir} \
       --mandir=%{_mandir} \
       --infodir=%{_infodir}

make

%install
rm -rf ${RPM_BUILD_ROOT}
mkdir -p ${RPM_BUILD_ROOT}/{etc,%{prefix}/{lib,bin,doc}}
make DESTDIR=$RPM_BUILD_ROOT install


%clean
rm -rf $RPM_BUILD_ROOT


%post

%postun

%preun

%files
%defattr(-, root, root)
%{_libdir}/*.so*

%files devel
%defattr(-, root, root)
%{_libdir}/*.*a
%{_includedir}/*.h
%doc README COPYING ChangeLog

%changelog
* Fri Dec 14 2001 Horms <horms@verge.net.au>
  Revamped configure to use %{_libdir} and friends. This should be more
  distribution indepentant. With thanks to Scot W. Hetzel <scot@genroco.com>

* Sat Sep 2 2000 Horms <horms@verge.net.au>
  created for version 0.0.0
