/* valagenietokentype.vala
 *
 * Copyright (C) 2008  Jamie McCracken, Jürg Billeter
 * Based on code by Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jamie McCracken jamiemcc gnome org
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define VALA_GENIE_TYPE_TOKEN_TYPE (vala_genie_token_type_get_type ())

typedef enum  {
	VALA_GENIE_TOKEN_TYPE_NONE,
	VALA_GENIE_TOKEN_TYPE_ABSTRACT,
	VALA_GENIE_TOKEN_TYPE_ARRAY,
	VALA_GENIE_TOKEN_TYPE_AS,
	VALA_GENIE_TOKEN_TYPE_ASSERT,
	VALA_GENIE_TOKEN_TYPE_ASSIGN,
	VALA_GENIE_TOKEN_TYPE_ASSIGN_ADD,
	VALA_GENIE_TOKEN_TYPE_ASSIGN_BITWISE_AND,
	VALA_GENIE_TOKEN_TYPE_ASSIGN_BITWISE_OR,
	VALA_GENIE_TOKEN_TYPE_ASSIGN_BITWISE_XOR,
	VALA_GENIE_TOKEN_TYPE_ASSIGN_DIV,
	VALA_GENIE_TOKEN_TYPE_ASSIGN_MUL,
	VALA_GENIE_TOKEN_TYPE_ASSIGN_PERCENT,
	VALA_GENIE_TOKEN_TYPE_ASSIGN_SHIFT_LEFT,
	VALA_GENIE_TOKEN_TYPE_ASSIGN_SUB,
	VALA_GENIE_TOKEN_TYPE_BITWISE_AND,
	VALA_GENIE_TOKEN_TYPE_BITWISE_OR,
	VALA_GENIE_TOKEN_TYPE_BREAK,
	VALA_GENIE_TOKEN_TYPE_CARRET,
	VALA_GENIE_TOKEN_TYPE_CASE,
	VALA_GENIE_TOKEN_TYPE_CHARACTER_LITERAL,
	VALA_GENIE_TOKEN_TYPE_CLASS,
	VALA_GENIE_TOKEN_TYPE_CLOSE_BRACE,
	VALA_GENIE_TOKEN_TYPE_CLOSE_BRACKET,
	VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS,
	VALA_GENIE_TOKEN_TYPE_COLON,
	VALA_GENIE_TOKEN_TYPE_COMMA,
	VALA_GENIE_TOKEN_TYPE_CONST,
	VALA_GENIE_TOKEN_TYPE_CONSTRUCT,
	VALA_GENIE_TOKEN_TYPE_CONTINUE,
	VALA_GENIE_TOKEN_TYPE_DEDENT,
	VALA_GENIE_TOKEN_TYPE_DEF,
	VALA_GENIE_TOKEN_TYPE_DEFAULT,
	VALA_GENIE_TOKEN_TYPE_DELEGATE,
	VALA_GENIE_TOKEN_TYPE_DELETE,
	VALA_GENIE_TOKEN_TYPE_DICT,
	VALA_GENIE_TOKEN_TYPE_DIV,
	VALA_GENIE_TOKEN_TYPE_DO,
	VALA_GENIE_TOKEN_TYPE_DOT,
	VALA_GENIE_TOKEN_TYPE_DOWNTO,
	VALA_GENIE_TOKEN_TYPE_DYNAMIC,
	VALA_GENIE_TOKEN_TYPE_ELLIPSIS,
	VALA_GENIE_TOKEN_TYPE_ELSE,
	VALA_GENIE_TOKEN_TYPE_ENUM,
	VALA_GENIE_TOKEN_TYPE_ENSURES,
	VALA_GENIE_TOKEN_TYPE_ERRORDOMAIN,
	VALA_GENIE_TOKEN_TYPE_EOF,
	VALA_GENIE_TOKEN_TYPE_EOL,
	VALA_GENIE_TOKEN_TYPE_EVENT,
	VALA_GENIE_TOKEN_TYPE_EXCEPT,
	VALA_GENIE_TOKEN_TYPE_EXTERN,
	VALA_GENIE_TOKEN_TYPE_FALSE,
	VALA_GENIE_TOKEN_TYPE_FINAL,
	VALA_GENIE_TOKEN_TYPE_FINALLY,
	VALA_GENIE_TOKEN_TYPE_FOR,
	VALA_GENIE_TOKEN_TYPE_FOREACH,
	VALA_GENIE_TOKEN_TYPE_GET,
	VALA_GENIE_TOKEN_TYPE_HASH,
	VALA_GENIE_TOKEN_TYPE_IDENTIFIER,
	VALA_GENIE_TOKEN_TYPE_IF,
	VALA_GENIE_TOKEN_TYPE_IMPLEMENTS,
	VALA_GENIE_TOKEN_TYPE_IN,
	VALA_GENIE_TOKEN_TYPE_INDENT,
	VALA_GENIE_TOKEN_TYPE_INIT,
	VALA_GENIE_TOKEN_TYPE_INLINE,
	VALA_GENIE_TOKEN_TYPE_INTEGER_LITERAL,
	VALA_GENIE_TOKEN_TYPE_INTERFACE,
	VALA_GENIE_TOKEN_TYPE_INTERR,
	VALA_GENIE_TOKEN_TYPE_IS,
	VALA_GENIE_TOKEN_TYPE_ISA,
	VALA_GENIE_TOKEN_TYPE_LAMBDA,
	VALA_GENIE_TOKEN_TYPE_LIST,
	VALA_GENIE_TOKEN_TYPE_LOCK,
	VALA_GENIE_TOKEN_TYPE_MINUS,
	VALA_GENIE_TOKEN_TYPE_NAMESPACE,
	VALA_GENIE_TOKEN_TYPE_NEW,
	VALA_GENIE_TOKEN_TYPE_NULL,
	VALA_GENIE_TOKEN_TYPE_OF,
	VALA_GENIE_TOKEN_TYPE_OUT,
	VALA_GENIE_TOKEN_TYPE_OP_AND,
	VALA_GENIE_TOKEN_TYPE_OP_DEC,
	VALA_GENIE_TOKEN_TYPE_OP_EQ,
	VALA_GENIE_TOKEN_TYPE_OP_GE,
	VALA_GENIE_TOKEN_TYPE_OP_GT,
	VALA_GENIE_TOKEN_TYPE_OP_INC,
	VALA_GENIE_TOKEN_TYPE_OP_LE,
	VALA_GENIE_TOKEN_TYPE_OP_LT,
	VALA_GENIE_TOKEN_TYPE_OP_NE,
	VALA_GENIE_TOKEN_TYPE_OP_NEG,
	VALA_GENIE_TOKEN_TYPE_OP_OR,
	VALA_GENIE_TOKEN_TYPE_OP_PTR,
	VALA_GENIE_TOKEN_TYPE_OP_SHIFT_LEFT,
	VALA_GENIE_TOKEN_TYPE_OPEN_BRACE,
	VALA_GENIE_TOKEN_TYPE_OPEN_BRACKET,
	VALA_GENIE_TOKEN_TYPE_OPEN_PARENS,
	VALA_GENIE_TOKEN_TYPE_OVERRIDE,
	VALA_GENIE_TOKEN_TYPE_PASS,
	VALA_GENIE_TOKEN_TYPE_PERCENT,
	VALA_GENIE_TOKEN_TYPE_PLUS,
	VALA_GENIE_TOKEN_TYPE_PRINT,
	VALA_GENIE_TOKEN_TYPE_PRIVATE,
	VALA_GENIE_TOKEN_TYPE_PROP,
	VALA_GENIE_TOKEN_TYPE_PROTECTED,
	VALA_GENIE_TOKEN_TYPE_PUBLIC,
	VALA_GENIE_TOKEN_TYPE_RAISE,
	VALA_GENIE_TOKEN_TYPE_RAISES,
	VALA_GENIE_TOKEN_TYPE_REAL_LITERAL,
	VALA_GENIE_TOKEN_TYPE_READONLY,
	VALA_GENIE_TOKEN_TYPE_REF,
	VALA_GENIE_TOKEN_TYPE_REQUIRES,
	VALA_GENIE_TOKEN_TYPE_RETURN,
	VALA_GENIE_TOKEN_TYPE_SEMICOLON,
	VALA_GENIE_TOKEN_TYPE_SET,
	VALA_GENIE_TOKEN_TYPE_SIZEOF,
	VALA_GENIE_TOKEN_TYPE_STAR,
	VALA_GENIE_TOKEN_TYPE_STATIC,
	VALA_GENIE_TOKEN_TYPE_STRING_LITERAL,
	VALA_GENIE_TOKEN_TYPE_STRUCT,
	VALA_GENIE_TOKEN_TYPE_SUPER,
	VALA_GENIE_TOKEN_TYPE_THIS,
	VALA_GENIE_TOKEN_TYPE_TILDE,
	VALA_GENIE_TOKEN_TYPE_TO,
	VALA_GENIE_TOKEN_TYPE_TRUE,
	VALA_GENIE_TOKEN_TYPE_TRY,
	VALA_GENIE_TOKEN_TYPE_TYPEOF,
	VALA_GENIE_TOKEN_TYPE_USES,
	VALA_GENIE_TOKEN_TYPE_VAR,
	VALA_GENIE_TOKEN_TYPE_VIRTUAL,
	VALA_GENIE_TOKEN_TYPE_VOID,
	VALA_GENIE_TOKEN_TYPE_VOLATILE,
	VALA_GENIE_TOKEN_TYPE_WEAK,
	VALA_GENIE_TOKEN_TYPE_WHEN,
	VALA_GENIE_TOKEN_TYPE_WHILE,
	VALA_GENIE_TOKEN_TYPE_WRITEONLY
} ValaGenieTokenType;



GType vala_genie_token_type_get_type (void);
const char* vala_genie_token_type_to_string (ValaGenieTokenType self);



const char* vala_genie_token_type_to_string (ValaGenieTokenType self) {
	switch (self) {
		case VALA_GENIE_TOKEN_TYPE_ABSTRACT:
		{
			return "`abstract'";
		}
		case VALA_GENIE_TOKEN_TYPE_ARRAY:
		{
			return "`array'";
		}
		case VALA_GENIE_TOKEN_TYPE_AS:
		{
			return "`as'";
		}
		case VALA_GENIE_TOKEN_TYPE_ASSERT:
		{
			return "`assert'";
		}
		case VALA_GENIE_TOKEN_TYPE_ASSIGN:
		{
			return "`='";
		}
		case VALA_GENIE_TOKEN_TYPE_ASSIGN_ADD:
		{
			return "`+='";
		}
		case VALA_GENIE_TOKEN_TYPE_ASSIGN_BITWISE_AND:
		{
			return "`&='";
		}
		case VALA_GENIE_TOKEN_TYPE_ASSIGN_BITWISE_OR:
		{
			return "`|='";
		}
		case VALA_GENIE_TOKEN_TYPE_ASSIGN_BITWISE_XOR:
		{
			return "`^='";
		}
		case VALA_GENIE_TOKEN_TYPE_ASSIGN_DIV:
		{
			return "`/='";
		}
		case VALA_GENIE_TOKEN_TYPE_ASSIGN_MUL:
		{
			return "`*='";
		}
		case VALA_GENIE_TOKEN_TYPE_ASSIGN_PERCENT:
		{
			return "`%='";
		}
		case VALA_GENIE_TOKEN_TYPE_ASSIGN_SHIFT_LEFT:
		{
			return "`<<='";
		}
		case VALA_GENIE_TOKEN_TYPE_ASSIGN_SUB:
		{
			return "`-='";
		}
		case VALA_GENIE_TOKEN_TYPE_BITWISE_AND:
		{
			return "`&'";
		}
		case VALA_GENIE_TOKEN_TYPE_BITWISE_OR:
		{
			return "`|'";
		}
		case VALA_GENIE_TOKEN_TYPE_BREAK:
		{
			return "`break'";
		}
		case VALA_GENIE_TOKEN_TYPE_CARRET:
		{
			return "`^'";
		}
		case VALA_GENIE_TOKEN_TYPE_CASE:
		{
			return "`case'";
		}
		case VALA_GENIE_TOKEN_TYPE_CHARACTER_LITERAL:
		{
			return "character literal";
		}
		case VALA_GENIE_TOKEN_TYPE_CLASS:
		{
			return "`class'";
		}
		case VALA_GENIE_TOKEN_TYPE_CLOSE_BRACE:
		{
			return "`}'";
		}
		case VALA_GENIE_TOKEN_TYPE_CLOSE_BRACKET:
		{
			return "`]'";
		}
		case VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS:
		{
			return "`)'";
		}
		case VALA_GENIE_TOKEN_TYPE_COLON:
		{
			return "`:'";
		}
		case VALA_GENIE_TOKEN_TYPE_COMMA:
		{
			return "`,'";
		}
		case VALA_GENIE_TOKEN_TYPE_CONST:
		{
			return "`const'";
		}
		case VALA_GENIE_TOKEN_TYPE_CONSTRUCT:
		{
			return "`construct'";
		}
		case VALA_GENIE_TOKEN_TYPE_CONTINUE:
		{
			return "`continue'";
		}
		case VALA_GENIE_TOKEN_TYPE_DEDENT:
		{
			return "`dedent'";
		}
		case VALA_GENIE_TOKEN_TYPE_DEF:
		{
			return "`def'";
		}
		case VALA_GENIE_TOKEN_TYPE_DEFAULT:
		{
			return "`default'";
		}
		case VALA_GENIE_TOKEN_TYPE_DELEGATE:
		{
			return "`delegate'";
		}
		case VALA_GENIE_TOKEN_TYPE_DELETE:
		{
			return "`delete'";
		}
		case VALA_GENIE_TOKEN_TYPE_DICT:
		{
			return "`dict'";
		}
		case VALA_GENIE_TOKEN_TYPE_DIV:
		{
			return "`/'";
		}
		case VALA_GENIE_TOKEN_TYPE_DO:
		{
			return "`do'";
		}
		case VALA_GENIE_TOKEN_TYPE_DOT:
		{
			return "`.'";
		}
		case VALA_GENIE_TOKEN_TYPE_DOWNTO:
		{
			return "`downto'";
		}
		case VALA_GENIE_TOKEN_TYPE_DYNAMIC:
		{
			return "`dynamic'";
		}
		case VALA_GENIE_TOKEN_TYPE_ELLIPSIS:
		{
			return "`...'";
		}
		case VALA_GENIE_TOKEN_TYPE_ELSE:
		{
			return "`else'";
		}
		case VALA_GENIE_TOKEN_TYPE_ENUM:
		{
			return "`enum'";
		}
		case VALA_GENIE_TOKEN_TYPE_ENSURES:
		{
			return "`ensures'";
		}
		case VALA_GENIE_TOKEN_TYPE_ERRORDOMAIN:
		{
			return "`errordomain'";
		}
		case VALA_GENIE_TOKEN_TYPE_EOF:
		{
			return "end of file";
		}
		case VALA_GENIE_TOKEN_TYPE_EOL:
		{
			return "end of line";
		}
		case VALA_GENIE_TOKEN_TYPE_EVENT:
		{
			return "event";
		}
		case VALA_GENIE_TOKEN_TYPE_EXCEPT:
		{
			return "`except'";
		}
		case VALA_GENIE_TOKEN_TYPE_EXTERN:
		{
			return "`extern'";
		}
		case VALA_GENIE_TOKEN_TYPE_FALSE:
		{
			return "`false'";
		}
		case VALA_GENIE_TOKEN_TYPE_FINAL:
		{
			return "`final'";
		}
		case VALA_GENIE_TOKEN_TYPE_FINALLY:
		{
			return "`finally'";
		}
		case VALA_GENIE_TOKEN_TYPE_FOR:
		{
			return "`for'";
		}
		case VALA_GENIE_TOKEN_TYPE_FOREACH:
		{
			return "`foreach'";
		}
		case VALA_GENIE_TOKEN_TYPE_GET:
		{
			return "`get'";
		}
		case VALA_GENIE_TOKEN_TYPE_HASH:
		{
			return "`hash'";
		}
		case VALA_GENIE_TOKEN_TYPE_IDENTIFIER:
		{
			return "identifier";
		}
		case VALA_GENIE_TOKEN_TYPE_IF:
		{
			return "`if'";
		}
		case VALA_GENIE_TOKEN_TYPE_IMPLEMENTS:
		{
			return "`implements'";
		}
		case VALA_GENIE_TOKEN_TYPE_IN:
		{
			return "`in'";
		}
		case VALA_GENIE_TOKEN_TYPE_INDENT:
		{
			return "`tab indent'";
		}
		case VALA_GENIE_TOKEN_TYPE_INIT:
		{
			return "`init'";
		}
		case VALA_GENIE_TOKEN_TYPE_INLINE:
		{
			return "`inline'";
		}
		case VALA_GENIE_TOKEN_TYPE_INTEGER_LITERAL:
		{
			return "integer literal";
		}
		case VALA_GENIE_TOKEN_TYPE_INTERFACE:
		{
			return "`interface'";
		}
		case VALA_GENIE_TOKEN_TYPE_INTERR:
		{
			return "`?'";
		}
		case VALA_GENIE_TOKEN_TYPE_IS:
		{
			return "`is'";
		}
		case VALA_GENIE_TOKEN_TYPE_ISA:
		{
			return "`isa'";
		}
		case VALA_GENIE_TOKEN_TYPE_LAMBDA:
		{
			return "`=>'";
		}
		case VALA_GENIE_TOKEN_TYPE_LIST:
		{
			return "`list'";
		}
		case VALA_GENIE_TOKEN_TYPE_LOCK:
		{
			return "`lock'";
		}
		case VALA_GENIE_TOKEN_TYPE_MINUS:
		{
			return "`-'";
		}
		case VALA_GENIE_TOKEN_TYPE_NAMESPACE:
		{
			return "`namespace'";
		}
		case VALA_GENIE_TOKEN_TYPE_NEW:
		{
			return "`new'";
		}
		case VALA_GENIE_TOKEN_TYPE_NULL:
		{
			return "`null'";
		}
		case VALA_GENIE_TOKEN_TYPE_OF:
		{
			return "`of'";
		}
		case VALA_GENIE_TOKEN_TYPE_OUT:
		{
			return "`out'";
		}
		case VALA_GENIE_TOKEN_TYPE_OP_AND:
		{
			return "`&&'";
		}
		case VALA_GENIE_TOKEN_TYPE_OP_DEC:
		{
			return "`--'";
		}
		case VALA_GENIE_TOKEN_TYPE_OP_EQ:
		{
			return "`=='";
		}
		case VALA_GENIE_TOKEN_TYPE_OP_GE:
		{
			return "`>='";
		}
		case VALA_GENIE_TOKEN_TYPE_OP_GT:
		{
			return "`>'";
		}
		case VALA_GENIE_TOKEN_TYPE_OP_INC:
		{
			return "`++'";
		}
		case VALA_GENIE_TOKEN_TYPE_OP_LE:
		{
			return "`<='";
		}
		case VALA_GENIE_TOKEN_TYPE_OP_LT:
		{
			return "`<'";
		}
		case VALA_GENIE_TOKEN_TYPE_OP_NE:
		{
			return "`!='";
		}
		case VALA_GENIE_TOKEN_TYPE_OP_NEG:
		{
			return "`!'";
		}
		case VALA_GENIE_TOKEN_TYPE_OP_OR:
		{
			return "`||'";
		}
		case VALA_GENIE_TOKEN_TYPE_OP_PTR:
		{
			return "`->'";
		}
		case VALA_GENIE_TOKEN_TYPE_OP_SHIFT_LEFT:
		{
			return "`<<'";
		}
		case VALA_GENIE_TOKEN_TYPE_OPEN_BRACE:
		{
			return "`{'";
		}
		case VALA_GENIE_TOKEN_TYPE_OPEN_BRACKET:
		{
			return "`['";
		}
		case VALA_GENIE_TOKEN_TYPE_OPEN_PARENS:
		{
			return "`('";
		}
		case VALA_GENIE_TOKEN_TYPE_OVERRIDE:
		{
			return "`override'";
		}
		case VALA_GENIE_TOKEN_TYPE_PASS:
		{
			return "`pass'";
		}
		case VALA_GENIE_TOKEN_TYPE_PERCENT:
		{
			return "`%'";
		}
		case VALA_GENIE_TOKEN_TYPE_PLUS:
		{
			return "`+'";
		}
		case VALA_GENIE_TOKEN_TYPE_PRINT:
		{
			return "`print'";
		}
		case VALA_GENIE_TOKEN_TYPE_PRIVATE:
		{
			return "`private'";
		}
		case VALA_GENIE_TOKEN_TYPE_PROP:
		{
			return "`prop'";
		}
		case VALA_GENIE_TOKEN_TYPE_PROTECTED:
		{
			return "`protected'";
		}
		case VALA_GENIE_TOKEN_TYPE_PUBLIC:
		{
			return "`public'";
		}
		case VALA_GENIE_TOKEN_TYPE_RAISE:
		{
			return "`raise'";
		}
		case VALA_GENIE_TOKEN_TYPE_RAISES:
		{
			return "`raises'";
		}
		case VALA_GENIE_TOKEN_TYPE_READONLY:
		{
			return "`readonly'";
		}
		case VALA_GENIE_TOKEN_TYPE_REAL_LITERAL:
		{
			return "real literal";
		}
		case VALA_GENIE_TOKEN_TYPE_REF:
		{
			return "`ref'";
		}
		case VALA_GENIE_TOKEN_TYPE_REQUIRES:
		{
			return "`requires'";
		}
		case VALA_GENIE_TOKEN_TYPE_RETURN:
		{
			return "`return'";
		}
		case VALA_GENIE_TOKEN_TYPE_SEMICOLON:
		{
			return "`;'";
		}
		case VALA_GENIE_TOKEN_TYPE_SET:
		{
			return "`set'";
		}
		case VALA_GENIE_TOKEN_TYPE_SIZEOF:
		{
			return "`sizeof'";
		}
		case VALA_GENIE_TOKEN_TYPE_STAR:
		{
			return "`*'";
		}
		case VALA_GENIE_TOKEN_TYPE_STATIC:
		{
			return "`static'";
		}
		case VALA_GENIE_TOKEN_TYPE_STRING_LITERAL:
		{
			return "string literal";
		}
		case VALA_GENIE_TOKEN_TYPE_STRUCT:
		{
			return "`struct'";
		}
		case VALA_GENIE_TOKEN_TYPE_SUPER:
		{
			return "`super'";
		}
		case VALA_GENIE_TOKEN_TYPE_THIS:
		{
			return "`self'";
		}
		case VALA_GENIE_TOKEN_TYPE_TILDE:
		{
			return "`~'";
		}
		case VALA_GENIE_TOKEN_TYPE_TO:
		{
			return "`to'";
		}
		case VALA_GENIE_TOKEN_TYPE_TRUE:
		{
			return "`true'";
		}
		case VALA_GENIE_TOKEN_TYPE_TRY:
		{
			return "`try'";
		}
		case VALA_GENIE_TOKEN_TYPE_TYPEOF:
		{
			return "`typeof'";
		}
		case VALA_GENIE_TOKEN_TYPE_USES:
		{
			return "`uses'";
		}
		case VALA_GENIE_TOKEN_TYPE_VAR:
		{
			return "`var'";
		}
		case VALA_GENIE_TOKEN_TYPE_VIRTUAL:
		{
			return "`virtual'";
		}
		case VALA_GENIE_TOKEN_TYPE_VOID:
		{
			return "`void'";
		}
		case VALA_GENIE_TOKEN_TYPE_VOLATILE:
		{
			return "`volatile'";
		}
		case VALA_GENIE_TOKEN_TYPE_WEAK:
		{
			return "`weak'";
		}
		case VALA_GENIE_TOKEN_TYPE_WHEN:
		{
			return "`when'";
		}
		case VALA_GENIE_TOKEN_TYPE_WHILE:
		{
			return "`while'";
		}
		case VALA_GENIE_TOKEN_TYPE_WRITEONLY:
		{
			return "`writeonly'";
		}
		default:
		{
			return "unknown token";
		}
	}
}



GType vala_genie_token_type_get_type (void) {
	static GType vala_genie_token_type_type_id = 0;
	if (G_UNLIKELY (vala_genie_token_type_type_id == 0)) {
		static const GEnumValue values[] = {{VALA_GENIE_TOKEN_TYPE_NONE, "VALA_GENIE_TOKEN_TYPE_NONE", "none"}, {VALA_GENIE_TOKEN_TYPE_ABSTRACT, "VALA_GENIE_TOKEN_TYPE_ABSTRACT", "abstract"}, {VALA_GENIE_TOKEN_TYPE_ARRAY, "VALA_GENIE_TOKEN_TYPE_ARRAY", "array"}, {VALA_GENIE_TOKEN_TYPE_AS, "VALA_GENIE_TOKEN_TYPE_AS", "as"}, {VALA_GENIE_TOKEN_TYPE_ASSERT, "VALA_GENIE_TOKEN_TYPE_ASSERT", "assert"}, {VALA_GENIE_TOKEN_TYPE_ASSIGN, "VALA_GENIE_TOKEN_TYPE_ASSIGN", "assign"}, {VALA_GENIE_TOKEN_TYPE_ASSIGN_ADD, "VALA_GENIE_TOKEN_TYPE_ASSIGN_ADD", "assign-add"}, {VALA_GENIE_TOKEN_TYPE_ASSIGN_BITWISE_AND, "VALA_GENIE_TOKEN_TYPE_ASSIGN_BITWISE_AND", "assign-bitwise-and"}, {VALA_GENIE_TOKEN_TYPE_ASSIGN_BITWISE_OR, "VALA_GENIE_TOKEN_TYPE_ASSIGN_BITWISE_OR", "assign-bitwise-or"}, {VALA_GENIE_TOKEN_TYPE_ASSIGN_BITWISE_XOR, "VALA_GENIE_TOKEN_TYPE_ASSIGN_BITWISE_XOR", "assign-bitwise-xor"}, {VALA_GENIE_TOKEN_TYPE_ASSIGN_DIV, "VALA_GENIE_TOKEN_TYPE_ASSIGN_DIV", "assign-div"}, {VALA_GENIE_TOKEN_TYPE_ASSIGN_MUL, "VALA_GENIE_TOKEN_TYPE_ASSIGN_MUL", "assign-mul"}, {VALA_GENIE_TOKEN_TYPE_ASSIGN_PERCENT, "VALA_GENIE_TOKEN_TYPE_ASSIGN_PERCENT", "assign-percent"}, {VALA_GENIE_TOKEN_TYPE_ASSIGN_SHIFT_LEFT, "VALA_GENIE_TOKEN_TYPE_ASSIGN_SHIFT_LEFT", "assign-shift-left"}, {VALA_GENIE_TOKEN_TYPE_ASSIGN_SUB, "VALA_GENIE_TOKEN_TYPE_ASSIGN_SUB", "assign-sub"}, {VALA_GENIE_TOKEN_TYPE_BITWISE_AND, "VALA_GENIE_TOKEN_TYPE_BITWISE_AND", "bitwise-and"}, {VALA_GENIE_TOKEN_TYPE_BITWISE_OR, "VALA_GENIE_TOKEN_TYPE_BITWISE_OR", "bitwise-or"}, {VALA_GENIE_TOKEN_TYPE_BREAK, "VALA_GENIE_TOKEN_TYPE_BREAK", "break"}, {VALA_GENIE_TOKEN_TYPE_CARRET, "VALA_GENIE_TOKEN_TYPE_CARRET", "carret"}, {VALA_GENIE_TOKEN_TYPE_CASE, "VALA_GENIE_TOKEN_TYPE_CASE", "case"}, {VALA_GENIE_TOKEN_TYPE_CHARACTER_LITERAL, "VALA_GENIE_TOKEN_TYPE_CHARACTER_LITERAL", "character-literal"}, {VALA_GENIE_TOKEN_TYPE_CLASS, "VALA_GENIE_TOKEN_TYPE_CLASS", "class"}, {VALA_GENIE_TOKEN_TYPE_CLOSE_BRACE, "VALA_GENIE_TOKEN_TYPE_CLOSE_BRACE", "close-brace"}, {VALA_GENIE_TOKEN_TYPE_CLOSE_BRACKET, "VALA_GENIE_TOKEN_TYPE_CLOSE_BRACKET", "close-bracket"}, {VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS, "VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS", "close-parens"}, {VALA_GENIE_TOKEN_TYPE_COLON, "VALA_GENIE_TOKEN_TYPE_COLON", "colon"}, {VALA_GENIE_TOKEN_TYPE_COMMA, "VALA_GENIE_TOKEN_TYPE_COMMA", "comma"}, {VALA_GENIE_TOKEN_TYPE_CONST, "VALA_GENIE_TOKEN_TYPE_CONST", "const"}, {VALA_GENIE_TOKEN_TYPE_CONSTRUCT, "VALA_GENIE_TOKEN_TYPE_CONSTRUCT", "construct"}, {VALA_GENIE_TOKEN_TYPE_CONTINUE, "VALA_GENIE_TOKEN_TYPE_CONTINUE", "continue"}, {VALA_GENIE_TOKEN_TYPE_DEDENT, "VALA_GENIE_TOKEN_TYPE_DEDENT", "dedent"}, {VALA_GENIE_TOKEN_TYPE_DEF, "VALA_GENIE_TOKEN_TYPE_DEF", "def"}, {VALA_GENIE_TOKEN_TYPE_DEFAULT, "VALA_GENIE_TOKEN_TYPE_DEFAULT", "default"}, {VALA_GENIE_TOKEN_TYPE_DELEGATE, "VALA_GENIE_TOKEN_TYPE_DELEGATE", "delegate"}, {VALA_GENIE_TOKEN_TYPE_DELETE, "VALA_GENIE_TOKEN_TYPE_DELETE", "delete"}, {VALA_GENIE_TOKEN_TYPE_DICT, "VALA_GENIE_TOKEN_TYPE_DICT", "dict"}, {VALA_GENIE_TOKEN_TYPE_DIV, "VALA_GENIE_TOKEN_TYPE_DIV", "div"}, {VALA_GENIE_TOKEN_TYPE_DO, "VALA_GENIE_TOKEN_TYPE_DO", "do"}, {VALA_GENIE_TOKEN_TYPE_DOT, "VALA_GENIE_TOKEN_TYPE_DOT", "dot"}, {VALA_GENIE_TOKEN_TYPE_DOWNTO, "VALA_GENIE_TOKEN_TYPE_DOWNTO", "downto"}, {VALA_GENIE_TOKEN_TYPE_DYNAMIC, "VALA_GENIE_TOKEN_TYPE_DYNAMIC", "dynamic"}, {VALA_GENIE_TOKEN_TYPE_ELLIPSIS, "VALA_GENIE_TOKEN_TYPE_ELLIPSIS", "ellipsis"}, {VALA_GENIE_TOKEN_TYPE_ELSE, "VALA_GENIE_TOKEN_TYPE_ELSE", "else"}, {VALA_GENIE_TOKEN_TYPE_ENUM, "VALA_GENIE_TOKEN_TYPE_ENUM", "enum"}, {VALA_GENIE_TOKEN_TYPE_ENSURES, "VALA_GENIE_TOKEN_TYPE_ENSURES", "ensures"}, {VALA_GENIE_TOKEN_TYPE_ERRORDOMAIN, "VALA_GENIE_TOKEN_TYPE_ERRORDOMAIN", "errordomain"}, {VALA_GENIE_TOKEN_TYPE_EOF, "VALA_GENIE_TOKEN_TYPE_EOF", "eof"}, {VALA_GENIE_TOKEN_TYPE_EOL, "VALA_GENIE_TOKEN_TYPE_EOL", "eol"}, {VALA_GENIE_TOKEN_TYPE_EVENT, "VALA_GENIE_TOKEN_TYPE_EVENT", "event"}, {VALA_GENIE_TOKEN_TYPE_EXCEPT, "VALA_GENIE_TOKEN_TYPE_EXCEPT", "except"}, {VALA_GENIE_TOKEN_TYPE_EXTERN, "VALA_GENIE_TOKEN_TYPE_EXTERN", "extern"}, {VALA_GENIE_TOKEN_TYPE_FALSE, "VALA_GENIE_TOKEN_TYPE_FALSE", "false"}, {VALA_GENIE_TOKEN_TYPE_FINAL, "VALA_GENIE_TOKEN_TYPE_FINAL", "final"}, {VALA_GENIE_TOKEN_TYPE_FINALLY, "VALA_GENIE_TOKEN_TYPE_FINALLY", "finally"}, {VALA_GENIE_TOKEN_TYPE_FOR, "VALA_GENIE_TOKEN_TYPE_FOR", "for"}, {VALA_GENIE_TOKEN_TYPE_FOREACH, "VALA_GENIE_TOKEN_TYPE_FOREACH", "foreach"}, {VALA_GENIE_TOKEN_TYPE_GET, "VALA_GENIE_TOKEN_TYPE_GET", "get"}, {VALA_GENIE_TOKEN_TYPE_HASH, "VALA_GENIE_TOKEN_TYPE_HASH", "hash"}, {VALA_GENIE_TOKEN_TYPE_IDENTIFIER, "VALA_GENIE_TOKEN_TYPE_IDENTIFIER", "identifier"}, {VALA_GENIE_TOKEN_TYPE_IF, "VALA_GENIE_TOKEN_TYPE_IF", "if"}, {VALA_GENIE_TOKEN_TYPE_IMPLEMENTS, "VALA_GENIE_TOKEN_TYPE_IMPLEMENTS", "implements"}, {VALA_GENIE_TOKEN_TYPE_IN, "VALA_GENIE_TOKEN_TYPE_IN", "in"}, {VALA_GENIE_TOKEN_TYPE_INDENT, "VALA_GENIE_TOKEN_TYPE_INDENT", "indent"}, {VALA_GENIE_TOKEN_TYPE_INIT, "VALA_GENIE_TOKEN_TYPE_INIT", "init"}, {VALA_GENIE_TOKEN_TYPE_INLINE, "VALA_GENIE_TOKEN_TYPE_INLINE", "inline"}, {VALA_GENIE_TOKEN_TYPE_INTEGER_LITERAL, "VALA_GENIE_TOKEN_TYPE_INTEGER_LITERAL", "integer-literal"}, {VALA_GENIE_TOKEN_TYPE_INTERFACE, "VALA_GENIE_TOKEN_TYPE_INTERFACE", "interface"}, {VALA_GENIE_TOKEN_TYPE_INTERR, "VALA_GENIE_TOKEN_TYPE_INTERR", "interr"}, {VALA_GENIE_TOKEN_TYPE_IS, "VALA_GENIE_TOKEN_TYPE_IS", "is"}, {VALA_GENIE_TOKEN_TYPE_ISA, "VALA_GENIE_TOKEN_TYPE_ISA", "isa"}, {VALA_GENIE_TOKEN_TYPE_LAMBDA, "VALA_GENIE_TOKEN_TYPE_LAMBDA", "lambda"}, {VALA_GENIE_TOKEN_TYPE_LIST, "VALA_GENIE_TOKEN_TYPE_LIST", "list"}, {VALA_GENIE_TOKEN_TYPE_LOCK, "VALA_GENIE_TOKEN_TYPE_LOCK", "lock"}, {VALA_GENIE_TOKEN_TYPE_MINUS, "VALA_GENIE_TOKEN_TYPE_MINUS", "minus"}, {VALA_GENIE_TOKEN_TYPE_NAMESPACE, "VALA_GENIE_TOKEN_TYPE_NAMESPACE", "namespace"}, {VALA_GENIE_TOKEN_TYPE_NEW, "VALA_GENIE_TOKEN_TYPE_NEW", "new"}, {VALA_GENIE_TOKEN_TYPE_NULL, "VALA_GENIE_TOKEN_TYPE_NULL", "null"}, {VALA_GENIE_TOKEN_TYPE_OF, "VALA_GENIE_TOKEN_TYPE_OF", "of"}, {VALA_GENIE_TOKEN_TYPE_OUT, "VALA_GENIE_TOKEN_TYPE_OUT", "out"}, {VALA_GENIE_TOKEN_TYPE_OP_AND, "VALA_GENIE_TOKEN_TYPE_OP_AND", "op-and"}, {VALA_GENIE_TOKEN_TYPE_OP_DEC, "VALA_GENIE_TOKEN_TYPE_OP_DEC", "op-dec"}, {VALA_GENIE_TOKEN_TYPE_OP_EQ, "VALA_GENIE_TOKEN_TYPE_OP_EQ", "op-eq"}, {VALA_GENIE_TOKEN_TYPE_OP_GE, "VALA_GENIE_TOKEN_TYPE_OP_GE", "op-ge"}, {VALA_GENIE_TOKEN_TYPE_OP_GT, "VALA_GENIE_TOKEN_TYPE_OP_GT", "op-gt"}, {VALA_GENIE_TOKEN_TYPE_OP_INC, "VALA_GENIE_TOKEN_TYPE_OP_INC", "op-inc"}, {VALA_GENIE_TOKEN_TYPE_OP_LE, "VALA_GENIE_TOKEN_TYPE_OP_LE", "op-le"}, {VALA_GENIE_TOKEN_TYPE_OP_LT, "VALA_GENIE_TOKEN_TYPE_OP_LT", "op-lt"}, {VALA_GENIE_TOKEN_TYPE_OP_NE, "VALA_GENIE_TOKEN_TYPE_OP_NE", "op-ne"}, {VALA_GENIE_TOKEN_TYPE_OP_NEG, "VALA_GENIE_TOKEN_TYPE_OP_NEG", "op-neg"}, {VALA_GENIE_TOKEN_TYPE_OP_OR, "VALA_GENIE_TOKEN_TYPE_OP_OR", "op-or"}, {VALA_GENIE_TOKEN_TYPE_OP_PTR, "VALA_GENIE_TOKEN_TYPE_OP_PTR", "op-ptr"}, {VALA_GENIE_TOKEN_TYPE_OP_SHIFT_LEFT, "VALA_GENIE_TOKEN_TYPE_OP_SHIFT_LEFT", "op-shift-left"}, {VALA_GENIE_TOKEN_TYPE_OPEN_BRACE, "VALA_GENIE_TOKEN_TYPE_OPEN_BRACE", "open-brace"}, {VALA_GENIE_TOKEN_TYPE_OPEN_BRACKET, "VALA_GENIE_TOKEN_TYPE_OPEN_BRACKET", "open-bracket"}, {VALA_GENIE_TOKEN_TYPE_OPEN_PARENS, "VALA_GENIE_TOKEN_TYPE_OPEN_PARENS", "open-parens"}, {VALA_GENIE_TOKEN_TYPE_OVERRIDE, "VALA_GENIE_TOKEN_TYPE_OVERRIDE", "override"}, {VALA_GENIE_TOKEN_TYPE_PASS, "VALA_GENIE_TOKEN_TYPE_PASS", "pass"}, {VALA_GENIE_TOKEN_TYPE_PERCENT, "VALA_GENIE_TOKEN_TYPE_PERCENT", "percent"}, {VALA_GENIE_TOKEN_TYPE_PLUS, "VALA_GENIE_TOKEN_TYPE_PLUS", "plus"}, {VALA_GENIE_TOKEN_TYPE_PRINT, "VALA_GENIE_TOKEN_TYPE_PRINT", "print"}, {VALA_GENIE_TOKEN_TYPE_PRIVATE, "VALA_GENIE_TOKEN_TYPE_PRIVATE", "private"}, {VALA_GENIE_TOKEN_TYPE_PROP, "VALA_GENIE_TOKEN_TYPE_PROP", "prop"}, {VALA_GENIE_TOKEN_TYPE_PROTECTED, "VALA_GENIE_TOKEN_TYPE_PROTECTED", "protected"}, {VALA_GENIE_TOKEN_TYPE_PUBLIC, "VALA_GENIE_TOKEN_TYPE_PUBLIC", "public"}, {VALA_GENIE_TOKEN_TYPE_RAISE, "VALA_GENIE_TOKEN_TYPE_RAISE", "raise"}, {VALA_GENIE_TOKEN_TYPE_RAISES, "VALA_GENIE_TOKEN_TYPE_RAISES", "raises"}, {VALA_GENIE_TOKEN_TYPE_REAL_LITERAL, "VALA_GENIE_TOKEN_TYPE_REAL_LITERAL", "real-literal"}, {VALA_GENIE_TOKEN_TYPE_READONLY, "VALA_GENIE_TOKEN_TYPE_READONLY", "readonly"}, {VALA_GENIE_TOKEN_TYPE_REF, "VALA_GENIE_TOKEN_TYPE_REF", "ref"}, {VALA_GENIE_TOKEN_TYPE_REQUIRES, "VALA_GENIE_TOKEN_TYPE_REQUIRES", "requires"}, {VALA_GENIE_TOKEN_TYPE_RETURN, "VALA_GENIE_TOKEN_TYPE_RETURN", "return"}, {VALA_GENIE_TOKEN_TYPE_SEMICOLON, "VALA_GENIE_TOKEN_TYPE_SEMICOLON", "semicolon"}, {VALA_GENIE_TOKEN_TYPE_SET, "VALA_GENIE_TOKEN_TYPE_SET", "set"}, {VALA_GENIE_TOKEN_TYPE_SIZEOF, "VALA_GENIE_TOKEN_TYPE_SIZEOF", "sizeof"}, {VALA_GENIE_TOKEN_TYPE_STAR, "VALA_GENIE_TOKEN_TYPE_STAR", "star"}, {VALA_GENIE_TOKEN_TYPE_STATIC, "VALA_GENIE_TOKEN_TYPE_STATIC", "static"}, {VALA_GENIE_TOKEN_TYPE_STRING_LITERAL, "VALA_GENIE_TOKEN_TYPE_STRING_LITERAL", "string-literal"}, {VALA_GENIE_TOKEN_TYPE_STRUCT, "VALA_GENIE_TOKEN_TYPE_STRUCT", "struct"}, {VALA_GENIE_TOKEN_TYPE_SUPER, "VALA_GENIE_TOKEN_TYPE_SUPER", "super"}, {VALA_GENIE_TOKEN_TYPE_THIS, "VALA_GENIE_TOKEN_TYPE_THIS", "this"}, {VALA_GENIE_TOKEN_TYPE_TILDE, "VALA_GENIE_TOKEN_TYPE_TILDE", "tilde"}, {VALA_GENIE_TOKEN_TYPE_TO, "VALA_GENIE_TOKEN_TYPE_TO", "to"}, {VALA_GENIE_TOKEN_TYPE_TRUE, "VALA_GENIE_TOKEN_TYPE_TRUE", "true"}, {VALA_GENIE_TOKEN_TYPE_TRY, "VALA_GENIE_TOKEN_TYPE_TRY", "try"}, {VALA_GENIE_TOKEN_TYPE_TYPEOF, "VALA_GENIE_TOKEN_TYPE_TYPEOF", "typeof"}, {VALA_GENIE_TOKEN_TYPE_USES, "VALA_GENIE_TOKEN_TYPE_USES", "uses"}, {VALA_GENIE_TOKEN_TYPE_VAR, "VALA_GENIE_TOKEN_TYPE_VAR", "var"}, {VALA_GENIE_TOKEN_TYPE_VIRTUAL, "VALA_GENIE_TOKEN_TYPE_VIRTUAL", "virtual"}, {VALA_GENIE_TOKEN_TYPE_VOID, "VALA_GENIE_TOKEN_TYPE_VOID", "void"}, {VALA_GENIE_TOKEN_TYPE_VOLATILE, "VALA_GENIE_TOKEN_TYPE_VOLATILE", "volatile"}, {VALA_GENIE_TOKEN_TYPE_WEAK, "VALA_GENIE_TOKEN_TYPE_WEAK", "weak"}, {VALA_GENIE_TOKEN_TYPE_WHEN, "VALA_GENIE_TOKEN_TYPE_WHEN", "when"}, {VALA_GENIE_TOKEN_TYPE_WHILE, "VALA_GENIE_TOKEN_TYPE_WHILE", "while"}, {VALA_GENIE_TOKEN_TYPE_WRITEONLY, "VALA_GENIE_TOKEN_TYPE_WRITEONLY", "writeonly"}, {0, NULL, NULL}};
		vala_genie_token_type_type_id = g_enum_register_static ("ValaGenieTokenType", values);
	}
	return vala_genie_token_type_type_id;
}




