/* valaccodecomment.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define VALA_TYPE_CCODE_NODE (vala_ccode_node_get_type ())
#define VALA_CCODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_NODE, ValaCCodeNode))
#define VALA_CCODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_NODE, ValaCCodeNodeClass))
#define VALA_IS_CCODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_NODE))
#define VALA_IS_CCODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_NODE))
#define VALA_CCODE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_NODE, ValaCCodeNodeClass))

typedef struct _ValaCCodeNode ValaCCodeNode;
typedef struct _ValaCCodeNodeClass ValaCCodeNodeClass;
typedef struct _ValaCCodeNodePrivate ValaCCodeNodePrivate;

#define VALA_TYPE_CCODE_WRITER (vala_ccode_writer_get_type ())
#define VALA_CCODE_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_WRITER, ValaCCodeWriter))
#define VALA_CCODE_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_WRITER, ValaCCodeWriterClass))
#define VALA_IS_CCODE_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_WRITER))
#define VALA_IS_CCODE_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_WRITER))
#define VALA_CCODE_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_WRITER, ValaCCodeWriterClass))

typedef struct _ValaCCodeWriter ValaCCodeWriter;
typedef struct _ValaCCodeWriterClass ValaCCodeWriterClass;

#define VALA_TYPE_CCODE_COMMENT (vala_ccode_comment_get_type ())
#define VALA_CCODE_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_COMMENT, ValaCCodeComment))
#define VALA_CCODE_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_COMMENT, ValaCCodeCommentClass))
#define VALA_IS_CCODE_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_COMMENT))
#define VALA_IS_CCODE_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_COMMENT))
#define VALA_CCODE_COMMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_COMMENT, ValaCCodeCommentClass))

typedef struct _ValaCCodeComment ValaCCodeComment;
typedef struct _ValaCCodeCommentClass ValaCCodeCommentClass;
typedef struct _ValaCCodeCommentPrivate ValaCCodeCommentPrivate;

/**
 * Represents a node in the C code tree.
 */
struct _ValaCCodeNode {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCCodeNodePrivate * priv;
};

struct _ValaCCodeNodeClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCCodeNode *self);
	void (*write) (ValaCCodeNode* self, ValaCCodeWriter* writer);
	void (*write_declaration) (ValaCCodeNode* self, ValaCCodeWriter* writer);
	void (*write_combined) (ValaCCodeNode* self, ValaCCodeWriter* writer);
};

/**
 * Represents a comment in the C code.
 */
struct _ValaCCodeComment {
	ValaCCodeNode parent_instance;
	ValaCCodeCommentPrivate * priv;
};

struct _ValaCCodeCommentClass {
	ValaCCodeNodeClass parent_class;
};

struct _ValaCCodeCommentPrivate {
	char* _text;
};



gpointer vala_ccode_node_ref (gpointer instance);
void vala_ccode_node_unref (gpointer instance);
GParamSpec* vala_param_spec_ccode_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_ccode_node (GValue* value, gpointer v_object);
gpointer vala_value_get_ccode_node (const GValue* value);
GType vala_ccode_node_get_type (void);
gpointer vala_ccode_writer_ref (gpointer instance);
void vala_ccode_writer_unref (gpointer instance);
GParamSpec* vala_param_spec_ccode_writer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_ccode_writer (GValue* value, gpointer v_object);
gpointer vala_value_get_ccode_writer (const GValue* value);
GType vala_ccode_writer_get_type (void);
GType vala_ccode_comment_get_type (void);
#define VALA_CCODE_COMMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_COMMENT, ValaCCodeCommentPrivate))
enum  {
	VALA_CCODE_COMMENT_DUMMY_PROPERTY
};
void vala_ccode_comment_set_text (ValaCCodeComment* self, const char* value);
ValaCCodeComment* vala_ccode_comment_new (const char* _text);
ValaCCodeComment* vala_ccode_comment_construct (GType object_type, const char* _text);
ValaCCodeComment* vala_ccode_comment_new (const char* _text);
void vala_ccode_writer_write_comment (ValaCCodeWriter* self, const char* text);
const char* vala_ccode_comment_get_text (ValaCCodeComment* self);
static void vala_ccode_comment_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer);
static gpointer vala_ccode_comment_parent_class = NULL;
static void vala_ccode_comment_finalize (ValaCCodeNode* obj);



ValaCCodeComment* vala_ccode_comment_construct (GType object_type, const char* _text) {
	ValaCCodeComment* self;
	g_return_val_if_fail (_text != NULL, NULL);
	self = (ValaCCodeComment*) g_type_create_instance (object_type);
	vala_ccode_comment_set_text (self, _text);
	return self;
}


ValaCCodeComment* vala_ccode_comment_new (const char* _text) {
	return vala_ccode_comment_construct (VALA_TYPE_CCODE_COMMENT, _text);
}


static void vala_ccode_comment_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer) {
	ValaCCodeComment * self;
	self = (ValaCCodeComment*) base;
	g_return_if_fail (writer != NULL);
	vala_ccode_writer_write_comment (writer, self->priv->_text);
}


const char* vala_ccode_comment_get_text (ValaCCodeComment* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_text;
}


void vala_ccode_comment_set_text (ValaCCodeComment* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_text = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), self->priv->_text = (g_free (self->priv->_text), NULL), _tmp2);
}


static void vala_ccode_comment_class_init (ValaCCodeCommentClass * klass) {
	vala_ccode_comment_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_NODE_CLASS (klass)->finalize = vala_ccode_comment_finalize;
	g_type_class_add_private (klass, sizeof (ValaCCodeCommentPrivate));
	VALA_CCODE_NODE_CLASS (klass)->write = vala_ccode_comment_real_write;
}


static void vala_ccode_comment_instance_init (ValaCCodeComment * self) {
	self->priv = VALA_CCODE_COMMENT_GET_PRIVATE (self);
}


static void vala_ccode_comment_finalize (ValaCCodeNode* obj) {
	ValaCCodeComment * self;
	self = VALA_CCODE_COMMENT (obj);
	self->priv->_text = (g_free (self->priv->_text), NULL);
	VALA_CCODE_NODE_CLASS (vala_ccode_comment_parent_class)->finalize (obj);
}


GType vala_ccode_comment_get_type (void) {
	static GType vala_ccode_comment_type_id = 0;
	if (vala_ccode_comment_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeCommentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_comment_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeComment), 0, (GInstanceInitFunc) vala_ccode_comment_instance_init, NULL };
		vala_ccode_comment_type_id = g_type_register_static (VALA_TYPE_CCODE_NODE, "ValaCCodeComment", &g_define_type_info, 0);
	}
	return vala_ccode_comment_type_id;
}




