/* valasourcefilecycle.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALA_VALASOURCEFILECYCLE_H__
#define __VALA_VALASOURCEFILECYCLE_H__

#include <glib.h>
#include <glib-object.h>
#include <gee/list.h>
#include <vala/valacodenode.h>

G_BEGIN_DECLS


#define VALA_TYPE_SOURCE_FILE_CYCLE (vala_source_file_cycle_get_type ())
#define VALA_SOURCE_FILE_CYCLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_FILE_CYCLE, ValaSourceFileCycle))
#define VALA_SOURCE_FILE_CYCLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_FILE_CYCLE, ValaSourceFileCycleClass))
#define VALA_IS_SOURCE_FILE_CYCLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_FILE_CYCLE))
#define VALA_IS_SOURCE_FILE_CYCLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_FILE_CYCLE))
#define VALA_SOURCE_FILE_CYCLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_FILE_CYCLE, ValaSourceFileCycleClass))

typedef struct _ValaSourceFileCyclePrivate ValaSourceFileCyclePrivate;
typedef struct _ValaParamSpecSourceFileCycle ValaParamSpecSourceFileCycle;

/**
 * Represents a dependency cycle of source files.
 */
struct _ValaSourceFileCycle {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaSourceFileCyclePrivate * priv;
	GeeList* files;
	ValaSourceFile* head;
};

struct _ValaSourceFileCycleClass {
	GTypeClass parent_class;
	void (*finalize) (ValaSourceFileCycle *self);
};

struct _ValaParamSpecSourceFileCycle {
	GParamSpec parent_instance;
};


ValaSourceFileCycle* vala_source_file_cycle_construct (GType object_type);
ValaSourceFileCycle* vala_source_file_cycle_new (void);
GParamSpec* vala_param_spec_source_file_cycle (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
gpointer vala_value_get_source_file_cycle (const GValue* value);
void vala_value_set_source_file_cycle (GValue* value, gpointer v_object);
GType vala_source_file_cycle_get_type (void);
gpointer vala_source_file_cycle_ref (gpointer instance);
void vala_source_file_cycle_unref (gpointer instance);


G_END_DECLS

#endif
