/* valadatatype.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#ifndef __VALA_VALADATATYPE_H__
#define __VALA_VALADATATYPE_H__

#include <glib.h>
#include <glib-object.h>
#include <gee/list.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valacodenode.h>

G_BEGIN_DECLS


#define VALA_TYPE_DATA_TYPE (vala_data_type_get_type ())
#define VALA_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DATA_TYPE, ValaDataType))
#define VALA_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))
#define VALA_IS_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DATA_TYPE))
#define VALA_IS_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DATA_TYPE))
#define VALA_DATA_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))

typedef struct _ValaDataTypePrivate ValaDataTypePrivate;

/**
 * A reference to a data type. This is used to specify static types of
 * expressions.
 */
struct _ValaDataType {
	ValaCodeNode parent_instance;
	ValaDataTypePrivate * priv;
};

struct _ValaDataTypeClass {
	ValaCodeNodeClass parent_class;
	char* (*get_cname) (ValaDataType* self);
	char* (*get_lower_case_cname) (ValaDataType* self, const char* infix);
	char* (*to_qualified_string) (ValaDataType* self, ValaScope* scope);
	ValaDataType* (*copy) (ValaDataType* self);
	gboolean (*equals) (ValaDataType* self, ValaDataType* type2);
	gboolean (*stricter) (ValaDataType* self, ValaDataType* type2);
	gboolean (*compatible) (ValaDataType* self, ValaDataType* target_type);
	gboolean (*is_invokable) (ValaDataType* self);
	ValaDataType* (*get_return_type) (ValaDataType* self);
	GeeList* (*get_parameters) (ValaDataType* self);
	gboolean (*is_reference_type_or_type_parameter) (ValaDataType* self);
	gboolean (*is_array) (ValaDataType* self);
	GeeList* (*get_symbols) (ValaDataType* self);
	ValaSymbol* (*get_member) (ValaDataType* self, const char* member_name);
	ValaSymbol* (*get_pointer_member) (ValaDataType* self, const char* member_name);
	gboolean (*is_real_struct_type) (ValaDataType* self);
	char* (*get_type_id) (ValaDataType* self);
	char* (*get_type_signature) (ValaDataType* self);
	gboolean (*is_disposable) (ValaDataType* self);
};


void vala_data_type_add_type_argument (ValaDataType* self, ValaDataType* arg);
GeeList* vala_data_type_get_type_arguments (ValaDataType* self);
void vala_data_type_remove_all_type_arguments (ValaDataType* self);
char* vala_data_type_get_cname (ValaDataType* self);
char* vala_data_type_get_const_cname (ValaDataType* self);
char* vala_data_type_get_lower_case_cname (ValaDataType* self, const char* infix);
char* vala_data_type_to_qualified_string (ValaDataType* self, ValaScope* scope);
ValaDataType* vala_data_type_copy (ValaDataType* self);
gboolean vala_data_type_equals (ValaDataType* self, ValaDataType* type2);
gboolean vala_data_type_stricter (ValaDataType* self, ValaDataType* type2);
gboolean vala_data_type_compatible (ValaDataType* self, ValaDataType* target_type);
gboolean vala_data_type_is_invokable (ValaDataType* self);
ValaDataType* vala_data_type_get_return_type (ValaDataType* self);
GeeList* vala_data_type_get_parameters (ValaDataType* self);
gboolean vala_data_type_is_reference_type_or_type_parameter (ValaDataType* self);
gboolean vala_data_type_is_array (ValaDataType* self);
GeeList* vala_data_type_get_symbols (ValaDataType* self);
ValaSymbol* vala_data_type_get_member (ValaDataType* self, const char* member_name);
ValaSymbol* vala_data_type_get_pointer_member (ValaDataType* self, const char* member_name);
gboolean vala_data_type_is_real_struct_type (ValaDataType* self);
char* vala_data_type_get_type_id (ValaDataType* self);
char* vala_data_type_get_type_signature (ValaDataType* self);
gboolean vala_data_type_is_disposable (ValaDataType* self);
ValaDataType* vala_data_type_get_actual_type (ValaDataType* self, ValaDataType* derived_instance_type, ValaCodeNode* node_reference);
gboolean vala_data_type_get_value_owned (ValaDataType* self);
void vala_data_type_set_value_owned (ValaDataType* self, gboolean value);
gboolean vala_data_type_get_nullable (ValaDataType* self);
void vala_data_type_set_nullable (ValaDataType* self, gboolean value);
ValaTypeSymbol* vala_data_type_get_data_type (ValaDataType* self);
void vala_data_type_set_data_type (ValaDataType* self, ValaTypeSymbol* value);
ValaTypeParameter* vala_data_type_get_type_parameter (ValaDataType* self);
void vala_data_type_set_type_parameter (ValaDataType* self, ValaTypeParameter* value);
gboolean vala_data_type_get_floating_reference (ValaDataType* self);
void vala_data_type_set_floating_reference (ValaDataType* self, gboolean value);
gboolean vala_data_type_get_is_dynamic (ValaDataType* self);
void vala_data_type_set_is_dynamic (ValaDataType* self, gboolean value);
GType vala_data_type_get_type (void);


G_END_DECLS

#endif
