/* valaccodeunaryexpression.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <ccode/valaccodeunaryexpression.h>
#include <stdlib.h>
#include <string.h>
#include <ccode/valaccodenode.h>




struct _ValaCCodeUnaryExpressionPrivate {
	ValaCCodeUnaryOperator _operator;
	ValaCCodeExpression* _inner;
};

#define VALA_CCODE_UNARY_EXPRESSION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_UNARY_EXPRESSION, ValaCCodeUnaryExpressionPrivate))
enum  {
	VALA_CCODE_UNARY_EXPRESSION_DUMMY_PROPERTY
};
static void vala_ccode_unary_expression_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer);
static void vala_ccode_unary_expression_real_write_inner (ValaCCodeExpression* base, ValaCCodeWriter* writer);
static gpointer vala_ccode_unary_expression_parent_class = NULL;
static void vala_ccode_unary_expression_finalize (ValaCCodeNode* obj);



ValaCCodeUnaryExpression* vala_ccode_unary_expression_construct (GType object_type, ValaCCodeUnaryOperator op, ValaCCodeExpression* expr) {
	ValaCCodeUnaryExpression* self;
	g_return_val_if_fail (expr != NULL, NULL);
	self = (ValaCCodeUnaryExpression*) g_type_create_instance (object_type);
	vala_ccode_unary_expression_set_operator (self, op);
	vala_ccode_unary_expression_set_inner (self, expr);
	return self;
}


ValaCCodeUnaryExpression* vala_ccode_unary_expression_new (ValaCCodeUnaryOperator op, ValaCCodeExpression* expr) {
	return vala_ccode_unary_expression_construct (VALA_TYPE_CCODE_UNARY_EXPRESSION, op, expr);
}


static void vala_ccode_unary_expression_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer) {
	ValaCCodeUnaryExpression * self;
	self = (ValaCCodeUnaryExpression*) base;
	g_return_if_fail (writer != NULL);
	if (self->priv->_operator == VALA_CCODE_UNARY_OPERATOR_PLUS) {
		vala_ccode_writer_write_string (writer, "+");
	} else {
		if (self->priv->_operator == VALA_CCODE_UNARY_OPERATOR_MINUS) {
			vala_ccode_writer_write_string (writer, "-");
		} else {
			if (self->priv->_operator == VALA_CCODE_UNARY_OPERATOR_LOGICAL_NEGATION) {
				vala_ccode_writer_write_string (writer, "!");
			} else {
				if (self->priv->_operator == VALA_CCODE_UNARY_OPERATOR_BITWISE_COMPLEMENT) {
					vala_ccode_writer_write_string (writer, "~");
				} else {
					if (self->priv->_operator == VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION) {
						vala_ccode_writer_write_string (writer, "*");
					} else {
						if (self->priv->_operator == VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF) {
							vala_ccode_writer_write_string (writer, "&");
						} else {
							if (self->priv->_operator == VALA_CCODE_UNARY_OPERATOR_PREFIX_INCREMENT) {
								vala_ccode_writer_write_string (writer, "++");
							} else {
								if (self->priv->_operator == VALA_CCODE_UNARY_OPERATOR_PREFIX_DECREMENT) {
									vala_ccode_writer_write_string (writer, "--");
								}
							}
						}
					}
				}
			}
		}
	}
	vala_ccode_expression_write_inner (self->priv->_inner, writer);
	if (self->priv->_operator == VALA_CCODE_UNARY_OPERATOR_POSTFIX_INCREMENT) {
		vala_ccode_writer_write_string (writer, "++");
	} else {
		if (self->priv->_operator == VALA_CCODE_UNARY_OPERATOR_POSTFIX_DECREMENT) {
			vala_ccode_writer_write_string (writer, "--");
		}
	}
}


static void vala_ccode_unary_expression_real_write_inner (ValaCCodeExpression* base, ValaCCodeWriter* writer) {
	ValaCCodeUnaryExpression * self;
	self = (ValaCCodeUnaryExpression*) base;
	g_return_if_fail (writer != NULL);
	vala_ccode_writer_write_string (writer, "(");
	vala_ccode_node_write ((ValaCCodeNode*) self, writer);
	vala_ccode_writer_write_string (writer, ")");
}


ValaCCodeUnaryOperator vala_ccode_unary_expression_get_operator (ValaCCodeUnaryExpression* self) {
	g_return_val_if_fail (self != NULL, 0);
	return self->priv->_operator;
}


void vala_ccode_unary_expression_set_operator (ValaCCodeUnaryExpression* self, ValaCCodeUnaryOperator value) {
	g_return_if_fail (self != NULL);
	self->priv->_operator = value;
}


ValaCCodeExpression* vala_ccode_unary_expression_get_inner (ValaCCodeUnaryExpression* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_inner;
}


void vala_ccode_unary_expression_set_inner (ValaCCodeUnaryExpression* self, ValaCCodeExpression* value) {
	ValaCCodeExpression* _tmp2;
	ValaCCodeExpression* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_inner = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : vala_ccode_node_ref (_tmp1)), (self->priv->_inner == NULL) ? NULL : (self->priv->_inner = (vala_ccode_node_unref (self->priv->_inner), NULL)), _tmp2);
}


static void vala_ccode_unary_expression_class_init (ValaCCodeUnaryExpressionClass * klass) {
	vala_ccode_unary_expression_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_NODE_CLASS (klass)->finalize = vala_ccode_unary_expression_finalize;
	g_type_class_add_private (klass, sizeof (ValaCCodeUnaryExpressionPrivate));
	VALA_CCODE_NODE_CLASS (klass)->write = vala_ccode_unary_expression_real_write;
	VALA_CCODE_EXPRESSION_CLASS (klass)->write_inner = vala_ccode_unary_expression_real_write_inner;
}


static void vala_ccode_unary_expression_instance_init (ValaCCodeUnaryExpression * self) {
	self->priv = VALA_CCODE_UNARY_EXPRESSION_GET_PRIVATE (self);
}


static void vala_ccode_unary_expression_finalize (ValaCCodeNode* obj) {
	ValaCCodeUnaryExpression * self;
	self = VALA_CCODE_UNARY_EXPRESSION (obj);
	(self->priv->_inner == NULL) ? NULL : (self->priv->_inner = (vala_ccode_node_unref (self->priv->_inner), NULL));
	VALA_CCODE_NODE_CLASS (vala_ccode_unary_expression_parent_class)->finalize (obj);
}


GType vala_ccode_unary_expression_get_type (void) {
	static GType vala_ccode_unary_expression_type_id = 0;
	if (vala_ccode_unary_expression_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeUnaryExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_unary_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeUnaryExpression), 0, (GInstanceInitFunc) vala_ccode_unary_expression_instance_init, NULL };
		vala_ccode_unary_expression_type_id = g_type_register_static (VALA_TYPE_CCODE_EXPRESSION, "ValaCCodeUnaryExpression", &g_define_type_info, 0);
	}
	return vala_ccode_unary_expression_type_id;
}



GType vala_ccode_unary_operator_get_type (void) {
	static GType vala_ccode_unary_operator_type_id = 0;
	if (G_UNLIKELY (vala_ccode_unary_operator_type_id == 0)) {
		static const GEnumValue values[] = {{VALA_CCODE_UNARY_OPERATOR_PLUS, "VALA_CCODE_UNARY_OPERATOR_PLUS", "plus"}, {VALA_CCODE_UNARY_OPERATOR_MINUS, "VALA_CCODE_UNARY_OPERATOR_MINUS", "minus"}, {VALA_CCODE_UNARY_OPERATOR_LOGICAL_NEGATION, "VALA_CCODE_UNARY_OPERATOR_LOGICAL_NEGATION", "logical-negation"}, {VALA_CCODE_UNARY_OPERATOR_BITWISE_COMPLEMENT, "VALA_CCODE_UNARY_OPERATOR_BITWISE_COMPLEMENT", "bitwise-complement"}, {VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, "VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION", "pointer-indirection"}, {VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, "VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF", "address-of"}, {VALA_CCODE_UNARY_OPERATOR_PREFIX_INCREMENT, "VALA_CCODE_UNARY_OPERATOR_PREFIX_INCREMENT", "prefix-increment"}, {VALA_CCODE_UNARY_OPERATOR_PREFIX_DECREMENT, "VALA_CCODE_UNARY_OPERATOR_PREFIX_DECREMENT", "prefix-decrement"}, {VALA_CCODE_UNARY_OPERATOR_POSTFIX_INCREMENT, "VALA_CCODE_UNARY_OPERATOR_POSTFIX_INCREMENT", "postfix-increment"}, {VALA_CCODE_UNARY_OPERATOR_POSTFIX_DECREMENT, "VALA_CCODE_UNARY_OPERATOR_POSTFIX_DECREMENT", "postfix-decrement"}, {0, NULL, NULL}};
		vala_ccode_unary_operator_type_id = g_enum_register_static ("ValaCCodeUnaryOperator", values);
	}
	return vala_ccode_unary_operator_type_id;
}




